/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account.iban;

import de.businesslogics.account.iban.BICConverter;
import de.businesslogics.account.iban.IBANConverter;
import de.businesslogics.account.iban.Reverse;
import de.businesslogics.account.iban.SEPABankConnection;
import de.businesslogics.account.iban.UCConverter;
import java.util.HashSet;
import java.util.Set;

@Reverse(blz=false)
public class Converter0034_00
extends BICConverter {
    private Set<String> pseudoAccountNumbers = new HashSet<String>();

    public Converter0034_00() {
        this.pseudoAccountNumbers.add("500500500");
        this.pseudoAccountNumbers.add("502");
    }

    @Override
    public SEPABankConnection convertAll(String blz, String kto) {
        String accNumber = IBANConverter.trimAccount(kto);
        String iban = null;
        if (accNumber.equals("500500500")) {
            iban = "DE82600202904340111112";
        } else if (accNumber.equals("502")) {
            iban = "DE28600202904340118001";
        } else {
            if (accNumber.length() == 9 && accNumber.charAt(0) == '8') {
                return null;
            }
            if (!this.isBankConnectionValid(blz, accNumber)) {
                return null;
            }
            if (accNumber.length() == 10 && (blz = UCConverter.getBlz(accNumber.substring(0, 3))) == null) {
                return null;
            }
            iban = this.calculateGermanIban(accNumber, blz);
        }
        if (iban == null) {
            return null;
        }
        if (this.pseudoAccountNumbers.contains(IBANConverter.trimAccount(kto))) {
            return new SEPABankConnection("HYVEDEMM473", iban);
        }
        return this.resultWithBLZ(iban, iban.substring(4, 12));
    }
}

