/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account.iban;

import de.businesslogics.account.iban.BICConverter;
import de.businesslogics.account.iban.IBANConverter;
import de.businesslogics.account.iban.Reverse;
import de.businesslogics.account.iban.SEPABankConnection;
import de.businesslogics.account.iban.UCConverter;
import java.util.HashMap;

@Reverse(blz=false)
public class Converter0033_00
extends BICConverter {
    private HashMap<String, String> pseudoAccountNumbers = new HashMap();

    public Converter0033_00() {
        this.pseudoAccountNumbers.put("22222", "DE11700202705803435253");
        this.pseudoAccountNumbers.put("1111111", "DE88700202700039908140");
        this.pseudoAccountNumbers.put("94", "DE83700202700002711931");
        this.pseudoAccountNumbers.put("7777777", "DE40700202705800522694");
        this.pseudoAccountNumbers.put("55555", "DE61700202705801800000");
    }

    @Override
    public SEPABankConnection convertAll(String blz, String kto) {
        String accNumber = IBANConverter.trimAccount(kto);
        if (this.pseudoAccountNumbers.containsKey(accNumber)) {
            return new SEPABankConnection("HYVEDEMMXXX", this.pseudoAccountNumbers.get(accNumber));
        }
        if (!this.isBankConnectionValid(blz, kto)) {
            return null;
        }
        if (accNumber.length() == 10 && (blz = UCConverter.getBlz(accNumber.substring(0, 3))) == null) {
            return null;
        }
        return this.resultWithBLZ(this.mod0000_00(blz, kto), blz);
    }
}

