/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account.iban;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Check_06;
import de.businesslogics.account.Check_63;
import de.businesslogics.account.Check_C7;
import de.businesslogics.account.Result;
import de.businesslogics.account.iban.IBANConverter;
import de.businesslogics.account.iban.Reverse;

@Reverse
public class Converter0020_01
extends IBANConverter {
    @Override
    public String convert(String blz, String kto) {
        this.resultCode = null;
        kto = IBANConverter.normalizeAccount((String)kto);
        if ("50070010".equals(blz) && "0000009999".equals(kto)) {
            return this.mod0000_00(blz, "92777202");
        }
        AccountCheckAlgorithm alg = this.getCheckAlgorithm(blz);
        if (alg instanceof Check_63 || alg instanceof Check_C7) {
            if (((String)kto).startsWith("000000")) {
                this.resultCode = 11;
                return null;
            }
            Check_63 c63 = new Check_63();
            if (((String)kto).startsWith("0000")) {
                if (Result.VALID.equals((Object)c63.checkFirstPartOnly((String)(kto = ((String)kto).substring(2) + "00")))) {
                    return this.mod0000_00(blz, (String)kto);
                }
                return null;
            }
            if (((String)kto).startsWith("000")) {
                String tmp;
                Result r;
                if (!((String)kto).endsWith("00") && Result.VALID.equals((Object)(r = c63.checkFirstPartOnly(tmp = ((String)kto).substring(2) + "00")))) {
                    return this.mod0000_00(blz, tmp);
                }
                Result r2 = c63.checkFirstPartOnly((String)kto);
                if (Result.VALID.equals((Object)r2)) {
                    return this.mod0000_00(blz, (String)kto);
                }
                this.resultCode = 11;
                return null;
            }
            Result r = c63.checkFirstPartOnly((String)kto);
            if (Result.VALID.equals((Object)r)) {
                return this.mod0000_00(blz, (String)kto);
            }
            this.resultCode = 11;
            return null;
        }
        if (alg instanceof Check_06) {
            this.resultCode = 12;
            return null;
        }
        return this.mod0000_00(blz, (String)kto);
    }
}

