/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account.iban;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Check_13;
import de.businesslogics.account.Check_76;
import de.businesslogics.account.Result;
import de.businesslogics.account.iban.BICConverter;
import de.businesslogics.account.iban.IBANConverter;
import de.businesslogics.account.iban.Reverse;
import de.businesslogics.account.iban.SEPABankConnection;
import de.businesslogics.util.StringUtils;

@Reverse
public class Converter0005_00
extends BICConverter {
    private static String[] BLZ_5_2_2 = new String[]{"10080900", "25780022", "42080082", "53080030", "64380011", "79080052", "12080000", "25980027", "42680081", "54080021", "65080009", "79380051", "13080000", "26080024", "43080083", "54280023", "65180005", "79580099", "14080000", "26281420", "44080055", "54580020", "65380003", "80080000", "15080000", "26580070", "44080057", "54680022", "66280053", "81080000", "16080000", "26880063", "44580070", "55080065", "66680013", "82080000", "17080000", "26981062", "45080060", "57080070", "67280051", "83080000", "18080000", "28280012", "46080010", "58580074", "69280035", "84080000", "20080055", "29280011", "47880031", "59080090", "70080056", "85080200", "20080057", "30080055", "49080025", "60080055", "70080057", "86080055", "21080050", "30080057", "50080055", "60080057", "70380006", "86080057", "21280002", "31080015", "50080057", "60380002", "71180005", "87080000", "21480003", "32080010", "50080081", "60480008", "72180002", "21580000", "33080030", "50080082", "61080006", "73180011", "22180000", "34080031", "50680002", "61281007", "73380004", "22181400", "34280032", "50780006", "61480001", "73480013", "22280000", "36280071", "50880050", "62080012", "74180009", "24080000", "36580072", "51080000", "62280012", "74380007", "24180001", "40080040", "51380040", "63080015", "75080003", "25480021", "41280043", "52080080", "64080014", "76080053"};

    @Override
    public SEPABankConnection convertAll(String blz, String kto) {
        if (kto != null && ((String)kto).length() == 13) {
            kto = ((String)kto).substring(3);
        }
        if (((String)(kto = IBANConverter.normalizeAccount((String)kto))).compareTo("0998000000") >= 0 && ((String)kto).compareTo("0999499999") <= 0 && StringUtils.isContainedInArray(blz, BLZ_5_2_2)) {
            return null;
        }
        if ("50040033".equals(blz)) {
            return null;
        }
        if ("30040000".equals(blz) && "0000000036".equals(kto)) {
            kto = "0002611036";
        } else if ("47880031".equals(blz) && "0000000050".equals(kto)) {
            kto = "0519899900";
        } else if ("47840065".equals(blz) && "0000000050".equals(kto)) {
            kto = "0001501030";
        } else if ("47840065".equals(blz) && "0000000055".equals(kto)) {
            kto = "0001501030";
        } else if ("70080000".equals(blz) && "0000000094".equals(kto)) {
            kto = "0928553201";
        } else if ("70040041".equals(blz) && "0000000094".equals(kto)) {
            kto = "0002128080";
        } else if ("47840065".equals(blz) && "0000000099".equals(kto)) {
            kto = "0001501030";
        } else if ("37080040".equals(blz) && "0000000100".equals(kto)) {
            kto = "0269100000";
        } else if ("38040007".equals(blz) && "0000000100".equals(kto)) {
            kto = "0119160000";
        } else if ("37080040".equals(blz) && "0000000111".equals(kto)) {
            kto = "0215022000";
        } else if ("51080060".equals(blz) && "0000000123".equals(kto)) {
            kto = "0012299300";
        } else if ("36040039".equals(blz) && "0000000150".equals(kto)) {
            kto = "0001616200";
        } else if ("68080030".equals(blz) && "0000000202".equals(kto)) {
            kto = "0416520200";
        } else if ("30040000".equals(blz) && "0000000222".equals(kto)) {
            kto = "0348010002";
        } else if ("38040007".equals(blz) && "0000000240".equals(kto)) {
            kto = "0001090240";
        } else if ("69240075".equals(blz) && "0000000444".equals(kto)) {
            kto = "0004455200";
        } else if ("60080000".equals(blz) && "0000000502".equals(kto)) {
            kto = "0901581400";
        } else if ("60040071".equals(blz) && "0000000502".equals(kto)) {
            kto = "0005259502";
        } else if ("55040022".equals(blz) && "0000000555".equals(kto)) {
            kto = "0211050000";
        } else if ("39080005".equals(blz) && "0000000556".equals(kto)) {
            kto = "0204655600";
        } else if ("39040013".equals(blz) && "0000000556".equals(kto)) {
            kto = "0001065556";
        } else if ("57080070".equals(blz) && "0000000661".equals(kto)) {
            kto = "0604101200";
        } else if ("26580070".equals(blz) && "0000000700".equals(kto)) {
            kto = "0710000000";
        } else if ("50640015".equals(blz) && "0000000777".equals(kto)) {
            kto = "0002222222";
        } else if ("30040000".equals(blz) && "0000000999".equals(kto)) {
            kto = "0001237999";
        } else if ("86080000".equals(blz) && "0000001212".equals(kto)) {
            kto = "0480375900";
        } else if ("37040044".equals(blz) && "0000001888".equals(kto)) {
            kto = "0212129101";
        } else if ("25040066".equals(blz) && "0000001919".equals(kto)) {
            kto = "0001419191";
        } else if ("10080000".equals(blz) && "0000001987".equals(kto)) {
            kto = "0928127700";
        } else if ("50040000".equals(blz) && "0000002000".equals(kto)) {
            kto = "0007284003";
        } else if ("20080000".equals(blz) && "0000002222".equals(kto)) {
            kto = "0903927200";
        } else if ("38040007".equals(blz) && "0000003366".equals(kto)) {
            kto = "0003853330";
        } else if ("37080040".equals(blz) && "0000004004".equals(kto)) {
            kto = "0233533500";
        } else if ("37080040".equals(blz) && "0000004444".equals(kto)) {
            kto = "0233000300";
        } else if ("43080083".equals(blz) && "0000004630".equals(kto)) {
            kto = "0825110100";
        } else if ("50080000".equals(blz) && "0000006060".equals(kto)) {
            kto = "0096736100";
        } else if ("10040000".equals(blz) && "0000007878".equals(kto)) {
            kto = "0002678787";
        } else if ("10080000".equals(blz) && "0000008888".equals(kto)) {
            kto = "0928126501";
        } else if ("50080000".equals(blz) && "0000009000".equals(kto)) {
            kto = "0026492100";
        } else if ("79080052".equals(blz) && "0000009696".equals(kto)) {
            kto = "0300021700";
        } else if ("79040047".equals(blz) && "0000009696".equals(kto)) {
            kto = "0006802102";
        } else if ("39080005".equals(blz) && "0000009800".equals(kto)) {
            kto = "0208457000";
        } else if ("50080000".equals(blz) && "0000042195".equals(kto)) {
            kto = "0900333200";
        } else if ("32040024".equals(blz) && "0000047800".equals(kto)) {
            kto = "0001555150";
        } else if ("37080040".equals(blz) && "0000055555".equals(kto)) {
            kto = "0263602501";
        } else if ("38040007".equals(blz) && "0000055555".equals(kto)) {
            kto = "0003055555";
        } else if ("50080000".equals(blz) && "0000101010".equals(kto)) {
            kto = "0090003500";
        } else if ("50040000".equals(blz) && "0000101010".equals(kto)) {
            kto = "0003110111";
        } else if ("37040044".equals(blz) && "0000102030".equals(kto)) {
            kto = "0002223444";
        } else if ("86080000".equals(blz) && "0000121200".equals(kto)) {
            kto = "0480375900";
        } else if ("66280053".equals(blz) && "0000121212".equals(kto)) {
            kto = "0625242400";
        } else if ("16080000".equals(blz) && "0000123456".equals(kto)) {
            kto = "0012345600";
        } else if ("29080010".equals(blz) && "0000124124".equals(kto)) {
            kto = "0107502000";
        } else if ("37080040".equals(blz) && "0000182002".equals(kto)) {
            kto = "0216603302";
        } else if ("12080000".equals(blz) && "0000212121".equals(kto)) {
            kto = "4050462200";
        } else if ("37080040".equals(blz) && "0000300000".equals(kto)) {
            kto = "0983307900";
        } else if ("37040044".equals(blz) && "0000300000".equals(kto)) {
            kto = "0003000007";
        } else if ("37080040".equals(blz) && "0000333333".equals(kto)) {
            kto = "0270330000";
        } else if ("38040007".equals(blz) && "0000336666".equals(kto)) {
            kto = "0001052323";
        } else if ("55040022".equals(blz) && "0000343434".equals(kto)) {
            kto = "0217900000";
        } else if ("85080000".equals(blz) && "0000400000".equals(kto)) {
            kto = "0459488501";
        } else if ("37080040".equals(blz) && "0000414141".equals(kto)) {
            kto = "0041414100";
        } else if ("38040007".equals(blz) && "0000414141".equals(kto)) {
            kto = "0001080001";
        } else if ("20080000".equals(blz) && "0000505050".equals(kto)) {
            kto = "0500100600";
        } else if ("37080040".equals(blz) && "0000555666".equals(kto)) {
            kto = "0055566600";
        } else if ("20080000".equals(blz) && "0000666666".equals(kto)) {
            kto = "0900732500";
        } else if ("30080000".equals(blz) && "0000700000".equals(kto)) {
            kto = "0800005000";
        } else if ("70080000".equals(blz) && "0000700000".equals(kto)) {
            kto = "0750055500";
        } else if ("70080000".equals(blz) && "0000900000".equals(kto)) {
            kto = "0319966601";
        } else if ("37080040".equals(blz) && "0000909090".equals(kto)) {
            kto = "0269100000";
        } else if ("38040007".equals(blz) && "0000909090".equals(kto)) {
            kto = "0119160000";
        } else if ("70080000".equals(blz) && "0000949494".equals(kto)) {
            kto = "0575757500";
        } else if ("70080000".equals(blz) && "0001111111".equals(kto)) {
            kto = "0448060000";
        } else if ("70040041".equals(blz) && "0001111111".equals(kto)) {
            kto = "0001521400";
        } else if ("10080000".equals(blz) && "0001234567".equals(kto)) {
            kto = "0920192001";
        } else if ("38040007".equals(blz) && "0001555555".equals(kto)) {
            kto = "0002582666";
        } else if ("76040061".equals(blz) && "0002500000".equals(kto)) {
            kto = "0004821468";
        } else if ("16080000".equals(blz) && "0003030400".equals(kto)) {
            kto = "4205227110";
        } else if ("37080040".equals(blz) && "0005555500".equals(kto)) {
            kto = "0263602501";
        } else if ("75040062".equals(blz) && "0006008833".equals(kto)) {
            kto = "0600883300";
        } else if ("12080000".equals(blz) && "0007654321".equals(kto)) {
            kto = "0144000700";
        } else if ("70080000".equals(blz) && "0007777777".equals(kto)) {
            kto = "0443540000";
        } else if ("70040041".equals(blz) && "0007777777".equals(kto)) {
            kto = "0002136000";
        } else if ("64140036".equals(blz) && "0008907339".equals(kto)) {
            kto = "0890733900";
        } else if ("70080000".equals(blz) && "0009000000".equals(kto)) {
            kto = "0319966601";
        } else if ("61080006".equals(blz) && "0009999999".equals(kto)) {
            kto = "0202427500";
        } else if ("12080000".equals(blz) && "0012121212".equals(kto)) {
            kto = "4101725100";
        } else if ("29080010".equals(blz) && "0012412400".equals(kto)) {
            kto = "0107502000";
        } else if ("34280032".equals(blz) && "0014111935".equals(kto)) {
            kto = "0645753800";
        } else if ("38040007".equals(blz) && "0043434343".equals(kto)) {
            kto = "0001181635";
        } else if ("30080000".equals(blz) && "0070000000".equals(kto)) {
            kto = "0800005000";
        } else if ("70080000".equals(blz) && "0070000000".equals(kto)) {
            kto = "0750055500";
        } else if ("44040037".equals(blz) && "0111111111".equals(kto)) {
            kto = "0003205655";
        } else if ("70040041".equals(blz) && "0400500500".equals(kto)) {
            kto = "0004005005";
        } else if ("60080000".equals(blz) && "0500500500".equals(kto)) {
            kto = "0901581400";
        } else if ("60040071".equals(blz) && "0500500500".equals(kto)) {
            kto = "0005127006";
        }
        AccountCheckAlgorithm alg = this.getCheckAlgorithm(blz);
        if (alg instanceof Check_13) {
            String trim = Converter0005_00.trimAccount((String)kto);
            if ((trim.length() == 6 || trim.length() == 7) && Result.VALID.equals((Object)alg.check(trim + "00", blz))) {
                kto = trim + "00";
            }
        } else if (alg instanceof Check_76) {
            Result r = alg.check((String)kto, blz);
            if (Result.INVALID.equals((Object)r)) {
                String trim = Converter0005_00.trimAccount((String)kto);
                if (trim.length() <= 8 && Result.VALID.equals((Object)alg.check(trim + "00", blz))) {
                    kto = trim + "00";
                }
            } else if (Result.UNKNOWN.equals((Object)r)) {
                return null;
            }
        }
        if (blz.charAt(3) == '4') {
            if ("20041111".equals(blz) || "20041133".equals(blz) || "20041144".equals(blz) || "20041155".equals(blz)) {
                return this.resultWithBLZ(this.mod0000_00(blz, (String)kto), blz);
            }
            return this.result("COBADEFFXXX", this.mod0000_00(blz, (String)kto));
        }
        return this.resultWithBLZ(this.mod0000_00(blz, (String)kto), blz);
    }
}

