/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account.iban;

import de.businesslogics.account.BankInfo;
import de.businesslogics.account.iban.IBANConverter;
import de.businesslogics.account.iban.SEPABankConnection;

public abstract class BICConverter
extends IBANConverter {
    @Override
    public final String convert(String blz, String kto) {
        SEPABankConnection c = this.convertAll(blz, kto);
        if (c != null) {
            return c.getIban();
        }
        return null;
    }

    public abstract SEPABankConnection convertAll(String var1, String var2);

    protected SEPABankConnection result(String bic, String iban) {
        if (iban == null) {
            return null;
        }
        return new SEPABankConnection(bic, iban);
    }

    protected SEPABankConnection resultWithBLZ(String iban, String blz) {
        if (iban == null) {
            return null;
        }
        BankInfo info = IBANConverter.BLZ_CACHE.getBankInfo(blz);
        if (info != null) {
            return new SEPABankConnection(info.getBicCode(), iban);
        }
        return null;
    }
}

