/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Result;

public class Check_E1
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{9, 10, 11, 6, 5, 4, 3, 2, 1};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int sum = 0;
        for (int i = 0; i < 9; ++i) {
            sum += number.charAt(i) * WEIGHT[i];
        }
        int rest = sum % 11;
        if (rest > 9) {
            return Result.INVALID;
        }
        if (48 + rest == number.charAt(9)) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

