/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Check_06;
import de.businesslogics.account.Result;

public class Check_D5
extends AccountCheckAlgorithm {
    private static int[] WEIGHT_1 = new int[]{2, 3, 4, 5, 6, 7, 8, 0, 0};
    private static int[] WEIGHT_2 = new int[]{2, 3, 4, 5, 6, 7, 0, 0, 0};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        if ((number = this.addLeadingZeroes(number)).substring(2, 4).equals("99")) {
            return new Version1().check(number);
        }
        Result r = new Version2().check(number);
        if (Result.INVALID.equals((Object)r)) {
            int res = 0;
            int y = 0;
            for (int i = number.length() - 2; i >= 0; --i) {
                if (!Character.isDigit(number.charAt(i))) {
                    return Result.INVALID;
                }
                int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
                int v2 = WEIGHT_2[y];
                int v3 = v1 * v2;
                res += v3;
                ++y;
            }
            int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
            int result = res % 7;
            if (result == 0 && checkDigit == 0) {
                return Result.VALID;
            }
            if (7 - result == checkDigit) {
                return Result.VALID;
            }
            result = res % 10;
            if (result == 0 && checkDigit == 0) {
                return Result.VALID;
            }
            if (10 - result == checkDigit) {
                return Result.VALID;
            }
        }
        return r;
    }

    private static class Version1
    extends Check_06 {
        private Version1() {
        }

        @Override
        protected int[] getWeight() {
            return WEIGHT_1;
        }
    }

    private static class Version2
    extends Check_06 {
        private Version2() {
        }

        @Override
        protected int[] getWeight() {
            return WEIGHT_1;
        }
    }
}

