/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Check_00;
import de.businesslogics.account.Check_09;
import de.businesslogics.account.Check_29;
import de.businesslogics.account.Check_75;
import de.businesslogics.account.Result;

public class Check_C5
extends AccountCheckAlgorithm {
    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.removeLeadingZeroes(number);
        try {
            long n = Long.parseLong(number);
            if (n >= 100000L && n <= 899999L || n >= 100000000L && n <= 899999999L) {
                return new Check_75().check(number);
            }
            if (n >= 1000000000L && n <= 1999999999L || n >= 4000000000L && n <= 6999999999L || n >= 9000000000L && n <= 9999999999L) {
                return new Check_29().check(number);
            }
            if (n >= 3000000000L && n <= 3999999999L) {
                return new Check_00().check(number);
            }
            if (n >= 7000000000L && n <= 7099999999L || n >= 8500000000L && n <= 8999999999L || n >= 30000000L && n <= 59999999L) {
                return new Check_09().check(number);
            }
            return Result.INVALID;
        }
        catch (Exception e) {
            return Result.INVALID;
        }
    }
}

