/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Result;

public class Check_B9
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{1, 3, 2, 1, 3, 2, 1};
    private static int[] WEIGHT2 = new int[]{1, 2, 3, 4, 5, 6};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        if ((number = this.removeLeadingZeroes(number)).length() == 8) {
            return this.internalCheck1(number);
        }
        if (number.length() == 7) {
            return this.internalCheck2(number);
        }
        return Result.INVALID;
    }

    protected Result internalCheck1(String number) {
        int result;
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= 2; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = WEIGHT[y];
            int v3 = v1 * v2 + v2;
            int v4 = v3 % 11;
            res += v4;
            ++y;
        }
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
        if (checkDigit == (result = res % 10)) {
            return Result.VALID;
        }
        if ((result += 5) >= 10) {
            result -= 10;
        }
        if (checkDigit == result) {
            return Result.VALID;
        }
        return Result.INVALID;
    }

    protected Result internalCheck2(String number) {
        int result;
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= 3; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = WEIGHT2[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
        if (checkDigit == (result = res % 11)) {
            return Result.VALID;
        }
        if ((result += 5) >= 10) {
            result -= 10;
        }
        if (checkDigit == result) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

