/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Check_00;
import de.businesslogics.account.Result;

public class Check_B5
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{7, 3, 1, 7, 3, 1, 7, 3, 1};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        Result r = this.internalCheck(number = this.addLeadingZeroes(number));
        if (!Result.VALID.equals((Object)r)) {
            if (number.charAt(0) == '8' || number.charAt(0) == '9') {
                return Result.INVALID;
            }
            return new Check_00().check(number);
        }
        return r;
    }

    protected Result internalCheck(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= 0; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = WEIGHT[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        String x = String.valueOf(res);
        int v6 = Integer.parseInt(x.substring(x.length() - 1));
        int checkDigit = Integer.parseInt(number.substring(number.length() - 1));
        if (v6 == 0 && checkDigit == v6) {
            return Result.VALID;
        }
        if (checkDigit == 10 - v6) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

