/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.Check_93;
import de.businesslogics.account.Result;

public class Check_A4
extends Check_93 {
    private static int[] WEIGHT = new int[]{2, 3, 4, 5, 6, 0};
    private static int[] WEIGHT2 = new int[]{2, 3, 4, 5, 6, 7};

    @Override
    protected int[] getWeight() {
        return WEIGHT;
    }

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        Result r = null;
        if (number.charAt(2) != '9' || number.charAt(3) != '9') {
            r = this.internalCheck5(number, 3, 11);
            if (!r.equals((Object)Result.VALID)) {
                r = this.internalCheck5(number, 3, 7);
            }
        } else {
            r = this.internalCheck5(number, 4, 11);
        }
        if (!r.equals((Object)Result.VALID)) {
            return super.check(number);
        }
        return r;
    }

    private Result internalCheck5(String number, int digit, int modulus) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= digit; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = WEIGHT2[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
        int result = res % modulus;
        if ((result != 1 || modulus < 10) && checkDigit == modulus - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        if (result == 1 && checkDigit == 0 && modulus > 10) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

