/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Result;

public class Check_93
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{2, 3, 4, 5, 6, 7};

    protected int[] getWeight() {
        return WEIGHT;
    }

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        Result r = null;
        r = number.startsWith("0000") ? this.internalCheck1(number, 4, 11) : this.internalCheck1(number, 0, 11);
        if (!r.equals((Object)Result.VALID)) {
            r = number.startsWith("0000") ? this.internalCheck1(number, 4, 7) : this.internalCheck1(number, 0, 7);
        }
        return r;
    }

    private Result internalCheck1(String number, int digit, int modulus) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = digit + 4; i >= digit; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = this.getWeight()[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(digit + 5)));
        int result = res % modulus;
        if ((result != 1 || modulus < 10) && checkDigit == modulus - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        if (result == 1 && checkDigit == 0 && modulus > 10) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

