/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Result;

public class Check_91
extends AccountCheckAlgorithm {
    private static int[][] MAPPING = new int[][]{{2, 3, 4, 5, 6, 7, 0, 0, 0, 0}, {7, 6, 5, 4, 3, 2, 0, 0, 0, 0}, {2, 3, 4, 0, 5, 6, 7, 8, 9, 10}, {2, 4, 8, 5, 10, 9, 0, 0, 0, 0}};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        Result r = this.internalCheck(number = this.addLeadingZeroes(number), 5, 0);
        if (!r.equals((Object)Result.VALID)) {
            Result r2 = this.internalCheck(number, 5, 1);
            if (!r2.equals((Object)Result.VALID)) {
                Result r3 = this.internalCheck(number, 1, 2);
                if (!r3.equals((Object)Result.VALID)) {
                    return this.internalCheck(number, 5, 3);
                }
                return r3;
            }
            return r2;
        }
        return r;
    }

    private Result internalCheck(String number, int digit, int weight) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(6)));
        int res = 0;
        int y = 0;
        for (int i = number.length() - digit; i >= 0; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = MAPPING[weight][y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int result = res % 11;
        if (result == 1) {
            if (checkDigit == 0) {
                return Result.VALID;
            }
            return Result.INVALID;
        }
        if (result != 0 && checkDigit == 11 - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

