/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Result;

public class Check_90
extends AccountCheckAlgorithm {
    private static int[] WEIGHT2 = new int[]{2, 1, 2, 1, 2, 1};
    private static int[] WEIGHT = new int[]{2, 3, 4, 5, 6, 7, 8};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        if ((number = this.addLeadingZeroes(number)).charAt(2) == '9') {
            return this.internalCheck(number, 2, 11, WEIGHT);
        }
        Result r = this.internalCheck(number, 3, 11, WEIGHT);
        if (!r.equals((Object)Result.VALID)) {
            Result r2 = this.internalCheck(number, 4, 11, WEIGHT);
            if (!r2.equals((Object)Result.VALID)) {
                Result r3 = this.internalCheck(number, 4, 7, WEIGHT);
                if (!r3.equals((Object)Result.VALID)) {
                    Result r4 = this.internalCheck(number, 4, 9, WEIGHT);
                    if (!r4.equals((Object)Result.VALID)) {
                        Result r5 = this.internalCheck(number, 4, 10, WEIGHT2);
                        if (!r5.equals((Object)Result.VALID)) {
                            return this.internalCheck(number, 3, 7, WEIGHT2);
                        }
                        return r5;
                    }
                    return r4;
                }
                return r3;
            }
            return r2;
        }
        return r;
    }

    private Result internalCheck(String number, int digit, int modulus, int[] weight) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
        if (modulus == 7 && (checkDigit == 7 || checkDigit == 8 || checkDigit == 9)) {
            return Result.INVALID;
        }
        if (modulus == 9 && checkDigit == 9) {
            return Result.INVALID;
        }
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= digit; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = weight[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int result = res % modulus;
        if (modulus == 11 && result == 1) {
            if (checkDigit == 0) {
                return Result.VALID;
            }
            return Result.INVALID;
        }
        if (result != 0 && checkDigit == modulus - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

