/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Result;

public class Check_88
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{2, 3, 4, 5, 6, 7};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= 3; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = WEIGHT[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        if (number.charAt(2) == '9') {
            res += 72;
        }
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
        int result = res % 11;
        if (result != 1 && checkDigit == 11 - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        if (result == 1 && checkDigit == 0) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

