/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Check_06;
import de.businesslogics.account.Check_33;
import de.businesslogics.account.Check_51;
import de.businesslogics.account.Result;

public class Check_87
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{2, 3, 4, 5, 6};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        if ((number = this.addLeadingZeroes(number)).charAt(2) == '9') {
            return new Check_51().check(number);
        }
        Result r = this.internalCheck(number);
        if (!(r.equals((Object)Result.VALID) || (r = new Check_33().check(number)).equals((Object)Result.VALID) || (r = this.internalCheck2(number)).equals((Object)Result.VALID))) {
            return new Check_06_87().check(number);
        }
        return r;
    }

    private Result internalCheck(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int i = 3;
        int p = 0;
        int[] n = new int[10];
        for (int x = 0; x <= 9; ++x) {
            try {
                n[x] = Integer.parseInt(String.valueOf(number.charAt(x)));
                continue;
            }
            catch (Exception e) {
                return Result.INVALID;
            }
        }
        while (i <= 9 && n[i] == 0) {
            ++i;
        }
        int c2 = 1 - i % 2;
        int d2 = 0;
        int a5 = 0;
        int[] m1 = new int[]{0, 4, 3, 2, 6};
        int[] m2 = new int[]{7, 1, 5, 9, 8};
        while (i < 9) {
            switch (n[i]) {
                case 0: {
                    n[i] = 5;
                    break;
                }
                case 1: {
                    n[i] = 6;
                    break;
                }
                case 5: {
                    n[i] = 10;
                    break;
                }
                case 6: {
                    n[i] = 1;
                }
            }
            if (c2 == d2) {
                if (n[i] > 5) {
                    if (c2 == 0 && d2 == 0) {
                        c2 = 1;
                        d2 = 1;
                        a5 = a5 + 6 - (n[i] - 6);
                    } else {
                        c2 = 0;
                        d2 = 0;
                        a5 += n[i];
                    }
                } else if (c2 == 0 && d2 == 0) {
                    c2 = 1;
                    a5 += n[i];
                } else {
                    c2 = 0;
                    a5 += n[i];
                }
            } else if (n[i] > 5) {
                if (c2 == 0) {
                    c2 = 1;
                    d2 = 0;
                    a5 = a5 - 6 + (n[i] - 6);
                } else {
                    c2 = 0;
                    d2 = 1;
                    a5 -= n[i];
                }
            } else if (c2 == 0) {
                c2 = 1;
                a5 -= n[i];
            } else {
                c2 = 0;
                a5 -= n[i];
            }
            ++i;
        }
        while (a5 < 0 || a5 > 4) {
            if (a5 > 4) {
                a5 -= 5;
                continue;
            }
            a5 += 5;
        }
        p = d2 == 0 ? m1[a5] : m2[a5];
        if (p == n[9]) {
            return Result.VALID;
        }
        if (n[3] == 0) {
            p = p > 4 ? (p -= 5) : (p += 5);
            if (p == n[9]) {
                return Result.VALID;
            }
        }
        return Result.INVALID;
    }

    private Result internalCheck2(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= 4; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = WEIGHT[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
        int result = res % 7;
        if (result != 0 && checkDigit == 7 - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        return Result.INVALID;
    }

    private static class Check_06_87
    extends Check_06 {
        private static int[] WEIGHT_06_87 = new int[]{2, 3, 4, 5, 6, 7, 0, 0, 0};

        private Check_06_87() {
        }

        @Override
        protected int[] getWeight() {
            return WEIGHT_06_87;
        }
    }
}

