/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Check_33;
import de.businesslogics.account.Check_51;
import de.businesslogics.account.Result;

public class Check_84
extends AccountCheckAlgorithm {
    private static int[] WEIGHT_B = new int[]{2, 3, 4, 5, 6};
    private static int[] WEIGHT_C = new int[]{2, 1, 2, 1, 2};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        if ((number = this.addLeadingZeroes(number)).charAt(2) == '9') {
            return new Check_51().check(number);
        }
        Result r = new Check_33().check(number);
        if (!r.equals((Object)Result.VALID)) {
            Result r2 = this.internalCheck_B(number);
            if (!r2.equals((Object)Result.VALID)) {
                return this.internalCheck_C(number);
            }
            return r2;
        }
        return r;
    }

    private Result internalCheck_B(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= 4; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = WEIGHT_B[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
        int result = res % 7;
        if (result != 0 && checkDigit == 7 - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        return Result.INVALID;
    }

    private Result internalCheck_C(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= 4; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = WEIGHT_C[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
        int result = res % 10;
        if (result != 0 && checkDigit == 10 - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

