/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Check_32;
import de.businesslogics.account.Result;

public class Check_83
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{2, 3, 4, 5, 6};
    private static int[] WEIGHT3 = new int[]{2, 3, 4, 5, 6, 7, 8};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        if ((number = this.addLeadingZeroes(number)).charAt(2) == '9' && number.charAt(3) == '9') {
            return this.internalCheck3(number);
        }
        Result r = new Check_32().check(number);
        if (!r.equals((Object)Result.VALID)) {
            Result r2 = this.internalCheck2(number, 11);
            if (!r2.equals((Object)Result.VALID)) {
                if (number.charAt(9) == '7' || number.charAt(9) == '8' || number.charAt(9) == '9') {
                    return Result.INVALID;
                }
                return this.internalCheck2(number, 7);
            }
            return r2;
        }
        return r;
    }

    private Result internalCheck2(String number, int modulus) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= 4; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = WEIGHT[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(number.substring(number.length() - 1));
        int result = res % modulus;
        if (modulus == 11) {
            if (result != 1 && checkDigit == modulus - result) {
                return Result.VALID;
            }
            if (result == 0 && checkDigit == 0) {
                return Result.VALID;
            }
            if (result == 1 && checkDigit == 0) {
                return Result.VALID;
            }
        } else {
            if (result != 0 && checkDigit == modulus - result) {
                return Result.VALID;
            }
            if (result == 0 && checkDigit == 0) {
                return Result.VALID;
            }
        }
        return Result.INVALID;
    }

    private Result internalCheck3(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= 2; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = WEIGHT3[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
        int result = res % 11;
        if (result != 1 && checkDigit == 11 - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        if (result == 1 && checkDigit == 0) {
            return Result.VALID;
        }
        return Result.UNKNOWN;
    }
}

