/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Result;

public class Check_75
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{2, 1, 2, 1, 2, 1, 2, 1, 2};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        if ((number = this.removeLeadingZeroes(number)).length() == 6) {
            return this.internalCheck(number, 4);
        }
        if (number.length() == 7) {
            return this.internalCheck(number, 4);
        }
        if (number.length() == 9 && number.charAt(0) == '9') {
            return this.internalCheck(number, 2);
        }
        if (number.length() == 9) {
            return this.internalCheck(number, 1);
        }
        return Result.INVALID;
    }

    protected Result internalCheck(String number, int digit) {
        int i = digit;
        int y = 0;
        int res = 0;
        number = this.addLeadingZeroes(number);
        int end = number.length() - 2;
        if (digit == 2) {
            end -= 2;
        } else if (digit == 1) {
            end -= 3;
        }
        while (i <= end) {
            int v2;
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v3 = v1 * (v2 = WEIGHT[y]);
            if (v3 > 9) {
                int v4 = Integer.parseInt(String.valueOf(v3).substring(0, 1));
                int v5 = Integer.parseInt(String.valueOf(v3).substring(1));
                v3 = v4 + v5;
            }
            res += v3;
            ++y;
            ++i;
        }
        String x = String.valueOf(res);
        int v6 = Integer.parseInt(x.substring(x.length() - 1));
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(5 + digit)));
        if (v6 == 0 && checkDigit == v6) {
            return Result.VALID;
        }
        if (checkDigit == 10 - v6) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

