/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Check_51;
import de.businesslogics.account.Result;

public class Check_73
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{2, 1, 2, 1, 2, 1, 2, 1, 2};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        if ((number = this.addLeadingZeroes(number)).charAt(2) == '9') {
            return new Check_51().check(number);
        }
        Result r = this.internalCheck(number, 3, 10);
        if (!r.equals((Object)Result.VALID)) {
            Result r2 = this.internalCheck(number, 4, 10);
            if (!r2.equals((Object)Result.VALID)) {
                return this.internalCheck(number, 4, 7);
            }
            return r2;
        }
        return r;
    }

    private Result internalCheck(String number, int digit, int modulus) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int y = 0;
        int res = 0;
        for (int i = number.length() - 2; i >= digit; --i) {
            int v2;
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v3 = v1 * (v2 = WEIGHT[y]);
            if (v3 > 9) {
                int v4 = Integer.parseInt(String.valueOf(v3).substring(0, 1));
                int v5 = Integer.parseInt(String.valueOf(v3).substring(1));
                v3 = v4 + v5;
            }
            res += v3;
            ++y;
        }
        String x = String.valueOf(res);
        int v6 = Integer.parseInt(x.substring(x.length() - 1));
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
        if (modulus == 10) {
            if (v6 == 0 && checkDigit == v6) {
                return Result.VALID;
            }
            if (checkDigit == 10 - v6) {
                return Result.VALID;
            }
        } else {
            int result = res % 7;
            if (result != 0 && checkDigit == 7 - result) {
                return Result.VALID;
            }
            if (result == 0 && checkDigit == 0) {
                return Result.VALID;
            }
        }
        return Result.INVALID;
    }
}

