/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Check_28;
import de.businesslogics.account.Check_29;
import de.businesslogics.account.Result;

public class Check_69
extends AccountCheckAlgorithm {
    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        long c = 0L;
        try {
            c = Long.parseLong(number);
        }
        catch (Exception e) {
            return Result.INVALID;
        }
        if (c >= 9300000000L && c <= 9399999999L) {
            return Result.UNKNOWN;
        }
        if (c >= 9700000000L && c <= 9799999999L) {
            return new Check_29().check(number);
        }
        Result r = new Check_28().check(number);
        if (!Result.VALID.equals((Object)r)) {
            return new Check_29().check(number);
        }
        return r;
    }
}

