/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Result;

public class Check_68
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{2, 1, 2, 1, 2, 1, 2, 1, 2};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        if ((number = this.removeLeadingZeroes(number)).length() == 10 && number.charAt(3) == '\t') {
            return this.internalCheck(number, 3, false);
        }
        if (number.length() <= 9 && number.length() >= 6) {
            if (number.length() == 9) {
                try {
                    long l = Long.parseLong(number);
                    if (l >= 400000000L && l <= 499999999L) {
                        return Result.VALID;
                    }
                }
                catch (Exception e) {
                    return Result.INVALID;
                }
            }
            if (Result.INVALID.equals((Object)this.internalCheck(number, 1, false))) {
                return this.internalCheck(number, 1, true);
            }
            return Result.VALID;
        }
        return Result.INVALID;
    }

    protected Result internalCheck(String number, int digit, boolean variant2) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int i = number.length() - 2;
        int y = 0;
        int res = 0;
        while (i >= digit) {
            int v2;
            if (variant2 && (i == 2 || i == 3)) {
                --i;
                ++y;
                continue;
            }
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v3 = v1 * (v2 = WEIGHT[y]);
            if (v3 > 9) {
                int v4 = Integer.parseInt(String.valueOf(v3).substring(0, 1));
                int v5 = Integer.parseInt(String.valueOf(v3).substring(1));
                v3 = v4 + v5;
            }
            res += v3;
            ++y;
            --i;
        }
        String x = String.valueOf(res);
        int v6 = Integer.parseInt(x.substring(x.length() - 1));
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
        if (v6 == 0 && checkDigit == v6) {
            return Result.VALID;
        }
        if (checkDigit == 10 - v6) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

