/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Result;

public class Check_64
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{9, 10, 5, 8, 4, 2};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = 0; i <= number.length() - 5; ++i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = WEIGHT[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(6)));
        int result = res % 11;
        if (result != 1 && checkDigit == 11 - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        if (result == 1 && checkDigit == 0) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

