/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Result;

public class Check_57
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{1, 2, 1, 2, 1, 2, 1, 2, 1};

    private String[] getAlwaysValid() {
        return new String[]{"40", "50", "91", "99", "777777", "888888", "0185125434"};
    }

    private String[] getVar1() {
        return new String[]{"51", "55", "61", "64", "65", "66", "70", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "88", "94", "95"};
    }

    private String[] getVar2() {
        return new String[]{"32", "33", "34", "35", "36", "37", "38", "39", "41", "42", "43", "44", "45", "46", "47", "48", "49", "52", "53", "54", "56", "57", "58", "59", "60", "62", "63", "67", "68", "69", "71", "72", "83", "84", "85", "86", "87", "89", "90", "92", "93", "96", "97", "98"};
    }

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        if ((number = this.addLeadingZeroes(number)).startsWith("00")) {
            return Result.INVALID;
        }
        for (String x : this.getAlwaysValid()) {
            if (!number.startsWith(x)) continue;
            return Result.VALID;
        }
        for (String x : this.getVar1()) {
            if (!number.startsWith(x)) continue;
            return this.internalCheck(number);
        }
        for (String x : this.getVar2()) {
            if (!number.startsWith(x)) continue;
            return this.internalCheck2(number);
        }
        try {
            int a = Integer.parseInt(this.removeLeadingZeroes(number.substring(0, 2)));
            int b = Integer.parseInt(this.removeLeadingZeroes(number.substring(2, 4)));
            int c = Integer.parseInt(this.removeLeadingZeroes(number.substring(6, 9)));
            if (a > 0 && a < 32 && b > 0 && b < 13 && c < 500) {
                return Result.VALID;
            }
        }
        catch (Exception e) {
            return Result.INVALID;
        }
        return Result.INVALID;
    }

    protected Result internalCheck(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        int y = 0;
        int res = 0;
        for (int i = 0; i <= number.length() - 2; ++i) {
            int v2;
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v3 = v1 * (v2 = WEIGHT[y]);
            if (v3 > 9) {
                int v4 = Integer.parseInt(String.valueOf(v3).substring(0, 1));
                int v5 = Integer.parseInt(String.valueOf(v3).substring(1));
                v3 = v4 + v5;
            }
            res += v3;
            ++y;
        }
        String x = String.valueOf(res);
        int v6 = Integer.parseInt(x.substring(x.length() - 1));
        int checkDigit = Integer.parseInt(number.substring(number.length() - 1));
        if (v6 == 0 && checkDigit == v6) {
            return Result.VALID;
        }
        if (checkDigit == 10 - v6) {
            return Result.VALID;
        }
        return Result.INVALID;
    }

    protected Result internalCheck2(String number) {
        int v5;
        int v4;
        int v3;
        int v2;
        int v1;
        int i;
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        int y = 0;
        int res = 0;
        for (i = 0; i <= 1; ++i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            v3 = v1 * (v2 = WEIGHT[y]);
            if (v3 > 9) {
                v4 = Integer.parseInt(String.valueOf(v3).substring(0, 1));
                v5 = Integer.parseInt(String.valueOf(v3).substring(1));
                v3 = v4 + v5;
            }
            res += v3;
            ++y;
        }
        for (i = 3; i <= number.length() - 1; ++i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            v3 = v1 * (v2 = WEIGHT[y]);
            if (v3 > 9) {
                v4 = Integer.parseInt(String.valueOf(v3).substring(0, 1));
                v5 = Integer.parseInt(String.valueOf(v3).substring(1));
                v3 = v4 + v5;
            }
            res += v3;
            ++y;
        }
        String x = String.valueOf(res);
        int v6 = Integer.parseInt(x.substring(x.length() - 1));
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(2)));
        if (v6 == 0 && checkDigit == v6) {
            return Result.VALID;
        }
        if (checkDigit == 10 - v6) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

