/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Check_20;
import de.businesslogics.account.Result;

public class Check_53
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{2, 4, 8, 5, 10, 9, 7, 3, 6, 1, 2, 4};

    @Override
    public Result check(String number, String bankCode) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        if ((number = this.addLeadingZeroes(number)).charAt(0) == '9') {
            return new Check_20().check(number);
        }
        number = this.removeLeadingZeroes(number);
        if (bankCode == null || bankCode.length() != 8 || number.length() != 9) {
            return Result.INVALID;
        }
        return this.check(bankCode.substring(4, 6) + number.substring(1, 2) + bankCode.substring(7) + number.substring(0, 1) + number.substring(2, 3) + this.removeLeadingZeroes(number.substring(3)));
    }

    @Override
    protected Result check(String number) {
        int z;
        if (number == null || number.length() < 2 || number.length() > 12) {
            return Result.INVALID;
        }
        number = this.removeLeadingZeroes(number);
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(5)));
        int res = 0;
        int y = 0;
        int weight = 0;
        boolean ready = false;
        for (int i = number.length() - 1; i >= 0; --i) {
            if (i == 5) {
                weight = WEIGHT[y];
            } else {
                if (!Character.isDigit(number.charAt(i))) {
                    return Result.INVALID;
                }
                int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
                int v2 = WEIGHT[y];
                int v3 = v1 * v2;
                res += v3;
            }
            ++y;
        }
        int result = res % 11;
        int a = 0;
        while (!ready && (z = result + a * weight) % 11 != 10) {
            ++a;
        }
        if (a == checkDigit) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

