/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Check_33;
import de.businesslogics.account.Result;

public class Check_51
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{2, 3, 4, 5, 6};

    protected int[] getWeight() {
        return WEIGHT;
    }

    protected int[] getWeight00() {
        return new int[]{2, 1, 2, 1, 2, 1, 0, 0, 0};
    }

    protected int[] getWeight06() {
        return new int[]{2, 3, 4, 5, 6, 7, 0, 0, 0};
    }

    protected int[] getWeightExclusion1() {
        return new int[]{2, 3, 4, 5, 6, 7, 8};
    }

    protected int[] getWeightExclusion2() {
        return new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10};
    }

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        if ((number = this.addLeadingZeroes(number)).charAt(2) == '9') {
            Result r = this.checkExclusion1(number);
            if (!r.equals((Object)Result.VALID)) {
                return this.checkExclusion2(number);
            }
            return r;
        }
        Result r = this.check06(number);
        if (!r.equals((Object)Result.VALID)) {
            Result r2 = new Check_33().check(number);
            if (!r2.equals((Object)Result.VALID)) {
                Result r3 = this.check00(number);
                if (!r3.equals((Object)Result.VALID)) {
                    return this.internalCheck(number);
                }
                return r3;
            }
            return r2;
        }
        return r;
    }

    protected Result internalCheck(String number) {
        int result;
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        if ((number = this.addLeadingZeroes(number)).charAt(9) == '7' || number.charAt(9) == '8' || number.charAt(9) == '9') {
            return Result.INVALID;
        }
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= 4; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = this.getWeight()[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(number.substring(number.length() - 1));
        if (checkDigit == 7 - (result = res % 7)) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        return Result.INVALID;
    }

    protected Result checkExclusion1(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= 2; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = this.getWeightExclusion1()[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(number.substring(number.length() - 1));
        int result = res % 11;
        if (result != 1 && checkDigit == 11 - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        if (result == 1 && checkDigit == 0) {
            return Result.VALID;
        }
        return Result.INVALID;
    }

    protected Result checkExclusion2(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= 0; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = this.getWeightExclusion2()[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(number.substring(number.length() - 1));
        int result = res % 11;
        if (result != 1 && checkDigit == 11 - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        if (result == 1 && checkDigit == 0) {
            return Result.VALID;
        }
        return Result.INVALID;
    }

    protected Result check00(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int y = 0;
        int res = 0;
        for (int i = number.length() - 2; i >= 0; --i) {
            int v2;
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v3 = v1 * (v2 = this.getWeight00()[y]);
            if (v3 > 9) {
                int v4 = Integer.parseInt(String.valueOf(v3).substring(0, 1));
                int v5 = Integer.parseInt(String.valueOf(v3).substring(1));
                v3 = v4 + v5;
            }
            res += v3;
            ++y;
        }
        String x = String.valueOf(res);
        int v6 = Integer.parseInt(x.substring(x.length() - 1));
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
        if (v6 == 0 && checkDigit == v6) {
            return Result.VALID;
        }
        if (checkDigit == 10 - v6) {
            return Result.VALID;
        }
        return Result.INVALID;
    }

    protected Result check06(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int res = 0;
        int y = 0;
        for (int i = number.length() - 2; i >= 0; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = this.getWeight06()[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(9)));
        int result = res % 11;
        if (result != 1 && checkDigit == 11 - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        if (result == 1 && checkDigit == 0) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

