/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Result;

public class Check_50
extends AccountCheckAlgorithm {
    private static int[] WEIGHT = new int[]{2, 3, 4, 5, 6, 7};

    @Override
    protected Result check(String number) {
        if (number == null || ((String)number).length() > 10 || ((String)number).length() < 2) {
            return Result.INVALID;
        }
        Result r = this.internalCheck((String)(number = this.addLeadingZeroes((String)number)));
        if (!r.equals((Object)Result.VALID) && ((String)number).startsWith("000")) {
            number = ((String)number).substring(3, ((String)number).length() - 1) + "000";
            return this.internalCheck((String)number);
        }
        return r;
    }

    private Result internalCheck(String number) {
        int res = 0;
        int y = 0;
        for (int i = number.length() - 5; i >= 0; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = WEIGHT[y];
            int v3 = v1 * v2;
            res += v3;
            ++y;
        }
        int checkDigit = Integer.parseInt(String.valueOf(number.charAt(6)));
        int result = res % 11;
        if (result != 1 && checkDigit == 11 - result) {
            return Result.VALID;
        }
        if (result == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        if (result == 1 && checkDigit == 0) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

