/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.Result;

public class Check_29
extends AccountCheckAlgorithm {
    private static int[][] MAPPING = new int[][]{{0, 1, 5, 9, 3, 7, 4, 8, 2, 6}, {0, 1, 7, 6, 9, 8, 3, 2, 5, 4}, {0, 1, 8, 4, 6, 2, 9, 5, 7, 3}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9}};

    @Override
    protected Result check(String number) {
        if (number == null || number.length() > 10 || number.length() < 2) {
            return Result.INVALID;
        }
        try {
            Long.parseLong(number);
        }
        catch (Exception e) {
            return Result.INVALID;
        }
        number = this.addLeadingZeroes(number);
        int z = 0;
        int res = 0;
        for (int i = number.length() - 2; i >= 0; --i) {
            if (!Character.isDigit(number.charAt(i))) {
                return Result.INVALID;
            }
            int v1 = Integer.parseInt(String.valueOf(number.charAt(i)));
            int v2 = MAPPING[z][v1];
            res += v2;
            if (++z <= 3) continue;
            z = 0;
        }
        String x = String.valueOf(res);
        int v6 = Integer.parseInt(x.substring(x.length() - 1));
        int checkDigit = Integer.parseInt(number.substring(number.length() - 1));
        if (v6 == 0 && checkDigit == 0) {
            return Result.VALID;
        }
        if (checkDigit == 10 - v6) {
            return Result.VALID;
        }
        return Result.INVALID;
    }
}

