/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.BankInfo;
import de.businesslogics.account.Result;
import de.businesslogics.account.iban.BICConverter;
import de.businesslogics.account.iban.IBANConverter;
import de.businesslogics.account.iban.Reverse;
import de.businesslogics.account.iban.SEPABankConnection;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BankInfoCache
implements IBANConverter.SimpleCache {
    private final HashMap<String, BankInfo> blzMapping = new HashMap();
    private final HashMap<String, BankInfo> bicMapping = new HashMap();
    private final HashMap<String, String> blzBicMapping = new HashMap();
    private final HashMap<String, AccountCheckAlgorithm> checkAlgorithmMap = new HashMap();
    private final HashMap<String, String> ibanRuleMapping = new HashMap();
    private List<BankInfo> bankInformation = null;

    public BankInfoCache(List<BankInfo> infos) {
        this.bankInformation = infos;
        for (BankInfo info : infos) {
            this.addToMappings(info);
        }
        if (IBANConverter.BLZ_CACHE == null) {
            this.registerIbanConverter();
        }
    }

    public void registerIbanConverter() {
        IBANConverter.BLZ_CACHE = new IBANConverter.SimpleCache(){

            @Override
            public BankInfo getBankInfo(String blz) {
                return BankInfoCache.this.findByBankCode(blz);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BankInfoCache(InputStream in) throws IOException {
        try {
            try (InputStreamReader ir = new InputStreamReader(in, "ISO-8859-1");){
                this.init(new BufferedReader(ir));
            }
            in.close();
            in = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public BankInfoCache(BufferedReader r) throws IOException {
        this.init(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(BufferedReader r) throws IOException {
        try {
            String line = null;
            this.bankInformation = new ArrayList<BankInfo>();
            while ((line = r.readLine()) != null) {
                if (line.length() <= 0) continue;
                BankInfo info = new BankInfo(line);
                this.bankInformation.add(info);
                this.addToMappings(info);
            }
            r.close();
            r = null;
            this.registerIbanConverter();
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void addToMappings(BankInfo info) {
        String blz = info.getBankCode();
        String bic = info.getBicCode();
        String checkDigit = info.getCheckDigit();
        String ibanRule = info.getIBANRule();
        if (info.isLeading()) {
            if (bic != null && bic.length() > 0) {
                this.bicMapping.put(bic, info);
                this.blzBicMapping.put(blz, bic.trim());
            }
            this.blzMapping.put(blz, info);
            if (ibanRule != null) {
                this.ibanRuleMapping.put(blz, ibanRule);
            }
        }
        if (checkDigit != null) {
            AccountCheckAlgorithm checkAlgorithm = AccountCheckAlgorithm.get(checkDigit);
            if (this.checkAlgorithmMap != null) {
                this.checkAlgorithmMap.put(blz, checkAlgorithm);
            }
        }
    }

    public Result checkAccount(String number, String bankCode) {
        try {
            if (number == null) {
                return null;
            }
            Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
        BankInfo info = this.blzMapping.get(bankCode);
        if (info == null) {
            return null;
        }
        AccountCheckAlgorithm alg = AccountCheckAlgorithm.get(info.getCheckDigit());
        if (alg == null) {
            return null;
        }
        return alg.check(number, bankCode);
    }

    public List<BankInfo> getAllBankInfos() {
        return this.bankInformation;
    }

    public List<BankInfo> findAllByBankCode(String blz) {
        ArrayList<BankInfo> ret = new ArrayList<BankInfo>();
        for (BankInfo i : this.bankInformation) {
            if (i.getBicCode() == null || !i.getBankCode().equals(blz)) continue;
            ret.add(i);
        }
        return ret;
    }

    public BankInfo findByBankCode(String blz) {
        return this.blzMapping.get(blz);
    }

    public BankInfo findByBicCode(String bic) {
        return this.bicMapping.get(bic);
    }

    public String getIban(String blz, String accNumber) {
        if (blz == null || accNumber == null) {
            return null;
        }
        IBANConverter converter = this.getConverter(blz);
        if (converter != null) {
            return converter.convert(blz, accNumber);
        }
        return null;
    }

    public String[] reverseIBAN(String iban) {
        if (iban == null) {
            return null;
        }
        BankInfo info = this.getBankInfo(iban.substring(4, 12));
        if (info == null) {
            return null;
        }
        Class<? extends IBANConverter> c = IBANConverter.getClass(info.getIBANRule());
        if (c == null) {
            return null;
        }
        Reverse reverse = c.getAnnotation(Reverse.class);
        String[] toReturn = new String[2];
        if (reverse != null) {
            if (reverse.blz()) {
                toReturn[0] = iban.substring(4, 12);
            }
            toReturn[1] = iban.substring(12);
        }
        return toReturn;
    }

    public SEPABankConnection getSEPABankConnection(String blz, String accNumber) {
        return this.getSEPABankConnection(blz, accNumber, this.getConverter(blz));
    }

    public SEPABankConnection getSEPABankConnection(String blz, String accNumber, IBANConverter converter) {
        if (converter != null) {
            if (converter instanceof BICConverter) {
                return ((BICConverter)converter).convertAll(blz, accNumber);
            }
            String iban = converter.convert(blz, accNumber);
            if (iban == null) {
                return null;
            }
            String bic = this.blzBicMapping.get(iban.subSequence(4, 12));
            if (bic == null) {
                return null;
            }
            return new SEPABankConnection(bic, iban);
        }
        return null;
    }

    private IBANConverter getConverter(String blz) {
        return IBANConverter.get(this.ibanRuleMapping.get(blz));
    }

    public List<BankInfo> findByCheckDigit(String algorithm) {
        ArrayList<BankInfo> result = new ArrayList<BankInfo>();
        for (BankInfo b : this.bankInformation) {
            if (!b.getCheckDigit().equals(algorithm)) continue;
            result.add(b);
        }
        return result;
    }

    public static void main(String[] args) {
        if (args == null || args.length < 2 || args.length > 4) {
            System.out.println("Usage: BankInfoCache -check <filename> <accountNumber> <bankCode>");
            System.out.println("or:  BankInfoCache -findBankCode <filename> <bankCode>");
            System.out.println("or:  BankInfoCache -findAlgorithm <filename> <algorithm>");
            System.out.println("or:  BankInfoCache -convert <filename> <accountNumber> <bankCode>");
        } else {
            try {
                BankInfoCache v = new BankInfoCache(new FileInputStream(args[1]));
                if (args[0].equals("-convert")) {
                    IBANConverter.BLZ_CACHE = v;
                    SEPABankConnection bc = v.getSEPABankConnection(args[3], args[2]);
                    if (bc == null) {
                        System.err.println("IBAN converter has no results.");
                    } else {
                        System.out.println("IBAN: " + bc.getIban());
                        System.out.println("BIC : " + bc.getBic());
                    }
                } else if (args[0].equals("-check")) {
                    System.out.println("Checking test account " + args[2] + " " + args[3] + ": " + String.valueOf((Object)v.checkAccount(args[2], args[3])));
                } else if (args[0].equals("-findBankCode")) {
                    for (BankInfo b : v.findAllByBankCode(args[2])) {
                        System.out.println(b.toString());
                    }
                } else if (args[0].equals("-findAlgorithm")) {
                    for (BankInfo b : v.findByCheckDigit(args[2])) {
                        System.out.println(b.toString());
                    }
                } else {
                    System.err.println("unknown command: " + args[0]);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public BankInfo getBankInfo(String blz) {
        return this.findByBankCode(blz);
    }
}

