/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account;

public class BankInfo {
    private final String bankCode;
    private final boolean leading;
    private final String longName;
    private final String plz;
    private final String city;
    private final String name;
    private int pan;
    private final String bicCode;
    private final String checkDigit;
    private final int bankId;
    private final Mod change;
    private final boolean toBeDeleted;
    private final String nextBankCode;
    private String ibanRule;

    public BankInfo(String line) {
        this.bankCode = line.substring(0, 8);
        this.leading = line.subSequence(8, 9).equals("1");
        this.longName = line.substring(9, 67).trim();
        this.plz = line.substring(67, 72);
        this.city = line.substring(72, 107).trim();
        this.name = line.substring(107, 134).trim();
        String panS = line.substring(134, 139).trim();
        if (panS.length() > 0) {
            this.pan = Integer.parseInt(panS);
        }
        this.bicCode = line.substring(139, 150);
        this.checkDigit = line.substring(150, 152);
        this.bankId = Integer.parseInt(line.substring(152, 158));
        this.change = Mod.valueOf(line.charAt(158));
        this.toBeDeleted = line.charAt(159) == '1';
        this.nextBankCode = line.substring(160, 168);
        if (line.length() >= 174) {
            this.ibanRule = line.substring(168, 174);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getBankCode() {
        return this.bankCode;
    }

    public String getBicCode() {
        return this.bicCode;
    }

    public String getPlz() {
        return this.plz;
    }

    public String getCheckDigit() {
        return this.checkDigit;
    }

    public int getBankId() {
        return this.bankId;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getCity() {
        return this.city;
    }

    public boolean isLeading() {
        return this.leading;
    }

    public int getPan() {
        return this.pan;
    }

    public Mod getChange() {
        return this.change;
    }

    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }

    public String getNextBankCode() {
        return this.nextBankCode;
    }

    public String getIBANRule() {
        return this.ibanRule;
    }

    public boolean hasNextBankCode() {
        return !"00000000".endsWith(this.nextBankCode);
    }

    public String toString() {
        return "BankCode: " + this.bankCode + ", BicCode: " + this.bicCode + ", Name: " + this.name + ", longName: " + this.longName + ", Plz: " + this.plz + ", City: " + this.city + ", CheckDigit: " + this.checkDigit + ", Bank ID: " + this.bankId + ", nextBankCode: " + this.nextBankCode + ", pan: " + this.pan + ", IBAN-Rule" + this.ibanRule;
    }

    public static enum Mod {
        Addition('A'),
        Modified('M'),
        Unchanged('U'),
        Deletion('D');

        private final char c;

        private Mod(char c) {
            this.c = c;
        }

        public static Mod valueOf(char c) {
            Mod[] all;
            for (Mod mod : all = Mod.values()) {
                if (mod.c != c) continue;
                return mod;
            }
            return null;
        }

        public String toString() {
            return String.valueOf(this.c);
        }
    }
}

