/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.typesafe.config.Config;
import java.io.Serializable;
import javax.sql.DataSource;
import play.api.Configuration;
import play.api.Environment;
import play.api.MarkerContext$;
import play.api.db.ConnectionPool;
import play.api.db.ConnectionPool$;
import play.api.db.DBApi;
import play.api.db.Database;
import play.api.db.DefaultDBApi$;
import play.api.db.PooledDatabase;
import play.api.inject.Injector;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001\u0002\f\u0018\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011!I\u0006\u0001#b\u0001\n\u0013Q\u0006\"B4\u0001\t\u0003A\u0007\u0002C5\u0001\u0011\u000b\u0007I\u0011\u00026\t\u000b1\u0004A\u0011A7\t\u000bA\u0004A\u0011A9\t\u0013\u0005%\u0001!%A\u0005\u0002\u0005-\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003S\u0001A\u0011AA\u0016\u000f\u001d\tic\u0006E\u0001\u0003_1aAF\f\t\u0002\u0005E\u0002B\u0002*\u0010\t\u0003\t\u0019\u0004C\u0005\u00026=\u0011\r\u0011\"\u0003\u00028!A\u0011qH\b!\u0002\u0013\tI\u0004C\u0005\u0002B=\t\n\u0011\"\u0001\u0002D!I\u0011qI\b\u0012\u0002\u0013\u0005\u0011\u0011\n\u0005\n\u0003\u001bz\u0011\u0013!C\u0001\u0003\u001f\u0012A\u0002R3gCVdG\u000f\u0012\"Ba&T!\u0001G\r\u0002\u0005\u0011\u0014'B\u0001\u000e\u001c\u0003\r\t\u0007/\u001b\u0006\u00029\u0005!\u0001\u000f\\1z\u0007\u0001\u00192\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeJ\u0007\u0002/%\u0011\u0001f\u0006\u0002\u0006\t\n\u000b\u0005/[\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\u0011\t-\u0012T\u0007\u000f\b\u0003YA\u0002\"!L\u0011\u000e\u00039R!aL\u000f\u0002\rq\u0012xn\u001c;?\u0013\t\t\u0014%\u0001\u0004Qe\u0016$WMZ\u0005\u0003gQ\u00121!T1q\u0015\t\t\u0014\u0005\u0005\u0002,m%\u0011q\u0007\u000e\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005e\u0002U\"\u0001\u001e\u000b\u0005mb\u0014AB2p]\u001aLwM\u0003\u0002>}\u0005AA/\u001f9fg\u00064WMC\u0001@\u0003\r\u0019w.\\\u0005\u0003\u0003j\u0012aaQ8oM&<\u0017!\u00063fM\u0006,H\u000e^\"p]:,7\r^5p]B{w\u000e\u001c\t\u0003M\u0011K!!R\f\u0003\u001d\r{gN\\3di&|g\u000eU8pY\u0006YQM\u001c<je>tW.\u001a8u!\tA\u0015*D\u0001\u001a\u0013\tQ\u0015DA\u0006F]ZL'o\u001c8nK:$\u0018\u0001C5oU\u0016\u001cGo\u001c:\u0011\u00055\u0003V\"\u0001(\u000b\u0005=K\u0012AB5oU\u0016\u001cG/\u0003\u0002R\u001d\nA\u0011J\u001c6fGR|'/\u0001\u0004=S:LGO\u0010\u000b\u0006)V3v\u000b\u0017\t\u0003M\u0001AQ!K\u0003A\u0002)BqAQ\u0003\u0011\u0002\u0003\u00071\tC\u0004G\u000bA\u0005\t\u0019A$\t\u000f-+\u0001\u0013!a\u0001\u0019\u0006Qq\fZ1uC\n\f7/Z:\u0016\u0003m\u00032\u0001X1e\u001d\tivL\u0004\u0002.=&\t!%\u0003\u0002aC\u00059\u0001/Y2lC\u001e,\u0017B\u00012d\u0005\r\u0019V-\u001d\u0006\u0003A\u0006\u0002\"AJ3\n\u0005\u0019<\"\u0001\u0003#bi\u0006\u0014\u0017m]3\u0002\u0013\u0011\fG/\u00192bg\u0016\u001cH#A.\u0002\u001d\u0011\fG/\u00192bg\u0016\u0014\u0015PT1nKV\t1\u000e\u0005\u0003,eU\"\u0017\u0001\u00033bi\u0006\u0014\u0017m]3\u0015\u0005\u0011t\u0007\"B8\n\u0001\u0004)\u0014\u0001\u00028b[\u0016\fqaY8o]\u0016\u001cG\u000f\u0006\u0002skB\u0011\u0001e]\u0005\u0003i\u0006\u0012A!\u00168ji\"9aO\u0003I\u0001\u0002\u00049\u0018!\u00047pO\u000e{gN\\3di&|g\u000e\u0005\u0002!q&\u0011\u00110\t\u0002\b\u0005>|G.Z1oQ!Q1P`@\u0002\u0004\u0005\u0015\u0001C\u0001\u0011}\u0013\ti\u0018E\u0001\u0006eKB\u0014XmY1uK\u0012\fq!\\3tg\u0006<W-\t\u0002\u0002\u0002\u0005)Uk]3!S:LG/[1mSj,\u0007%\u001b8ti\u0016\fG\r\f\u0011xQ&\u001c\u0007\u000e\t3pKN\u0004cn\u001c;!iJL\b\u0005^8!G>tg.Z2uAQ|\u0007\u0005\u001e5fA\u0011\fG/\u00192bg\u0016\fQa]5oG\u0016\f#!a\u0002\u0002\u000bIrsG\f\u0019\u0002#\r|gN\\3di\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u000e)\u001aq/a\u0004,\u0005\u0005E\u0001\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0007\"\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\t)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!\"\u001b8ji&\fG.\u001b>f)\r\u0011\u0018Q\u0005\u0005\u0007\u0003Oa\u0001\u0019A<\u0002#1|w-\u00138ji&\fG.\u001b>bi&|g.\u0001\u0005tQV$Hm\\<o)\u0005\u0011\u0018\u0001\u0004#fM\u0006,H\u000e\u001e#C\u0003BL\u0007C\u0001\u0014\u0010'\tyq\u0004\u0006\u0002\u00020\u00051An\\4hKJ,\"!!\u000f\u0011\u0007!\u000bY$C\u0002\u0002>e\u0011a\u0001T8hO\u0016\u0014\u0018a\u00027pO\u001e,'\u000fI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0015#fA\"\u0002\u0010\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a\u0013+\u0007\u001d\u000by!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003#R3\u0001TA\b\u0001")
public class DefaultDBApi
implements DBApi {
    private Seq<Database> _databases;
    private Map<String, Database> databaseByName;
    private final Map<String, Config> configuration;
    private final ConnectionPool defaultConnectionPool;
    private final Environment environment;
    private final Injector injector;
    private volatile byte bitmap$0;

    public static Injector $lessinit$greater$default$4() {
        return DefaultDBApi$.MODULE$.$lessinit$greater$default$4();
    }

    public static Environment $lessinit$greater$default$3() {
        return DefaultDBApi$.MODULE$.$lessinit$greater$default$3();
    }

    public static ConnectionPool $lessinit$greater$default$2() {
        return DefaultDBApi$.MODULE$.$lessinit$greater$default$2();
    }

    private Seq<Database> _databases$lzycompute() {
        DefaultDBApi defaultDBApi = this;
        synchronized (defaultDBApi) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._databases = ((IterableOnceOps)this.configuration.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        Config config = (Config)tuple2._2();
                        ConnectionPool pool = ConnectionPool$.MODULE$.fromConfig(config.getString("pool"), $this.injector, $this.environment, $this.defaultConnectionPool);
                        return new PooledDatabase(name, config, $this.environment, pool);
                    }
                    throw new MatchError((Object)tuple2);
                })).toSeq();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._databases;
    }

    private Seq<Database> _databases() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this._databases$lzycompute();
        }
        return this._databases;
    }

    public Seq<Database> databases() {
        return this._databases();
    }

    private Map<String, Database> databaseByName$lzycompute() {
        DefaultDBApi defaultDBApi = this;
        synchronized (defaultDBApi) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.databaseByName = this._databases().iterator().map((Function1 & Serializable)db -> new Tuple2((Object)db.name(), db)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.databaseByName;
    }

    private Map<String, Database> databaseByName() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.databaseByName$lzycompute();
        }
        return this.databaseByName;
    }

    public Database database(String name) {
        return (Database)this.databaseByName().getOrElse((Object)name, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Could not find database for " + name);
        });
    }

    public void connect(boolean logConnection) {
        this._databases().foreach((Function1 & Serializable)db -> {
            DefaultDBApi.$anonfun$connect$1(this, logConnection, db);
            return BoxedUnit.UNIT;
        });
    }

    public boolean connect$default$1() {
        return false;
    }

    public void initialize(boolean logInitialization) {
        this._databases().foreach((Function1 & Serializable)db -> {
            DataSource dataSource;
            try {
                if (logInitialization) {
                    DefaultDBApi$.MODULE$.play$api$db$DefaultDBApi$$logger().info((Function0 & Serializable)() -> "Database [" + db.name() + "] initialized", MarkerContext$.MODULE$.NoMarker());
                }
                dataSource = db.dataSource();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    throw new Configuration((Config)$this.configuration.apply((Object)db.name())).reportError("url", "Cannot initialize to database [" + db.name() + "]", (Option)new Some((Object)throwable2));
                }
                throw throwable;
            }
            return dataSource;
        });
    }

    public void shutdown() {
        this._databases().foreach((Function1 & Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$connect$1(DefaultDBApi $this, boolean logConnection$1, Database db) {
        try {
            db.getConnection().close();
            if (logConnection$1) {
                DefaultDBApi$.MODULE$.play$api$db$DefaultDBApi$$logger().info((Function0 & Serializable)() -> "Database [" + db.name() + "] connected", MarkerContext$.MODULE$.NoMarker());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                throw new Configuration((Config)$this.configuration.apply((Object)db.name())).reportError("url", "Cannot connect to database [" + db.name() + "]", (Option)new Some((Object)throwable2));
            }
            throw throwable;
        }
    }

    public DefaultDBApi(Map<String, Config> configuration, ConnectionPool defaultConnectionPool, Environment environment, Injector injector) {
        this.configuration = configuration;
        this.defaultConnectionPool = defaultConnectionPool;
        this.environment = environment;
        this.injector = injector;
    }
}

