/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

public class ResponseHeader {
    private final int status;
    private final String reasonPhrase;
    private final Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public ResponseHeader(int n, Map<String, String> map2) {
        this(n, map2, null);
    }

    public ResponseHeader(int n, Map<String, String> map2, String string) {
        this.status = n;
        this.reasonPhrase = string;
        this.headers.putAll(map2);
    }

    public play.api.mvc.ResponseHeader asScala() {
        return new play.api.mvc.ResponseHeader(this.status, this.headers, (Option<String>)OptionConverters.toScala(Optional.ofNullable(this.reasonPhrase)));
    }

    public int status() {
        return this.status;
    }

    public Optional<String> reasonPhrase() {
        return Optional.ofNullable(this.reasonPhrase);
    }

    public Optional<String> getHeader(String string) {
        return Optional.ofNullable(this.headers.get(string));
    }

    public Map<String, String> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    public ResponseHeader withoutHeader(String string) {
        Map<String, String> map2 = this.copyCurrentHeaders();
        map2.remove(string);
        return new ResponseHeader(this.status, map2, this.reasonPhrase);
    }

    public ResponseHeader withHeader(String string, String string2) {
        Map<String, String> map2 = this.copyCurrentHeaders();
        map2.put(string, string2);
        return new ResponseHeader(this.status, map2, this.reasonPhrase);
    }

    public ResponseHeader withHeaders(Map<String, String> map2) {
        Map<String, String> map3 = this.copyCurrentHeaders();
        map3.putAll(map2);
        return new ResponseHeader(this.status, map3, this.reasonPhrase);
    }

    private Map<String, String> copyCurrentHeaders() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        treeMap.putAll(this.headers);
        return treeMap;
    }
}

