/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.zkasecurity;

import de.businesslogics.bouncycastle.asn1.ASN1Encodable;
import de.businesslogics.bouncycastle.asn1.ASN1EncodableVector;
import de.businesslogics.bouncycastle.asn1.ASN1InputStream;
import de.businesslogics.bouncycastle.asn1.ASN1Integer;
import de.businesslogics.bouncycastle.asn1.ASN1OctetString;
import de.businesslogics.bouncycastle.asn1.ASN1OutputStream;
import de.businesslogics.bouncycastle.asn1.DEROctetString;
import de.businesslogics.bouncycastle.asn1.DERSequence;
import de.businesslogics.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import de.businesslogics.bouncycastle.asn1.pkcs.EncryptionScheme;
import de.businesslogics.bouncycastle.asn1.pkcs.PBES2Parameters;
import de.businesslogics.bouncycastle.asn1.pkcs.PBKDF2Params;
import de.businesslogics.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import de.businesslogics.bouncycastle.asn1.x509.AlgorithmIdentifier;
import de.businesslogics.bouncycastle.crypto.BlockCipher;
import de.businesslogics.bouncycastle.crypto.CipherParameters;
import de.businesslogics.bouncycastle.crypto.InvalidCipherTextException;
import de.businesslogics.bouncycastle.crypto.PBEParametersGenerator;
import de.businesslogics.bouncycastle.crypto.engines.DESedeEngine;
import de.businesslogics.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import de.businesslogics.bouncycastle.crypto.modes.CBCBlockCipher;
import de.businesslogics.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import de.businesslogics.bouncycastle.crypto.params.ParametersWithIV;
import de.businesslogics.zkasecurity.DirectSecurity;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import de.businesslogics.zkasecurity.KeyFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;

public class KeyStore {
    public static KeyPair decryptStore(byte[] byArray, char[] cArray) throws InvalidPasswordException {
        byte[] byArray2 = KeyStore.decryptData(byArray, cArray);
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray2);
            KeyFactory keyFactory = DirectSecurity.getRSAKeyFactory();
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            PublicKey publicKey = keyFactory.generatePublic(new RSAPublicKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent()));
            return new KeyPair(publicKey, rSAPrivateCrtKey);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidPasswordException(runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decryptData(byte[] byArray, char[] cArray) throws InvalidPasswordException {
        try {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
            try (ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);){
                encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance((Object)aSN1InputStream.readObject());
            }
            PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance((Object)encryptedPrivateKeyInfo.getEncryptionAlgorithm().getParameters());
            PBKDF2Params pBKDF2Params = (PBKDF2Params)pBES2Parameters.getKeyDerivationFunc().getParameters();
            EncryptionScheme encryptionScheme = pBES2Parameters.getEncryptionScheme();
            int n = 192;
            int n2 = pBKDF2Params.getIterationCount().intValue();
            byte[] byArray2 = pBKDF2Params.getSalt();
            pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])cArray), byArray2, n2);
            byte[] byArray3 = ((ASN1OctetString)encryptionScheme.getParameters()).getOctets();
            ParametersWithIV parametersWithIV = new ParametersWithIV(pKCS5S2ParametersGenerator.generateDerivedParameters(n), byArray3);
            PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine()));
            paddedBufferedBlockCipher.init(false, (CipherParameters)parametersWithIV);
            byte[] byArray4 = encryptedPrivateKeyInfo.getEncryptedData();
            byte[] byArray5 = new byte[paddedBufferedBlockCipher.getOutputSize(byArray4.length)];
            int n3 = paddedBufferedBlockCipher.processBytes(byArray4, 0, byArray4.length, byArray5, 0);
            n3 += paddedBufferedBlockCipher.doFinal(byArray5, n3);
            if (n3 < byArray5.length) {
                byte[] byArray6 = new byte[n3];
                System.arraycopy(byArray5, 0, byArray6, 0, n3);
                return byArray6;
            }
            return byArray5;
        }
        catch (Exception exception) {
            throw new InvalidPasswordException(exception.getMessage());
        }
    }

    public static byte[] encryptData(byte[] byArray, char[] cArray) throws IOException, InvalidPasswordException {
        try {
            SecureRandom secureRandom = new SecureRandom();
            byte[] byArray2 = new byte[8];
            byte[] byArray3 = new byte[8];
            secureRandom.nextBytes(byArray2);
            secureRandom.nextBytes(byArray3);
            PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
            pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])cArray), byArray2, 2048);
            ParametersWithIV parametersWithIV = new ParametersWithIV(pKCS5S2ParametersGenerator.generateDerivedParameters(192), byArray3);
            PaddedBufferedBlockCipher paddedBufferedBlockCipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new DESedeEngine()));
            paddedBufferedBlockCipher.init(true, (CipherParameters)parametersWithIV);
            byte[] byArray4 = new byte[paddedBufferedBlockCipher.getOutputSize(byArray.length)];
            int n = paddedBufferedBlockCipher.processBytes(byArray, 0, byArray.length, byArray4, 0);
            paddedBufferedBlockCipher.doFinal(byArray4, n);
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo((AlgorithmIdentifier)new PKCS8AlgorithmParameters(byArray2, 2048, byArray3), byArray4);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = ASN1OutputStream.create((OutputStream)byteArrayOutputStream, (String)"DER");
            aSN1OutputStream.writeObject((ASN1Encodable)encryptedPrivateKeyInfo.toASN1Primitive());
            aSN1OutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new InvalidPasswordException(invalidCipherTextException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidPasswordException(runtimeException);
        }
    }

    public static byte[] encryptStore(PrivateKey privateKey, char[] cArray) {
        try {
            KeyFactory keyFactory = DirectSecurity.getRSAKeyFactory();
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = keyFactory.getKeySpec(privateKey, PKCS8EncodedKeySpec.class);
            byte[] byArray = pKCS8EncodedKeySpec.getEncoded();
            return KeyStore.encryptData(byArray, cArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Weird security setup", exception);
        }
    }

    public static void main(String[] stringArray) throws IOException, InvalidPasswordException {
        char[] cArray = "geheim".toCharArray();
        byte[] byArray = "my data".getBytes();
        byte[] byArray2 = KeyStore.encryptData(byArray, cArray);
        byte[] byArray3 = KeyStore.decryptData(byArray2, cArray);
        System.out.println("Equal: " + Arrays.equals(byArray, byArray3));
    }

    private static class PKCS8AlgorithmParameters
    extends AlgorithmIdentifier {
        public PKCS8AlgorithmParameters(byte[] byArray, int n, byte[] byArray2) {
            super(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)PKCS8AlgorithmParameters.getDERObject(byArray, n, byArray2));
        }

        public static DERSequence getDERObject(byte[] byArray, int n, byte[] byArray2) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector4 = new ASN1EncodableVector();
            aSN1EncodableVector2.add((ASN1Encodable)PKCSObjectIdentifiers.id_PBKDF2);
            aSN1EncodableVector3.add((ASN1Encodable)new DEROctetString(byArray));
            aSN1EncodableVector3.add((ASN1Encodable)new ASN1Integer((long)n));
            aSN1EncodableVector2.add((ASN1Encodable)new DERSequence(aSN1EncodableVector3));
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector2));
            aSN1EncodableVector4.add((ASN1Encodable)PKCSObjectIdentifiers.des_EDE3_CBC);
            aSN1EncodableVector4.add((ASN1Encodable)new DEROctetString(byArray2));
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(aSN1EncodableVector4));
            return new DERSequence(aSN1EncodableVector);
        }
    }
}

