/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util;

import java.io.IOException;
import java.io.OutputStream;

public class HexTool {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private HexTool() {
    }

    public static int charValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Not a number '" + c + '\'');
    }

    public static byte[] fromHex(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Hex string must not be null!");
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("Odd number of hex digits");
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(HexTool.charValue(string.charAt(i * 2)) << 4 | HexTool.charValue(string.charAt(i * 2 + 1)));
        }
        return byArray;
    }

    public static String toHex(byte[] byArray, int n, int n2, boolean bl) {
        if (byArray == null) {
            return "null";
        }
        if (n + n2 > byArray.length) {
            n2 = byArray.length - n;
        }
        int n3 = n2 * 2;
        if (bl) {
            n3 += n2 - 1;
        }
        char[] cArray = new char[n3];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = byArray[n + i] & 0xFF;
            cArray[n4++] = DIGITS[n5 >> 4];
            cArray[n4++] = DIGITS[n5 & 0xF];
            if (!bl || i >= n2 - 1) continue;
            cArray[n4++] = 32;
        }
        return new String(cArray);
    }

    public static String toHex(byte[] byArray, int n, int n2) {
        return HexTool.toHex(byArray, n, n2, false);
    }

    public static String toHex(byte[] byArray, boolean bl) {
        if (byArray == null) {
            return "null";
        }
        return HexTool.toHex(byArray, 0, byArray.length, bl);
    }

    public static String toHex(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        return HexTool.toHex(byArray, 0, byArray.length);
    }

    public static void printHex(byte[] byArray, OutputStream outputStream) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            outputStream.write(DIGITS[n >> 4]);
            outputStream.write(DIGITS[n & 0xF]);
        }
    }

    public static byte[] stripZeros(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length && byArray[n] == 0; ++n) {
        }
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public static int hashCode(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        while (--n2 >= 0) {
            n = (n << 8) + n2 + byArray[n2];
        }
        return n;
    }

    public static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        n3 += n;
        while (n < n3) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return true;
    }
}

