/*
 * Decompiled with CFR 0.152.
 */
package views;

import controllers.Setup;
import controllers.branding.Branding;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.CsvColumnSeparator;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Filter;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.CmBookingFilter;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.EclipseFreeHelper;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import play.api.data.Field;
import play.data.Form;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.libs.Scala;
import play.mvc.Call;
import play.mvc.Http;
import play.mvc.Security;
import play.twirl.api.Html;
import play.twirl.api.HtmlFormat;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.html.forms.defaultFormFieldConstructor;
import views.html.forms.modalFormFieldConstructor;
import views.html.helper.FieldConstructor;

public final class Utils {
    public static final int IBAN_CHAR_LIMIT = 42;
    public static final int BIC_CHAR_LIMIT = 11;
    private static final ThreadLocal<Map<Locale, SimpleDateFormat>> datePickerFormats = ThreadLocal.withInitial(HashMap::new);

    public static String amountColor(BigDecimal amount2) {
        if (amount2 != null && amount2.signum() == -1) {
            return "negativeAmount";
        }
        return "";
    }

    public static SimpleDateFormat getJavaDatePickerFormat(Locale locale) {
        locale = Utils.getLocaleForDatePicker(locale);
        Map<Locale, SimpleDateFormat> map = datePickerFormats.get();
        SimpleDateFormat dateFormat = map.get(locale);
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(((SimpleDateFormat)DateFormat.getDateInstance(3, locale)).toPattern().replaceAll("y{1,4}", "yyyy").replaceAll("d{1,2}", "dd").replaceAll("M{1,2}", "MM"));
            map.put(locale, dateFormat);
        }
        return dateFormat;
    }

    public static String getBootstrapDatePickerFormat(Locale requestLocale) {
        Locale locale = Utils.getLocaleForDatePicker(requestLocale);
        return Utils.getJavaDatePickerFormat(locale).toPattern().toLowerCase();
    }

    public static String getDatePickerFormattedDate(Locale requestLocale, Date date2) {
        if (date2 == null) {
            return null;
        }
        return Utils.getJavaDatePickerFormat(requestLocale).format(date2);
    }

    public static Date getDateFromDatePickerFormattedDate(Locale requestLocale, String formattedDate) throws ParseException {
        if (formattedDate == null) {
            return null;
        }
        return Utils.getJavaDatePickerFormat(requestLocale).parse(formattedDate);
    }

    public static Locale getLocaleForDatePicker(Locale locale) {
        if (!(locale != null && (Locale.GERMAN.getLanguage().equals(locale.getLanguage()) || Locale.ENGLISH.getLanguage().equals(locale.getLanguage()) || Locale.FRENCH.getLanguage().equals(locale.getLanguage()) || "es".equals(locale.getLanguage()) || "pt".equals(locale.getLanguage()) || "nl".equals(locale.getLanguage())))) {
            return Locale.ENGLISH;
        }
        return locale;
    }

    public static List<Integer> navigationPages(int pageCount, int pageNumber) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (pageCount < 9) {
            for (int i = 0; i < pageCount; ++i) {
                list.add(i);
            }
        } else if (pageNumber >= 0 && pageNumber <= 3) {
            for (int i = 0; i <= 5; ++i) {
                list.add(i);
            }
            list.add(-1);
            list.add(pageCount - 1);
        } else if (pageNumber >= pageCount - 4) {
            list.add(0);
            list.add(-1);
            for (int i = pageCount - 6; i < pageCount; ++i) {
                list.add(i);
            }
        } else {
            list.add(0);
            list.add(-1);
            for (int i = pageNumber - 2; i <= pageNumber + 2; ++i) {
                list.add(i);
            }
            list.add(-1);
            list.add(pageCount - 1);
        }
        return list;
    }

    public static String getPagingLink(Call call, int pageNumber, int pageSize) {
        StringBuilder result = new StringBuilder(call.toString());
        int argsStart = result.indexOf("?");
        HashMap<String, String> args = new HashMap<String, String>();
        if (argsStart >= 0 && argsStart < result.length() - 1) {
            for (String arg : result.substring(argsStart + 1, result.length()).split("&")) {
                int equalsPos = arg.indexOf(61);
                if (equalsPos > 0) {
                    args.put(arg.substring(0, equalsPos), arg.substring(equalsPos + 1));
                    continue;
                }
                args.put(arg, "");
            }
            result.setLength(argsStart);
        }
        pageSize = Math.max(1, Math.min(1000, pageSize));
        pageNumber = Math.max(0, pageNumber);
        args.put("pageNumber", String.valueOf(pageNumber));
        args.put("pageSize", String.valueOf(pageSize));
        result.append('?');
        boolean appendedArg = false;
        for (String arg : args.keySet()) {
            if (appendedArg) {
                result.append('&');
            }
            result.append(arg).append('=').append((String)args.get(arg));
            appendedArg = true;
        }
        return result.toString();
    }

    public static String getSortingLink(Call call, int sort, boolean ascending) {
        StringBuilder result = new StringBuilder(call.toString());
        int argsStart = result.indexOf("?");
        HashMap<Object, String> args = new HashMap<Object, String>();
        if (argsStart >= 0 && argsStart < result.length() - 1) {
            for (String arg : result.substring(argsStart + 1, result.length()).split("&")) {
                int equalsPos = arg.indexOf(61);
                if (equalsPos > 0) {
                    args.put(arg.substring(0, equalsPos), arg.substring(equalsPos + 1));
                    continue;
                }
                args.put(arg, "");
            }
            result.setLength(argsStart);
        }
        args.put("sort", String.valueOf(sort));
        args.put("ascending", String.valueOf(ascending));
        result.append('?');
        boolean appendedArg = false;
        for (String arg : args.keySet()) {
            if (appendedArg) {
                result.append('&');
            }
            result.append(arg).append('=').append((String)args.get(arg));
            appendedArg = true;
        }
        return result.toString();
    }

    public static Date addToDate(Date start, int dayCount) {
        return Utils.addToDate(start, 5, dayCount);
    }

    public static Html getBankUserIconAndName(BankUser bu) {
        if (bu != null) {
            String id = bu.getDefaultUser();
            if (id == null) {
                id = "";
            }
            if (BankUtils.isCreated((BankUser)bu)) {
                return new Html("<span class=\"fa fa-circle-half-stroke\"></span>&nbsp;" + String.valueOf(HtmlFormat.escape((String)id)));
            }
            if (BankUtils.isReady((BankUser)bu) || BankUtils.isLocked((BankUser)bu)) {
                return new Html("<span class=\"fa fa-circle\"></span>&nbsp;" + String.valueOf(HtmlFormat.escape((String)id)));
            }
            return new Html("<span class=\"fa fa-circle-dot\"></span>&nbsp;" + String.valueOf(HtmlFormat.escape((String)id)));
        }
        return new Html("<span class=\"fa fa-minus\"></span>");
    }

    public static String getBankUserTooltip(BankUser bu, Messages message) {
        if (bu != null) {
            if (bu.isDeactivated()) {
                return BankingApiMessages.getString((Locale)message.lang().locale(), (String)"GeneralMessages.bank.state.deactivated", (Object[])new Object[0]);
            }
            return BankingApiMessages.getString((Locale)message.lang().locale(), (String)("GeneralMessages.bank.state." + String.valueOf(bu.getState())), (Object[])new Object[0]);
        }
        return "";
    }

    public static String getBankUserStateCSS(BankUser bu) {
        if (bu != null && (bu.isDeactivated() || BankUtils.isLocked((BankUser)bu))) {
            return " bl-table-cell-failed";
        }
        if (BankUtils.isReady((BankUser)bu) || BankUtils.isCreated((BankUser)bu)) {
            return " bl-table-cell-success";
        }
        return "";
    }

    public static Date addToDate(Date start, int field, int count) {
        Calendar c = Calendar.getInstance();
        c.setTime(start);
        c.add(field, count);
        return c.getTime();
    }

    public static Seq<Tuple2<String, String>> getDateComparators(boolean includeEmpty, Locale locale) {
        ArrayList<Tuple2> comparators = new ArrayList<Tuple2>();
        if (includeEmpty) {
            comparators.add(Scala.Tuple((Object)"-1", (Object)""));
        }
        for (FilterComparator.Date comp : FilterComparator.Date.values()) {
            comparators.add(Scala.Tuple((Object)String.valueOf(comp.ordinal()), (Object)Filter.getDateComparatorText((FilterComparator.Date)comp, (Locale)locale)));
        }
        return Scala.toSeq(comparators);
    }

    public static Seq<Tuple2<String, String>> getAmountComparators(Locale locale) {
        ArrayList<Tuple2> comparators = new ArrayList<Tuple2>();
        for (FilterComparator.Amount comp : FilterComparator.Amount.values()) {
            comparators.add(new Tuple2((Object)String.valueOf(comp.ordinal()), (Object)Filter.getAmountComparatorText((FilterComparator.Amount)comp, (Locale)locale)));
        }
        return Scala.toSeq(comparators);
    }

    public static List<Tuple2<String, String>> getTextComparators(Locale locale) {
        ArrayList<Tuple2<String, String>> comparators = new ArrayList<Tuple2<String, String>>();
        for (FilterComparator.Text comp : FilterComparator.Text.values()) {
            comparators.add((Tuple2<String, String>)new Tuple2((Object)String.valueOf(comp.ordinal()), (Object)Filter.getTextComparatorText((FilterComparator.Text)comp, (Locale)locale)));
        }
        return comparators;
    }

    public static Seq<Tuple2<String, String>> getbookingTypeComparators(Locale locale) {
        ArrayList<Tuple2> comparators = new ArrayList<Tuple2>();
        for (CmBookingFilter.BookingType comp : CmBookingFilter.BookingType.values()) {
            comparators.add(new Tuple2((Object)String.valueOf(comp.ordinal()), (Object)EclipseFreeHelper.getBookingTypeText((CmBookingFilter.BookingType)comp, (Locale)locale)));
        }
        return Scala.toSeq(comparators);
    }

    public static Seq<Tuple2<String, String>> getBookingDirections(Locale locale) {
        ArrayList<Tuple2> directions = new ArrayList<Tuple2>();
        for (CmBookingFilter.BookingDirection direction : CmBookingFilter.BookingDirection.values()) {
            directions.add(new Tuple2((Object)String.valueOf(direction.ordinal()), (Object)EclipseFreeHelper.getBookingDirectionText((CmBookingFilter.BookingDirection)direction, (Locale)locale)));
        }
        return Scala.toSeq(directions);
    }

    public static void addToFlash(Map<String, String> flash2, String key, String value) {
        int maxLinesInFlash = 10;
        if (flash2.containsKey(key)) {
            String previousFlashMessages = flash2.get(key);
            Object tmp = previousFlashMessages.chars().filter(ch -> ch == 10).count() < 9L ? previousFlashMessages + "\n" + value : (previousFlashMessages.endsWith("\n...") ? previousFlashMessages : previousFlashMessages + "\n...");
            flash2.put(key, (String)tmp);
        } else {
            flash2.put(key, value);
        }
    }

    public static Map<String, String> convertFormErrorsToFlashMap(List<ValidationError> formErrors) {
        HashMap<String, String> flashMap = new HashMap<String, String>();
        for (ValidationError formError : formErrors) {
            Utils.addToFlash(flashMap, "error", formError.message());
        }
        return flashMap;
    }

    public static String getFormattedDataSize(Messages messages, Long size) {
        if (size != null) {
            if (size > 1024L) {
                double sizeInKb = (double)Math.round((double)size.longValue() / 1024.0 * 10.0) / 10.0;
                if (sizeInKb > 1024.0) {
                    double sizeInMb = (double)Math.round(sizeInKb / 1024.0 * 10.0) / 10.0;
                    if (sizeInMb > 1024.0) {
                        double sizeInGb = (double)Math.round(sizeInMb / 1024.0 * 10.0) / 10.0;
                        return messages.at("general.filesizegb", new Object[]{NumberFormat.getNumberInstance(messages.lang().locale()).format(sizeInGb)});
                    }
                    return messages.at("general.filesizemb", new Object[]{NumberFormat.getNumberInstance(messages.lang().locale()).format(sizeInMb)});
                }
                return messages.at("general.filesizekb", new Object[]{NumberFormat.getNumberInstance(messages.lang().locale()).format(sizeInKb)});
            }
            return messages.at("general.filesize", new Object[]{NumberFormat.getIntegerInstance(messages.lang().locale()).format(size)});
        }
        return null;
    }

    public static String formatAmount(BigDecimal amount2, String currencyString, Locale locale) {
        return Utils.formatAmount(amount2, currencyString, locale, true);
    }

    public static String formatAmount(BigDecimal amount2, String currencyString, Locale locale, boolean preventLineBreak) {
        if (amount2 == null) {
            return null;
        }
        Currency currency = currencyString == null ? null : Currency.getInstance((String)currencyString);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ("de".equals(locale.getLanguage()) && (locale.getCountry() == null || locale.getCountry().isEmpty())) {
            locale = Locale.GERMANY;
        }
        String result = PaymentUtils.formatAmount((BigDecimal)amount2, (Currency)currency, (Locale)locale);
        if (preventLineBreak) {
            result = result.replaceAll("\\s", "\u00a0");
        }
        return result;
    }

    public static boolean getPreferenceBoolean(Http.Request request, Preference.ApplicationId applicationId, DatabasePreferenceConstant preference2) {
        return new DatabasePreferenceStore(applicationId, User.getUser((String)((String)request.attrs().get(Security.USERNAME)))).getBoolean(preference2);
    }

    public static boolean getPreferenceBoolean(Http.Request request, Preference.ApplicationId applicationId, Tenant tenant, DatabasePreferenceConstant preference2) {
        return new DatabasePreferenceStore(applicationId, User.getUser((String)((String)request.attrs().get(Security.USERNAME))), tenant).getBoolean(preference2);
    }

    public static Seq<Tuple2<String, String>> getCsvColumnSeparators(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (CsvColumnSeparator sep : CsvColumnSeparator.values()) {
            result.add(Scala.Tuple((Object)sep.name(), (Object)sep.getDescription(locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getEncodings(boolean includeEmpty) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        if (includeEmpty) {
            result.add(Scala.Tuple((Object)"", (Object)""));
        }
        for (String charset : Charset.availableCharsets().keySet()) {
            result.add(Scala.Tuple((Object)charset, (Object)charset));
        }
        result.sort((o1, o2) -> {
            if (o1 == null || o1._2 == null) {
                if (o2 == null || o2._2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null || o2._2 == null) {
                return -1;
            }
            return ((String)o1._2).compareTo((String)o2._2);
        });
        return Scala.toSeq(result);
    }

    public static String getCurrencySymbol(String currencyCode, Locale locale) {
        return Utils.getCurrencySymbol(Currency.getInstance((String)currencyCode), locale);
    }

    public static String getCurrencySymbol(Currency currency, Locale locale) {
        try {
            java.util.Currency c = java.util.Currency.getInstance(currency.getCurrencyCode());
            if (c != null) {
                return c.getSymbol(locale);
            }
            return currency.getCurrencyCode();
        }
        catch (IllegalArgumentException e) {
            return currency.getCurrencyCode();
        }
    }

    public static String getPaymentCreatorName(User paymentCreator, Messages messages) {
        if (paymentCreator == null || paymentCreator.getName() == null || paymentCreator.getName().isEmpty()) {
            return messages.at("payment.creator.unknown", new Object[0]);
        }
        return paymentCreator.getName();
    }

    public static boolean showAutomaticExports(User user) {
        return user.isAdmin() || !new DatabasePreferenceStore(Preference.ApplicationId.CM, user).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.HIDE_AUTOMATIC_EXPORTS);
    }

    public static String getAccountNumber(Account account) {
        if (account.getIban() != null) {
            return IbanUtil.formatIBAN((String)account.getIban());
        }
        if (account.getGermanAccountNumber() != null) {
            return account.getGermanAccountNumber();
        }
        if (account.getFrenchAccountNumber() != null) {
            return account.getFrenchAccountNumber();
        }
        if (account.getNationalAccountNumber() != null) {
            return account.getNationalAccountNumber();
        }
        return "";
    }

    public static String getBankCode(Account account) {
        if (account.getBic() != null) {
            return account.getBic();
        }
        if (account.getGermanBankCode() != null) {
            return account.getGermanBankCode();
        }
        if (account.getFrenchBankCode() != null) {
            StringBuilder result = new StringBuilder(account.getFrenchBankCode());
            if (account.getFrenchBranchCode() != null) {
                result.append('/').append(account.getFrenchBranchCode());
            }
            return result.toString();
        }
        if (account.getNationalBankCode() != null) {
            return account.getNationalBankCode();
        }
        return "";
    }

    public static String getAccountDescription(Account account) {
        StringBuilder result = new StringBuilder(Utils.getBankCode(account));
        if (!result.isEmpty()) {
            result.append('/');
        }
        return result.append(Utils.getAccountNumber(account)).toString();
    }

    public static boolean useSepaMandates(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.USE_MANDATE_ADMISTRATION);
    }

    public static String webSocketUrl(Call call, Http.Request request) {
        if (Setup.WEBSOCKET_URL != null && !Setup.WEBSOCKET_URL.isEmpty()) {
            return call.webSocketURL(Setup.WEBSOCKET_URL_SECURE, Setup.WEBSOCKET_URL);
        }
        return call.webSocketURL(request);
    }

    public static String helpUrl(String path, Locale locale, Http.Request request) {
        Object generalUrl = System.getProperty("bl.help.url", "https://www.blbanking.de/web/help/");
        generalUrl = locale.getLanguage().equals(Locale.GERMAN.getLanguage()) ? (String)generalUrl + "de/" : (String)generalUrl + "en/";
        if (path != null && !path.isEmpty()) {
            return (String)generalUrl + path;
        }
        return generalUrl;
    }

    public static String fieldValue(Form<?> form, String fieldName) {
        Form.Field field = form.field(fieldName);
        if (field == null) {
            return null;
        }
        if (field.value().isPresent()) {
            return (String)field.value().get();
        }
        return null;
    }

    public static <T> T getForm(Form<T> form) {
        if (form != null && form.value() != null && form.value().isPresent()) {
            return form.value().get();
        }
        return null;
    }

    public static String getHeaderValue(Http.Request request, String field) {
        if (request.header(field).isPresent()) {
            return (String)request.header(field).get();
        }
        return null;
    }

    public static Branding getBranding() {
        return Branding.getBranding();
    }

    public static String addZWNJ(String label) {
        return label + "\u200c";
    }

    public static boolean isSelectOptionSelected(Field field, String optionValue) {
        optionValue = optionValue.replaceAll("\u200c", "");
        Option fieldValue = field.value();
        return fieldValue.isDefined() && optionValue.equals(fieldValue.get());
    }

    public static FieldConstructor getFormFieldConstructor(boolean forModals) {
        if (forModals) {
            return modalFormFieldConstructor::apply;
        }
        return defaultFormFieldConstructor::apply;
    }

    public static Html escapeNullsafe(Object input) {
        if (input == null) {
            return new Html("");
        }
        return HtmlFormat.escape((String)input.toString());
    }

    public static String getLocalizedMessage(Throwable t, Messages messages) {
        if (t instanceof EbicsException) {
            return BankingApiMessages.getErrorMessageWeb((Exception)((Object)((EbicsException)t)), (Locale)messages.lang().locale());
        }
        String message = t.getLocalizedMessage();
        if (message.contains("SunCertPathBuilderException")) {
            message = messages.at("general.error.invalidCertPath", new Object[0]);
        }
        return message;
    }

    public static boolean hasErrorFlash(Map<String, String> flashMap) {
        return flashMap.containsKey("error") || flashMap.containsKey("HTMLerror");
    }

    public static boolean hasWarningFlash(Map<String, String> flashMap) {
        return flashMap.containsKey("warning") || flashMap.containsKey("HTMLwarning");
    }

    public static boolean hasSuccessFlash(Map<String, String> flashMap) {
        return flashMap.containsKey("success") || flashMap.containsKey("HTMLsuccess");
    }

    public static boolean fieldValueChanged(Object oldValue, Object newValue) {
        if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal) {
            return ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) != 0;
        }
        if (oldValue instanceof Date && newValue instanceof Date) {
            return ((Date)oldValue).compareTo((Date)newValue) != 0;
        }
        if (oldValue instanceof String) {
            if (((String)oldValue).isEmpty() && newValue == null) {
                return false;
            }
            return !oldValue.equals(newValue);
        }
        if (newValue instanceof String) {
            if (((String)newValue).isEmpty() && oldValue == null) {
                return false;
            }
            return !newValue.equals(oldValue);
        }
        return oldValue != null && !oldValue.equals(newValue) || newValue != null && !newValue.equals(oldValue);
    }

    private Utils() {
    }
}

