/*
 * Decompiled with CFR 0.152.
 */
package models.preferences;

import controllers.util.BLLoggerPlay;
import controllers.util.BankOrder;
import controllers.util.BankOrderResultHandler;
import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import java.io.IOException;
import models.preferences.PreferenceChangedHandler;
import models.preferences.PreferenceChangedOperation;
import play.i18n.Messages;
import play.libs.ws.WSClient;

@PreferenceChangedOperation(application=Preference.ApplicationId.PAYMENTS, preferenceIds={"onlyAllSignedPayments"})
public class ShowAllSignedPaymentsPreferenceChangedOperation
implements PreferenceChangedHandler {
    private Messages messages;

    @Override
    public void preferenceChanged(User user, Tenant tenant, String oldValue, String newValue) {
        if (Boolean.valueOf(oldValue) != Boolean.valueOf(newValue) && Boolean.parseBoolean(newValue)) {
            try {
                BankOrder.createSignedPaymentsForAllUnknownSendOrders(tenant, user, new BankOrderResultHandler(this.messages, null), null);
            }
            catch (DisplayFileException | KnownFormatException | IOException e) {
                BLLoggerPlay.error("Failed to generate signed payments for unknown send orders!", e);
            }
        }
    }

    @Override
    public void setWSClient(WSClient wsClient) {
    }

    @Override
    public void setMessages(Messages messages) {
        this.messages = messages;
    }
}

