/*
 * Decompiled with CFR 0.152.
 */
package models.preferences;

import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import models.preferences.EbicsTracesPreferenceChangedOperation;
import models.preferences.EncryptionPreferenceChangedOperation;
import models.preferences.HighlightNewStatementsPreferenceChangedOperation;
import models.preferences.PasswordRequirementsPreferenceChangedOperation;
import models.preferences.PreferenceChangedOperation;
import models.preferences.SepaMandatesAdministrationChangedOperation;
import models.preferences.ShowAllSignedPaymentsPreferenceChangedOperation;
import models.preferences.UserLockedCounterChangedOperation;
import play.i18n.Messages;
import play.libs.ws.WSClient;

public interface PreferenceChangedHandler {
    public void preferenceChanged(User var1, Tenant var2, String var3, String var4);

    public void setWSClient(WSClient var1);

    public void setMessages(Messages var1);

    public static class Finder {
        private static final List<Class<? extends PreferenceChangedHandler>> handlers = new ArrayList<Class<? extends PreferenceChangedHandler>>();

        public static void reportChangedPreference(Preference.ApplicationId applicationId, DatabasePreferenceConstant pref, User user, Tenant tenant, String oldValue, String newValue, Messages messages, WSClient wsClient) {
            for (Class<? extends PreferenceChangedHandler> clazz : handlers) {
                PreferenceChangedOperation annotation;
                if (!clazz.isAnnotationPresent(PreferenceChangedOperation.class) || !Finder.shouldBeReported(annotation = clazz.getAnnotation(PreferenceChangedOperation.class), applicationId, pref)) continue;
                try {
                    PreferenceChangedHandler changedHandler = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    changedHandler.setWSClient(wsClient);
                    changedHandler.setMessages(messages);
                    changedHandler.preferenceChanged(user, tenant, oldValue, newValue);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private static boolean shouldBeReported(PreferenceChangedOperation annotation, Preference.ApplicationId applicationId, DatabasePreferenceConstant pref) {
            if (annotation.application() == applicationId) {
                for (String id : annotation.preferenceIds()) {
                    if (!id.equals(pref.getId())) continue;
                    return true;
                }
            }
            return false;
        }

        static {
            handlers.add(EncryptionPreferenceChangedOperation.class);
            handlers.add(EbicsTracesPreferenceChangedOperation.class);
            handlers.add(ShowAllSignedPaymentsPreferenceChangedOperation.class);
            handlers.add(SepaMandatesAdministrationChangedOperation.class);
            handlers.add(PasswordRequirementsPreferenceChangedOperation.class);
            handlers.add(HighlightNewStatementsPreferenceChangedOperation.class);
            handlers.add(UserLockedCounterChangedOperation.class);
        }
    }
}

