/*
 * Decompiled with CFR 0.152.
 */
package models.preferences;

import de.businesslogics.banking.api.PasswordRequirement;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.ClusterNode;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import models.preferences.PreferenceChangedHandler;
import models.preferences.PreferenceChangedOperation;
import play.i18n.Messages;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;

@PreferenceChangedOperation(application=Preference.ApplicationId.BANKING, preferenceIds={"PasswordMinLength", "PasswordNeedLetter", "PasswordNeedLower", "PasswordNeedUpper", "PasswordNeedNumber", "PasswordNeedSpecial", "PasswordChangeInDays", "PasswordCheckHistory"})
public final class PasswordRequirementsPreferenceChangedOperation
implements PreferenceChangedHandler {
    private WSClient wsClient;

    @Override
    public void preferenceChanged(User user, Tenant tenant, String oldValue, String newValue) {
        PasswordRequirement.reloadRequirements();
        ClusterNode thisNode = ClusterNode.getThisNode();
        for (ClusterNode node : DB.find(ClusterNode.class).findList()) {
            if (node.getId().equals(thisNode.getId())) continue;
            String url = node.getBaseURL();
            WSRequest request = this.wsClient.url(url + "/cluster/pwdRequirements");
            request.addHeader("secret", node.getSecret());
            request.execute("GET");
        }
    }

    @Override
    public void setWSClient(WSClient wsClient) {
        this.wsClient = wsClient;
    }

    @Override
    public void setMessages(Messages messages) {
    }
}

