/*
 * Decompiled with CFR 0.152.
 */
package models.preferences;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.ClusterNode;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.transfer.api.FetchScheduler;
import io.ebean.Query;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.TimeUnit;
import models.preferences.PreferenceChangedHandler;
import models.preferences.PreferenceChangedOperation;
import play.i18n.Messages;
import play.libs.ws.WSClient;
import play.libs.ws.WSRequest;

@PreferenceChangedOperation(application=Preference.ApplicationId.BANKING, preferenceIds={"EncyptData"})
public final class EncryptionPreferenceChangedOperation
implements PreferenceChangedHandler {
    private WSClient wsClient;

    @Override
    public void preferenceChanged(User user, Tenant tenant, String oldValue, String newValue) {
        if (Boolean.valueOf(oldValue) == Boolean.valueOf(newValue)) {
            return;
        }
        BLLoggerPlay.warning("Encrypting Preference Changed from " + oldValue + " to " + newValue);
        ClusterNode thisNode = ClusterNode.getThisNode();
        for (ClusterNode node : DB.find(ClusterNode.class).findList()) {
            if (node.getId().equals(thisNode.getId())) continue;
            String url = node.getBaseURL();
            WSRequest request = this.wsClient.url(url + "/cluster/changeEncryption/" + newValue);
            request.addHeader("secret", node.getSecret());
            request.execute("GET");
        }
        EncryptionPreferenceChangedOperation.updateEncryption(newValue);
    }

    public static void updateEncryption(String newValue) {
        EncryptData encrypt;
        try {
            FetchScheduler.shutdown((int)2, (TimeUnit)TimeUnit.MINUTES);
            encrypt = EncryptData.getInstance((boolean)Boolean.valueOf(newValue));
        }
        catch (IOException | InterruptedException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        ClusterNode thisNode = ClusterNode.getThisNode();
        Query query = WorkspaceFile.findFilesByNode((ClusterNode)thisNode);
        query.findStream().forEach(workspaceFile -> {
            File file2 = WorkspaceFileSystem.toFile((WorkspaceFile)workspaceFile);
            try {
                BLLoggerPlay.debug("Change encryption to " + (Boolean.parseBoolean(newValue) ? "encrypted" : "plain") + " for file: " + file2.getAbsolutePath());
                if (file2.isFile()) {
                    encrypt.updateFile(file2, Util.WORKSPACEDIR);
                } else {
                    BLLoggerPlay.warning("Encryption/Decryption failed for file: " + file2.getAbsolutePath() + " as the file does not exist");
                }
            }
            catch (IOException | GeneralSecurityException e) {
                BLLoggerPlay.error("Failed to " + (Boolean.parseBoolean(newValue) ? "encrypt" : "decrypt") + " file: " + file2.getAbsolutePath());
            }
        });
        try {
            FetchScheduler.reset();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setWSClient(WSClient wsClient) {
        this.wsClient = wsClient;
    }

    @Override
    public void setMessages(Messages messages) {
    }
}

