/*
 * Decompiled with CFR 0.152.
 */
package models.preferences;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import models.preferences.PreferenceChangedHandler;
import models.preferences.PreferenceChangedOperation;
import play.i18n.Messages;
import play.libs.ws.WSClient;

@PreferenceChangedOperation(application=Preference.ApplicationId.BANKING, preferenceIds={"ebicsTraces"})
public final class EbicsTracesPreferenceChangedOperation
implements PreferenceChangedHandler {
    private static final Map<Integer, Timer> resetTimer = new HashMap<Integer, Timer>();

    @Override
    public void preferenceChanged(final User user, final Tenant tenant, String oldValue, String newValue) {
        if (Boolean.valueOf(oldValue) == Boolean.valueOf(newValue)) {
            return;
        }
        Timer timer = resetTimer.get(user.getId());
        if (timer != null) {
            timer.cancel();
            resetTimer.remove(user.getId());
        }
        if (Boolean.parseBoolean(newValue)) {
            File tracesDir = new File(new File(Util.WORKSPACEDIR, "ebicstraces"), String.valueOf(user.getId()));
            if (tracesDir.isDirectory()) {
                SystemUtils.deleteRecursive((File)tracesDir);
            } else if (!tracesDir.mkdirs()) {
                BLLoggerPlay.warning("Failed to create EBICS traces directory " + tracesDir.getAbsolutePath());
            }
            timer = new Timer();
            timer.schedule(new TimerTask(this){

                @Override
                public void run() {
                    BLLoggerPlay.info("resetting EBICS traces preference");
                    new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user, tenant).setValue((DatabasePreferenceConstant)PreferenceConstants.EBICS_TRACES, false);
                }
            }, 3600000L);
            resetTimer.put(user.getId(), timer);
        }
    }

    @Override
    public void setWSClient(WSClient wsClient) {
    }

    @Override
    public void setMessages(Messages messages) {
    }
}

