/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.banking.sepa.api.SepaRecipientData;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAServiceLevel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import models.payments.PaymentException;
import models.payments.SepaPaymentHandler;

public class TaxOfficePaymentHandler
extends SepaPaymentHandler {
    protected static boolean handlesPmtType(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT.equals((Object)pmtType) || PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT.equals((Object)pmtType);
    }

    protected static List<TaxOfficePaymentHandler> getTaxOfficeHandlers(InputStream inputStream, PaymentTransferType.PmtType pmtType) throws PaymentException {
        ArrayList<TaxOfficePaymentHandler> result = new ArrayList<TaxOfficePaymentHandler>();
        int sequenceNumber = 1;
        for (SEPAPaymentData payment : SepaPaymentHandler.getPaymentDataFromInputStream(inputStream, pmtType)) {
            result.add(new TaxOfficePaymentHandler(pmtType, payment, sequenceNumber++));
        }
        return result;
    }

    protected TaxOfficePaymentHandler(PaymentTransferType.PmtType pmtType, byte[] rawPaymentData, int sequenceNumber) throws PaymentException {
        super(pmtType, rawPaymentData, sequenceNumber);
    }

    protected TaxOfficePaymentHandler(PaymentTransferType.PmtType pmtType, SEPAPaymentData payment, int sequenceNumber) {
        super(pmtType, payment, sequenceNumber);
    }

    @Override
    public RecipientData buildRecipient(boolean forceNewRecipient, Integer recipientId, PaymentType paymentType, Tenant tenant, List<Tenant> admissibleTenants, boolean allowRecipientModification) throws PaymentException {
        if (paymentType != PaymentType.AUSTRIAN_TAX_OFFICE) {
            throw new PaymentException("Invalid payment type for tax office recipients: " + paymentType.name());
        }
        PaymentRecipient paymentRecipient = null;
        if (!forceNewRecipient) {
            if (recipientId != null) {
                paymentRecipient = PaymentRecipient.findByIdAndTenants((int)recipientId, admissibleTenants);
            }
            if (paymentRecipient == null) {
                paymentRecipient = PaymentRecipient.findRecipientByAccountInfo(Collections.singletonList(paymentType), (String)((SEPAPaymentData)this.payment).getRecipient(), (String)((SEPAPaymentData)this.payment).getRecipientIban(), null, admissibleTenants);
            }
        }
        if (!allowRecipientModification && paymentRecipient != null) {
            return null;
        }
        if (paymentRecipient == null) {
            paymentRecipient = new PaymentRecipient();
            paymentRecipient.setTenant(tenant);
            paymentRecipient.setPaymentType(paymentType);
            paymentRecipient.setDisplayName(RecipientData.getUniqueDisplayName((String)((SEPAPaymentData)this.payment).getRecipient(), (PaymentType)paymentType, (Tenant)tenant));
        }
        paymentRecipient.setName(((SEPAPaymentData)this.payment).getRecipient());
        paymentRecipient.setAccountNumber(((SEPAPaymentData)this.payment).getRecipientIban());
        paymentRecipient.setBankCode(((SEPAPaymentData)this.payment).getRecipientBic());
        SepaRecipientData recipientData = new SepaRecipientData();
        try {
            recipientData.setPaymentRecipient(paymentRecipient);
        }
        catch (IOException e) {
            throw new PaymentException("Failed to load tax office recipient info!", e);
        }
        return recipientData;
    }

    @Override
    protected boolean internalResetReference() {
        return false;
    }

    @Override
    public PaymentTransferType.PmtType getPaymentType(PaymentTransferType.PmtType defaultType) {
        return SEPAServiceLevel.URGP.name().equals(((SEPAPaymentData)this.payment).getServiceLevel()) ? PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT : PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT;
    }
}

