/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import controllers.Recipients;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.sepa.SepaDebitType;
import de.businesslogics.banking.api.sepa.SepaSchemeHandler;
import de.businesslogics.banking.api.sepa.SepaSequenceType;
import de.businesslogics.banking.cfonb.api.CfonbApi;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PaymentApiMessages;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.banking.sepa.api.ChequeRecipientData;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.sepa.api.SepaForeignRecipientData;
import de.businesslogics.banking.sepa.api.SepaMandateData;
import de.businesslogics.banking.sepa.api.SepaOriginatorData;
import de.businesslogics.banking.sepa.api.SepaPaymentPrinter;
import de.businesslogics.banking.sepa.api.SepaRecipientData;
import de.businesslogics.format.sepa.GeneralSEPAExtractor;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.format.sepa.SepaCountry;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.Currency;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentUtils;
import org.xml.sax.SAXException;

public class SepaPaymentHandler
extends PaymentHandler<SEPAPaymentData> {
    private final boolean isFrench;
    private final boolean isForeignSepa;
    private final boolean isCheque;

    protected static boolean handlesPmtType(PaymentTransferType.PmtType pmtType) {
        return SepaApi.isCreditPmtType((PaymentTransferType.PmtType)pmtType) || SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType);
    }

    protected static List<SepaPaymentHandler> getSepaHandlers(InputStream inputStream, PaymentTransferType.PmtType pmtType) throws PaymentException {
        ArrayList<SepaPaymentHandler> result = new ArrayList<SepaPaymentHandler>();
        int sequenceNumber = 1;
        for (SEPAPaymentData payment : SepaPaymentHandler.getPaymentDataFromInputStream(inputStream, pmtType)) {
            result.add(new SepaPaymentHandler(pmtType, payment, sequenceNumber++));
        }
        return result;
    }

    protected static List<SEPAPaymentData> getPaymentDataFromInputStream(InputStream inputStream, PaymentTransferType.PmtType pmtType) throws PaymentException {
        try {
            if (SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType)) {
                return SepaApi.getPaymentData((boolean)true, (InputStream)inputStream);
            }
            if (SepaApi.isCreditPmtType((PaymentTransferType.PmtType)pmtType)) {
                return SepaApi.getPaymentData((boolean)false, (InputStream)inputStream);
            }
            throw new PaymentException("Unknown payment type: " + pmtType.name());
        }
        catch (IOException | SAXException e) {
            throw new PaymentException("Failed to parse SEPA payments from input stream!", e);
        }
    }

    protected SepaPaymentHandler(PaymentTransferType.PmtType pmtType, byte[] rawPaymentData, int sequenceNumber) throws PaymentException {
        super(pmtType, rawPaymentData, sequenceNumber);
        this.isFrench = CfonbApi.isCfonbPmtType((PaymentTransferType.PmtType)pmtType);
        this.isForeignSepa = SepaApi.isForeignPayment((PaymentTransferType.PmtType)pmtType);
        this.isCheque = SepaApi.isChequePayment((PaymentTransferType.PmtType)pmtType);
    }

    protected SepaPaymentHandler(PaymentTransferType.PmtType pmtType, SEPAPaymentData payment, int sequenceNumber) {
        super(payment, sequenceNumber);
        this.isFrench = CfonbApi.isCfonbPmtType((PaymentTransferType.PmtType)pmtType);
        this.isForeignSepa = SepaApi.isForeignPayment((PaymentTransferType.PmtType)pmtType);
        this.isCheque = SepaApi.isChequePayment((PaymentTransferType.PmtType)pmtType);
    }

    @Override
    public String getOriginator() {
        return ((SEPAPaymentData)this.payment).getOriginator();
    }

    @Override
    public boolean setOriginator(PaymentOriginator paymentOriginator) {
        if (paymentOriginator == null || paymentOriginator.getPaymentType() != PaymentType.SEPA && paymentOriginator.getPaymentType() != PaymentType.MANDATE) {
            return false;
        }
        SepaOriginatorData sepaOriginator = new SepaOriginatorData();
        try {
            sepaOriginator.setPaymentOriginator(paymentOriginator);
            ((SEPAPaymentData)this.payment).setOriginator(sepaOriginator.getName());
            ((SEPAPaymentData)this.payment).setInitiatingParty(sepaOriginator.getName());
            if (!this.isCredit()) {
                ((SEPAPaymentData)this.payment).setCreditorId(sepaOriginator.getCreditorId());
            }
            ((SEPAPaymentData)this.payment).setOriginatorAddressData(sepaOriginator.getAddress());
            return true;
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to load SEPA originator information for originator " + paymentOriginator.getId() + "!", e);
            return false;
        }
    }

    @Override
    public Account getOriginatorAccount(BankSettings bankSettings) {
        Currency accountCurrency = ((SEPAPaymentData)this.payment).getAccountCurrency() != null ? ((SEPAPaymentData)this.payment).getAccountCurrency() : ((SEPAPaymentData)this.payment).getCurrency();
        Account account = Account.findAccountByIban((BankSettings)bankSettings, (String)((SEPAPaymentData)this.payment).getOriginatorIban(), (String)accountCurrency.getCurrencyCode());
        if (account == null) {
            return Account.findAccountByIban((BankSettings)bankSettings, (String)((SEPAPaymentData)this.payment).getOriginatorIban(), null);
        }
        return account;
    }

    @Override
    public String getOriginatorAccount() {
        return Account.getInternationalDisplayName((String)((SEPAPaymentData)this.payment).getOriginatorBic(), (String)((SEPAPaymentData)this.payment).getOriginatorIban(), (String)((SEPAPaymentData)this.payment).getCurrency().getCurrencyCode(), null, (boolean)false, (boolean)false, (boolean)false);
    }

    @Override
    public boolean setOriginatorAccount(Account account) {
        if (account == null || account.getIban() == null) {
            return false;
        }
        ((SEPAPaymentData)this.payment).setOriginatorIban(account.getIban());
        ((SEPAPaymentData)this.payment).setOriginatorBic(account.getBic());
        ((SEPAPaymentData)this.payment).setAccountCurrency(Currency.getInstance((String)account.getCurrency()));
        return true;
    }

    @Override
    public String getRecipientAccountNumber() {
        return ((SEPAPaymentData)this.payment).getRecipientIban();
    }

    @Override
    public String getRecipientBankcode() {
        return ((SEPAPaymentData)this.payment).getRecipientBic();
    }

    @Override
    public String getAccountRepresentation(Account account) {
        if (account != null) {
            return Account.getInternationalDisplayName((Account)account, (boolean)false, (boolean)false, (boolean)false);
        }
        Account dummyAccount = new Account();
        dummyAccount.setIban(((SEPAPaymentData)this.payment).getOriginatorIban());
        dummyAccount.setBic(((SEPAPaymentData)this.payment).getOriginatorBic());
        if (((SEPAPaymentData)this.payment).getCurrency() != null) {
            dummyAccount.setCurrency(((SEPAPaymentData)this.payment).getCurrency().getCurrencyCode());
        }
        return Account.getInternationalDisplayName((Account)dummyAccount, (boolean)false, (boolean)false, (boolean)false);
    }

    @Override
    public boolean isSalaryPayment() {
        return SEPAUtil.isSalaryPayment((String)((SEPAPaymentData)this.payment).getPaymentCategory(), (String)((SEPAPaymentData)this.payment).getPurposeCode());
    }

    @Override
    public boolean isCredit() {
        return ((SEPAPaymentData)this.payment).isCredit();
    }

    @Override
    public boolean isUrgent(PaymentTransferType.PmtType pmtType) {
        return SepaApi.isUrgent((PaymentTransferType.PmtType)pmtType);
    }

    @Override
    public String getRecipientAccount() {
        Account account = new Account();
        account.setIban(((SEPAPaymentData)this.payment).getRecipientIban());
        account.setBic(((SEPAPaymentData)this.payment).getRecipientBic());
        return Account.getInternationalDisplayName((Account)account, (boolean)false, (boolean)false, (boolean)false);
    }

    @Override
    public String getRecipientNameAndAccount() {
        Account account = new Account();
        account.setIban(((SEPAPaymentData)this.payment).getRecipientIban());
        account.setBic(((SEPAPaymentData)this.payment).getRecipientBic());
        String accountNumber = Account.getInternationalDisplayName((Account)account, (boolean)false, (boolean)false, (boolean)false);
        return ((SEPAPaymentData)this.payment).getRecipient() + " (" + IbanUtil.formatIfIBAN((String)accountNumber) + ")";
    }

    @Override
    public String getRecipient() {
        return ((SEPAPaymentData)this.payment).getRecipient();
    }

    @Override
    public String getRecipientCountry() {
        if (this.isForeignSepa && ((SEPAPaymentData)this.payment).getRecipientAddressData() != null) {
            return ((SEPAPaymentData)this.payment).getRecipientAddressData().getCountry();
        }
        if (((SEPAPaymentData)this.payment).getRecipientIban() != null && ((SEPAPaymentData)this.payment).getRecipientIban().length() >= 2) {
            return ((SEPAPaymentData)this.payment).getRecipientIban().substring(0, 2);
        }
        if (((SEPAPaymentData)this.payment).getRecipientBic() != null && ((SEPAPaymentData)this.payment).getRecipientBic().length() >= 4) {
            return ((SEPAPaymentData)this.payment).getRecipientBic().substring(4, 6);
        }
        return null;
    }

    @Override
    public Date getExecutionDate() {
        return ((SEPAPaymentData)this.payment).getExecutionDate();
    }

    @Override
    public BigDecimal getAmount() {
        return ((SEPAPaymentData)this.payment).getAmount();
    }

    @Override
    public String getCurrencyCode() {
        if (((SEPAPaymentData)this.payment).getCurrency() != null) {
            return ((SEPAPaymentData)this.payment).getCurrency().getCurrencyCode();
        }
        return SEPAPaymentData.EUR.getCurrencyCode();
    }

    @Override
    public String getPurpose() {
        return ((SEPAPaymentData)this.payment).getPurpose();
    }

    @Override
    public void setPurpose(List<String> purpose) {
        if (purpose != null && !purpose.isEmpty()) {
            String purposeLine = purpose.getFirst();
            if (purposeLine.length() > 140) {
                ((SEPAPaymentData)this.payment).setPurpose(purposeLine.substring(0, 140));
            } else {
                ((SEPAPaymentData)this.payment).setPurpose(purposeLine);
            }
        } else {
            ((SEPAPaymentData)this.payment).setPurpose(null);
        }
    }

    @Override
    public boolean isSingleBooking() {
        return ((SEPAPaymentData)this.payment).displayAsSingleBooking();
    }

    @Override
    public boolean replaceInPurpose(String what, String by) {
        int maxPurposeLength = 140;
        if (by == null) {
            by = "";
        }
        if (what == null || what.isEmpty()) {
            if (!(by = by.substring(0, Math.min(by.length(), 140))).equals(((SEPAPaymentData)this.payment).getPurpose())) {
                ((SEPAPaymentData)this.payment).setPurpose(by);
                return true;
            }
        } else if (((SEPAPaymentData)this.payment).getPurpose() != null && !((SEPAPaymentData)this.payment).getPurpose().isEmpty()) {
            String replace = ((SEPAPaymentData)this.payment).getPurpose().replace(what, by);
            if (!(replace = replace.substring(0, Math.min(replace.length(), 140))).equals(((SEPAPaymentData)this.payment).getPurpose())) {
                ((SEPAPaymentData)this.payment).setPurpose(replace);
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getOrderType(String orderOrFileType, BankSettings bank) {
        if (BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
            return "BTU";
        }
        if (this.isFrench) {
            return "FUL";
        }
        return orderOrFileType;
    }

    @Override
    protected String getFileFormat(String orderOrFileType, BankSettings bank) {
        if (BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
            return orderOrFileType;
        }
        if (this.isFrench) {
            return orderOrFileType;
        }
        return null;
    }

    @Override
    public void print(BLDocument document, Locale locale, String orderOrFileType, SignedPayment signedPayment) throws PDFException {
        new SepaPaymentPrinter(locale, orderOrFileType).printPayment(document, signedPayment, (SEPAPaymentData)this.payment, null);
    }

    @Override
    public void setEarliestExecutionDate(Date executionDate, BankSettings bank, PaymentProperties paymentProperties) {
        Date earliestExecutionDate = SEPAUtil.getValidExecutionDate((GeneralSEPAWriter.Version)SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)SepaApi.getPmtType((SEPAPaymentData)((SEPAPaymentData)this.payment), (String)bank.getCountryCode())), (boolean)this.isCredit(), (String)((SEPAPaymentData)this.payment).getDebitType(), (String)((SEPAPaymentData)this.payment).getSequenceType(), (Date)executionDate, (int)SepaApi.getLeadTimeForDebits((PaymentProperties)paymentProperties));
        ((SEPAPaymentData)this.payment).setExecutionDate(earliestExecutionDate);
    }

    @Override
    public boolean isExecutionDateExceeded(PaymentProperties paymentProperties, String orderOrFileType) {
        if (((SEPAPaymentData)this.payment).getExecutionDate() != null) {
            BankSettings bank = paymentProperties == null ? null : paymentProperties.getBank();
            String countryCode = bank == null ? null : bank.getCountryCode();
            return SEPAUtil.isExecutionDateTooOld((GeneralSEPAWriter.Version)SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)SepaApi.getPmtType((SEPAPaymentData)((SEPAPaymentData)this.payment), (String)countryCode)), (boolean)((SEPAPaymentData)this.payment).isCredit(), (String)((SEPAPaymentData)this.payment).getDebitType(), (String)((SEPAPaymentData)this.payment).getSequenceType(), (Date)((SEPAPaymentData)this.payment).getExecutionDate(), (int)SepaApi.getLeadTimeForDebits((PaymentProperties)paymentProperties));
        }
        return false;
    }

    @Override
    public boolean isExecutionDateTooEarly(PaymentProperties paymentProperties) {
        if (((SEPAPaymentData)this.payment).getExecutionDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(((SEPAPaymentData)this.payment).getExecutionDate());
            cal.add(5, -paymentProperties.getSepaMaxExecDate());
            return new Date().before(cal.getTime());
        }
        return false;
    }

    @Override
    public String getCorrectionMessage(PaymentProperties paymentProperties, Locale locale) {
        BankSettings bank;
        GeneralSEPAWriter.Version version;
        if (paymentProperties != null && !((SEPAPaymentData)this.payment).isCredit() && SepaDebitType.COR1 == SepaDebitType.valueOf((String)((SEPAPaymentData)this.payment).getDebitType()) && GeneralSEPAWriter.isVersion30orNewer((GeneralSEPAWriter.Version)(version = SepaSchemeHandler.getSepaVersion((BankSettings)(bank = paymentProperties.getBank()), (PaymentTransferType.PmtType)SepaApi.getPmtType((SEPAPaymentData)((SEPAPaymentData)this.payment), (String)bank.getCountryCode()))))) {
            return PaymentApiMessages.getString((Locale)locale, (String)"OpenPayments.conversion.sepaCor1ToCore", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public int getMaxExecutionDateOffset(PaymentProperties paymentProperties) {
        return paymentProperties.getSepaMaxExecDate();
    }

    @Override
    public void correctPayment(OpenPayment vo, User user) throws PaymentException {
        ((SEPAPaymentData)this.payment).setDebitType(SepaDebitType.CORE.name());
        vo.setOrderType("CDD");
        vo.setPmtType(SepaApi.getPmtType((SEPAPaymentData)((SEPAPaymentData)this.payment), (String)vo.getBank().getCountryCode()));
        vo.setPaymentData(this.buildPaymentData(vo.getBank()));
        vo.save(user, false);
    }

    public SepaOriginatorData buildOriginator(Tenant tenant) throws PaymentException {
        PaymentOriginator paymentOriginator = PaymentOriginator.findOriginatorByName((PaymentType)PaymentType.SEPA, (String)((SEPAPaymentData)this.payment).getOriginator(), (Tenant)tenant);
        if (paymentOriginator == null) {
            paymentOriginator = new PaymentOriginator();
            paymentOriginator.setPaymentType(PaymentType.SEPA);
            paymentOriginator.setName(((SEPAPaymentData)this.payment).getOriginator());
            paymentOriginator.setTenant(tenant);
        }
        SepaOriginatorData sepaOriginator = new SepaOriginatorData();
        try {
            sepaOriginator.setPaymentOriginator(paymentOriginator);
            sepaOriginator.addAddress(((SEPAPaymentData)this.payment).getOriginatorAddressData());
        }
        catch (IOException e) {
            throw new PaymentException("Failed to load SEPA originator info!", e);
        }
        sepaOriginator.setCreditorId(((SEPAPaymentData)this.payment).getCreditorId());
        return sepaOriginator;
    }

    @Override
    public RecipientData buildRecipient(boolean forceNewRecipient, Integer recipientId, PaymentType paymentType, Tenant tenant, List<Tenant> admissibleTenants, boolean allowRecipientModification) throws PaymentException {
        PaymentRecipient paymentRecipient = null;
        if (!forceNewRecipient) {
            if (recipientId != null) {
                paymentRecipient = PaymentRecipient.findByIdAndTenants((int)recipientId, admissibleTenants);
            }
            if (paymentRecipient == null) {
                List<PaymentType> paymentTypeList = paymentType == PaymentType.SEPA ? List.of(PaymentType.SEPA, PaymentType.MANDATE) : Collections.singletonList(paymentType);
                paymentRecipient = PaymentRecipient.findRecipientByAccountInfo(paymentTypeList, (String)((SEPAPaymentData)this.payment).getRecipient(), (String)((SEPAPaymentData)this.payment).getRecipientIban(), null, admissibleTenants);
            }
        }
        if (!allowRecipientModification && paymentRecipient != null) {
            return null;
        }
        if (paymentRecipient == null) {
            paymentRecipient = new PaymentRecipient();
            paymentRecipient.setTenant(tenant);
            paymentRecipient.setPaymentType(paymentType);
            paymentRecipient.setDisplayName(RecipientData.getUniqueDisplayName((String)((SEPAPaymentData)this.payment).getRecipient(), (PaymentType)paymentType, (Tenant)tenant));
        }
        boolean recipientNameChanged = !((SEPAPaymentData)this.payment).getRecipient().equals(paymentRecipient.getName());
        paymentRecipient.setName(((SEPAPaymentData)this.payment).getRecipient());
        boolean recipientIbanChanged = !((SEPAPaymentData)this.payment).getRecipientIban().equals(paymentRecipient.getAccountNumber());
        paymentRecipient.setAccountNumber(((SEPAPaymentData)this.payment).getRecipientIban());
        paymentRecipient.setBankCode(((SEPAPaymentData)this.payment).getRecipientBic());
        paymentRecipient.setSepaMandateId(((SEPAPaymentData)this.payment).getMandateId());
        try {
            if (paymentType == PaymentType.SEPA) {
                SepaRecipientData recipientData = new SepaRecipientData();
                recipientData.setPaymentRecipient(paymentRecipient);
                recipientData.setAddress(((SEPAPaymentData)this.payment).getRecipientAddressData());
                recipientData.setMandateSignDate(((SEPAPaymentData)this.payment).getMandateSignDate());
                recipientData.setSequenceType(((SEPAPaymentData)this.payment).getSequenceType());
                recipientData.setPurpose(((SEPAPaymentData)this.payment).getPurpose());
                recipientData.setLeiNumber(((SEPAPaymentData)this.payment).getRecipientLei());
                Recipients.updateVopStatusAfterRecipientChanged(recipientData, recipientIbanChanged, recipientNameChanged);
                return recipientData;
            }
            if (paymentType == PaymentType.MANDATE) {
                SepaMandateData recipientData = new SepaMandateData();
                recipientData.setPaymentRecipient(paymentRecipient);
                recipientData.setAddress(((SEPAPaymentData)this.payment).getRecipientAddressData());
                recipientData.setMandateSignDate(((SEPAPaymentData)this.payment).getMandateSignDate());
                recipientData.setSequenceType(SepaSequenceType.getByName((String)((SEPAPaymentData)this.payment).getSequenceType()));
                recipientData.setMandateType(SepaDebitType.getByName((String)((SEPAPaymentData)this.payment).getDebitType()));
                recipientData.setCreditorId(((SEPAPaymentData)this.payment).getCreditorId());
                recipientData.setCreditor(((SEPAPaymentData)this.payment).getOriginator());
                recipientData.setPurpose(((SEPAPaymentData)this.payment).getPurpose());
                recipientData.setLeiNumber(((SEPAPaymentData)this.payment).getRecipientLei());
                return recipientData;
            }
            if (paymentType == PaymentType.SEPA_FOREIGN) {
                SepaForeignRecipientData recipientData = new SepaForeignRecipientData();
                recipientData.setPaymentRecipient(paymentRecipient);
                recipientData.setName(((SEPAPaymentData)this.payment).getRecipient());
                recipientData.addAddress(((SEPAPaymentData)this.payment).getRecipientAddressData());
                recipientData.setClearingSystemId(((SEPAPaymentData)this.payment).getRecipientClearingSystemId());
                recipientData.setBankName(((SEPAPaymentData)this.payment).getRecipientBankName());
                recipientData.addBankAddress(((SEPAPaymentData)this.payment).getRecipientBankAddressData());
                recipientData.setPurpose(((SEPAPaymentData)this.payment).getPurpose());
                recipientData.setFeeType(((SEPAPaymentData)this.payment).getChargeBearer());
                recipientData.setLeiNumber(((SEPAPaymentData)this.payment).getRecipientLei());
                return recipientData;
            }
            if (paymentType == PaymentType.CHEQUE) {
                ChequeRecipientData recipientData = new ChequeRecipientData();
                recipientData.setPaymentRecipient(paymentRecipient);
                recipientData.setName(((SEPAPaymentData)this.payment).getRecipient());
                recipientData.addAddress(((SEPAPaymentData)this.payment).getRecipientAddressData());
                recipientData.setPurpose(((SEPAPaymentData)this.payment).getPurpose());
                recipientData.setFeeType(((SEPAPaymentData)this.payment).getChargeBearer());
                return recipientData;
            }
            throw new PaymentException("Invalid payment type for SEPA recipients: " + paymentType.name());
        }
        catch (IOException e) {
            throw new PaymentException("Failed to load SEPA recipient info!", e);
        }
    }

    @Override
    public byte[] buildPaymentData(BankSettings bank) throws PaymentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GeneralSEPAWriter.Version sepaVersion = ((SEPAPaymentData)this.payment).getSepaVersion();
            if (sepaVersion == null) {
                sepaVersion = SepaApi.getSEPAVersionForPayment((SEPAPaymentData)((SEPAPaymentData)this.payment), (BankSettings)bank);
            }
            GeneralSEPAWriter.write((GeneralSEPAWriter.Version)sepaVersion, (SEPAPaymentData)((SEPAPaymentData)this.payment), (OutputStream)baos);
        }
        catch (IOException e) {
            throw new PaymentException("Failed to write SEPA payment information: " + e.getLocalizedMessage(), e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                BLLoggerPlay.getLogger().logError("Failed to close stream!", (Throwable)e);
            }
        }
        return baos.toByteArray();
    }

    @Override
    public boolean updatePaymentAfterGeneration() {
        if (((SEPAPaymentData)this.payment).hasModifiedMandate()) {
            ((SEPAPaymentData)this.payment).setOriginalCreditor(null);
            ((SEPAPaymentData)this.payment).setOriginalCreditorId(null);
            ((SEPAPaymentData)this.payment).setOriginalMandateId(null);
            ((SEPAPaymentData)this.payment).setOriginalRecipientIban(null);
            ((SEPAPaymentData)this.payment).setOriginalRecipientBic(null);
            ((SEPAPaymentData)this.payment).setRecipientAccountHasChanged(false);
            ((SEPAPaymentData)this.payment).setRecipientBankHasChanged(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean checkRecipientAccount() {
        if (this.isCheque) {
            return ((SEPAPaymentData)this.payment).getRecipientIban() == null || ((SEPAPaymentData)this.payment).getRecipientIban().isEmpty();
        }
        if (this.isForeignSepa) {
            return ((SEPAPaymentData)this.payment).getRecipientIban() != null && !((SEPAPaymentData)this.payment).getRecipientIban().isEmpty();
        }
        return ((SEPAPaymentData)this.payment).getRecipientIban() != null && IbanUtil.checkIban((String)((SEPAPaymentData)this.payment).getRecipientIban()) && SepaCountry.isSepaCountry((String)((SEPAPaymentData)this.payment).getRecipientIban().substring(0, 2));
    }

    @Override
    protected SEPAPaymentData loadPayment(PaymentTransferType.PmtType pmtType, byte[] paymentData) throws PaymentException {
        ByteArrayInputStream bais = new ByteArrayInputStream(paymentData);
        try {
            if (SepaApi.isCreditPmtType((PaymentTransferType.PmtType)pmtType)) {
                SEPAPaymentData sEPAPaymentData = GeneralSEPAExtractor.getPaymentFromCCT((InputStream)bais);
                return sEPAPaymentData;
            }
            if (SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType)) {
                SEPAPaymentData sEPAPaymentData = GeneralSEPAExtractor.getDebitPayment((InputStream)bais);
                return sEPAPaymentData;
            }
            SEPAPaymentData sEPAPaymentData = null;
            return sEPAPaymentData;
        }
        catch (Exception e) {
            throw new PaymentException("Failed to load SEPA payment: " + e.getLocalizedMessage(), e);
        }
        finally {
            try {
                ((InputStream)bais).close();
            }
            catch (IOException e) {
                BLLoggerPlay.getLogger().logError("Failed to close stream!", (Throwable)e);
            }
        }
    }

    @Override
    protected String loadReference(int sequenceNumber) {
        if (sequenceNumber > 0) {
            return SepaApi.getPaymentReference((SEPAPaymentData)((SEPAPaymentData)this.payment), (int)sequenceNumber);
        }
        return null;
    }

    @Override
    protected boolean internalResetReference() {
        ((SEPAPaymentData)this.payment).setEndToEndId(null);
        return true;
    }

    @Override
    public PaymentTransferType.PmtType getPaymentType(PaymentTransferType.PmtType defaultType) {
        return SepaApi.getPmtType((SEPAPaymentData)((SEPAPaymentData)this.payment), (PaymentTransferType.PmtType)defaultType);
    }

    @Override
    public void updateSignedPayment(SignedPayment signedPayment) throws PaymentException {
        super.updateSignedPayment(signedPayment);
        signedPayment.setPmtInfId(((SEPAPaymentData)this.payment).getPmtInfId());
    }

    public String getOriginatorAddressLine1() {
        return PaymentUtils.getDKAddressLine1(((SEPAPaymentData)this.payment).getOriginatorAddressData(), null);
    }

    public String getOriginatorAddressLine2() {
        return PaymentUtils.getDKAddressLine2(((SEPAPaymentData)this.payment).getOriginatorAddressData(), null);
    }

    public String getOriginatorAddressCountry() {
        return ((SEPAPaymentData)this.payment).getOriginatorAddressData().getCountry();
    }

    public String getRecipientAddressLine1() {
        return PaymentUtils.getDKAddressLine1(((SEPAPaymentData)this.payment).getRecipientAddressData(), null);
    }

    public String getRecipientAddressLine2() {
        return PaymentUtils.getDKAddressLine2(((SEPAPaymentData)this.payment).getRecipientAddressData(), null);
    }

    public String getRecipientAddressCountry() {
        return ((SEPAPaymentData)this.payment).getRecipientAddressData().getCountry();
    }
}

