/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import controllers.branding.Branding;
import controllers.util.BLLoggerPlay;
import controllers.util.CsvImport;
import controllers.util.TenantUtils;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.BicLoader;
import de.businesslogics.banking.payments.api.PaymentConversionHandler2;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.format.csv.CSVConverterException;
import de.businesslogics.format.csv.Column;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPALocalInstrument;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.format.sepa.SepaCountry;
import de.businesslogics.format.sepa.csv.ColumnHandler;
import de.businesslogics.format.sepa.csv.FieldI;
import de.businesslogics.format.sepa.csv.Format2;
import de.businesslogics.format.sepa.csv.SepaCSVFormatParser;
import de.businesslogics.format.sepa.csv.XLSColumHandler;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.validation.RegularExpressions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import models.payments.PaymentCsvImportException;
import models.payments.PaymentCsvImportHandler;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentUtils;
import play.i18n.Messages;

public final class SepaPaymentCsvImportHandler
implements PaymentCsvImportHandler {
    private final User user;
    private final PaymentConversionHandler2<?> conversionHandler;
    private final boolean isCredit;
    private final boolean isUrgent;
    private final boolean isTemplate;
    private final boolean isPeriodicPayment;
    private ConverterFormat converterFormat;
    private final List<Throwable> errors = new ArrayList<Throwable>();

    public SepaPaymentCsvImportHandler(User user, PaymentConversionHandler2<?> conversionHandler, ConverterFormat converterFormat, boolean isCredit, boolean isUrgent, boolean isTemplate, boolean isPeriodicPayment) {
        this.user = user;
        this.conversionHandler = conversionHandler;
        this.converterFormat = converterFormat;
        this.isCredit = isCredit;
        this.isUrgent = isUrgent;
        this.isTemplate = isTemplate;
        this.isPeriodicPayment = isPeriodicPayment;
    }

    @Override
    public void loadFieldsToDataMap(Map<String, String> dataMap) {
        Format2 format;
        if (this.converterFormat != null) {
            format = new Format2(this.converterFormat.getFormat(), this.converterFormat.getCountryCode(), (ColumnHandler)new XLSColumHandler());
            if (dataMap != null && this.converterFormat.getCountryCode() != null) {
                dataMap.put("countryCode", this.converterFormat.getCountryCode());
            }
        } else {
            format = (Format2)this.conversionHandler.getDefaultFormat();
        }
        this.loadToDataMap(dataMap, format, Format2.Fields.ORIGINATOR_NAME);
        this.loadToDataMap(dataMap, format, Format2.Fields.ULTIMATE_ORIGINATOR);
        this.loadToDataMap(dataMap, format, Format2.Fields.ORIGINATOR_IBAN);
        this.loadToDataMap(dataMap, format, Format2.Fields.ORIGINATOR_BIC);
        this.loadToDataMap(dataMap, format, Format2.Fields.ACCOUNT_CURRENCY);
        this.loadToDataMap(dataMap, format, Format2.Fields.RECIPIENT_NAME);
        this.loadToDataMap(dataMap, format, Format2.Fields.ULTIMATE_RECIPIENT);
        this.loadToDataMap(dataMap, format, Format2.Fields.RECIPIENT_IBAN);
        this.loadToDataMap(dataMap, format, Format2.Fields.RECIPIENT_BIC);
        this.loadToDataMap(dataMap, format, Format2.Fields.AMOUNT);
        this.loadToDataMap(dataMap, format, Format2.Fields.CURRENCY);
        this.loadToDataMap(dataMap, format, Format2.Fields.PURPOSE);
        this.loadToDataMap(dataMap, format, Format2.Fields.PURPOSE_REFERENCE);
        this.loadToDataMap(dataMap, format, Format2.Fields.CATEGORY_PURPOSE);
        this.loadToDataMap(dataMap, format, Format2.Fields.PURPOSE_CODE);
        this.loadToDataMap(dataMap, format, Format2.Fields.DATE);
        this.loadToDataMap(dataMap, format, Format2.Fields.END_TO_END);
        this.loadToDataMap(dataMap, format, Format2.Fields.SINGLE_BOOKING);
        this.loadToDataMap(dataMap, format, Format2.Fields.ORIGINATOR_STREET);
        this.loadToDataMap(dataMap, format, Format2.Fields.ORIGINATOR_TOWN);
        this.loadToDataMap(dataMap, format, Format2.Fields.ORIGINATOR_COUNTRY);
        this.loadToDataMap(dataMap, format, Format2.Fields.RECIPIENT_STREET);
        this.loadToDataMap(dataMap, format, Format2.Fields.RECIPIENT_TOWN);
        this.loadToDataMap(dataMap, format, Format2.Fields.RECIPIENT_COUNTRY);
        if (this.isCredit) {
            this.loadToDataMap(dataMap, format, Format2.Fields.INSTRUCTION_PRIORITY);
        } else {
            this.loadToDataMap(dataMap, format, Format2.Fields.CREDITOR_ID);
            this.loadToDataMap(dataMap, format, Format2.Fields.MANDATE_ID);
            this.loadToDataMap(dataMap, format, Format2.Fields.MANDATE_SIGNATURE);
            this.loadToDataMap(dataMap, format, Format2.Fields.SEQUENCE_TYPE);
        }
    }

    @Override
    public List<CsvImport.Field> getFields(Messages messages) {
        Locale locale = messages != null ? messages.lang().locale() : Locale.getDefault();
        ArrayList<CsvImport.Field> result = new ArrayList<CsvImport.Field>();
        if (this.isCredit) {
            result.add(CsvImport.Field.getSeparator());
            result.add(CsvImport.Field.getTextField("GeneralMessages.originator", Format2.Fields.ORIGINATOR_NAME.name().toLowerCase(), true));
            result.add(CsvImport.Field.getTextField("GeneralMessages.ultimateOriginator", Format2.Fields.ULTIMATE_ORIGINATOR.name().toLowerCase(), false));
            result.add(CsvImport.Field.getTextField("GeneralMessages.originatorIban", Format2.Fields.ORIGINATOR_IBAN.name().toLowerCase(), true));
            result.add(CsvImport.Field.getTextField("GeneralMessages.originatorBic", Format2.Fields.ORIGINATOR_BIC.name().toLowerCase(), false));
            result.add(CsvImport.Field.getSelectField("GeneralMessages.accountCurrency", Format2.Fields.ACCOUNT_CURRENCY.name().toLowerCase(), false, PaymentUtils.getCurrencies(true)));
            result.add(CsvImport.Field.getTextField("GeneralMessages.address1", Format2.Fields.ORIGINATOR_STREET.name().toLowerCase(), false));
            result.add(CsvImport.Field.getTextField("GeneralMessages.address2", Format2.Fields.ORIGINATOR_TOWN.name().toLowerCase(), false));
            result.add(CsvImport.Field.getTextField("GeneralMessages.originatorCountryCode", Format2.Fields.ORIGINATOR_COUNTRY.name().toLowerCase(), false));
            result.add(CsvImport.Field.getSeparator());
            result.add(CsvImport.Field.getTextField("GeneralMessages.recipient", Format2.Fields.RECIPIENT_NAME.name().toLowerCase(), true));
            result.add(CsvImport.Field.getTextField("GeneralMessages.ultimatePayee", Format2.Fields.ULTIMATE_RECIPIENT.name().toLowerCase(), false));
            result.add(CsvImport.Field.getTextField("GeneralMessages.recipientIban", Format2.Fields.RECIPIENT_IBAN.name().toLowerCase(), true));
            result.add(CsvImport.Field.getTextField("GeneralMessages.recipientBic", Format2.Fields.RECIPIENT_BIC.name().toLowerCase(), false));
            result.add(CsvImport.Field.getTextField("GeneralMessages.address1", Format2.Fields.RECIPIENT_STREET.name().toLowerCase(), false));
            result.add(CsvImport.Field.getTextField("GeneralMessages.address2", Format2.Fields.RECIPIENT_TOWN.name().toLowerCase(), false));
            result.add(CsvImport.Field.getTextField("GeneralMessages.recipientCountryCode", Format2.Fields.RECIPIENT_COUNTRY.name().toLowerCase(), false));
        } else {
            result.add(CsvImport.Field.getSeparator());
            result.add(CsvImport.Field.getTextField(Branding.getBranding().originatorLabelForSEPADebit(), Format2.Fields.ORIGINATOR_NAME.name().toLowerCase(), true));
            result.add(CsvImport.Field.getTextField("GeneralMessages.ultimatePayee", Format2.Fields.ULTIMATE_ORIGINATOR.name().toLowerCase(), false));
            result.add(CsvImport.Field.getTextField("GeneralMessages.payeeIban", Format2.Fields.ORIGINATOR_IBAN.name().toLowerCase(), true));
            result.add(CsvImport.Field.getTextField("GeneralMessages.payeeBic", Format2.Fields.ORIGINATOR_BIC.name().toLowerCase(), false));
            result.add(CsvImport.Field.getSelectField("GeneralMessages.accountCurrency", Format2.Fields.ACCOUNT_CURRENCY.name().toLowerCase(), false, PaymentUtils.getCurrencies(true)));
            result.add(CsvImport.Field.getTextField("GeneralMessages.creditorId", Format2.Fields.CREDITOR_ID.name().toLowerCase(), true));
            result.add(CsvImport.Field.getSeparator());
            result.add(CsvImport.Field.getTextField("GeneralMessages.payer", Format2.Fields.RECIPIENT_NAME.name().toLowerCase(), true));
            result.add(CsvImport.Field.getTextField("GeneralMessages.ultimatePayer", Format2.Fields.ULTIMATE_RECIPIENT.name().toLowerCase(), false));
            result.add(CsvImport.Field.getTextField("GeneralMessages.payerIban", Format2.Fields.RECIPIENT_IBAN.name().toLowerCase(), true));
            result.add(CsvImport.Field.getTextField("GeneralMessages.payerBic", Format2.Fields.RECIPIENT_BIC.name().toLowerCase(), false));
            result.add(CsvImport.Field.getTextField("GeneralMessages.address1", Format2.Fields.RECIPIENT_STREET.name().toLowerCase(), false));
            result.add(CsvImport.Field.getTextField("GeneralMessages.address2", Format2.Fields.RECIPIENT_TOWN.name().toLowerCase(), false));
            result.add(CsvImport.Field.getTextField("GeneralMessages.payerCountryCode", Format2.Fields.RECIPIENT_COUNTRY.name().toLowerCase(), false));
            result.add(CsvImport.Field.getTextField("GeneralMessages.mandateReference", Format2.Fields.MANDATE_ID.name().toLowerCase(), true));
            result.add(CsvImport.Field.getTextField("GeneralMessages.mandateSignDate", Format2.Fields.MANDATE_SIGNATURE.name().toLowerCase(), true));
            result.add(CsvImport.Field.getSelectField("GeneralMessages.sequenceType", Format2.Fields.SEQUENCE_TYPE.name().toLowerCase(), true, PaymentUtils.getSepaSequenceTypes(locale)));
        }
        result.add(CsvImport.Field.getSeparator());
        result.add(CsvImport.Field.getTextField("GeneralMessages.amount", Format2.Fields.AMOUNT.name().toLowerCase(), true));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.currency", Format2.Fields.CURRENCY.name().toLowerCase(), false, PaymentUtils.getCurrencies(true)));
        result.add(CsvImport.Field.getTextField("GeneralMessages.purpose", Format2.Fields.PURPOSE.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.creditorReference", Format2.Fields.PURPOSE_REFERENCE.name().toLowerCase(), false));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.paymentCategory", Format2.Fields.CATEGORY_PURPOSE.name().toLowerCase(), false, PaymentUtils.getSepaCategories(this.user, locale, this.isUrgent)));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.paymentMethod", Format2.Fields.PURPOSE_CODE.name().toLowerCase(), false, PaymentUtils.getSepaPurposeCodes(this.user, locale, this.isUrgent)));
        if (this.isCredit) {
            result.add(CsvImport.Field.getSelectField("GeneralMessages.priority", Format2.Fields.INSTRUCTION_PRIORITY.name().toLowerCase(), false, PaymentUtils.getSepainstructionPriorities(locale)));
        }
        if (!this.isTemplate && !this.isPeriodicPayment) {
            if (this.isCredit) {
                result.add(CsvImport.Field.getTextField("GeneralMessages.executionDate", Format2.Fields.DATE.name().toLowerCase(), true));
            } else {
                result.add(CsvImport.Field.getTextField("GeneralMessages.paymentDate", Format2.Fields.DATE.name().toLowerCase(), true));
            }
        }
        result.add(CsvImport.Field.getTextField("GeneralMessages.endToEndReference", Format2.Fields.END_TO_END.name().toLowerCase(), false));
        result.add(CsvImport.Field.getBooleanField("GeneralMessages.displayAsSingleBooking", Format2.Fields.SINGLE_BOOKING.name().toLowerCase(), false));
        return result;
    }

    @Override
    public String buildFormatString(Map<String, Object> formatFields, PaymentTransferType.PmtType pmtType) {
        if (this.isCredit) {
            if (SepaApi.isUrgent((PaymentTransferType.PmtType)pmtType)) {
                formatFields.put(Format2.Fields.CREDIT_TYPE.name().toLowerCase(), GeneralSEPAWriter.ServiceLevel.URGP.name());
            } else {
                formatFields.put(Format2.Fields.CREDIT_TYPE.name().toLowerCase(), GeneralSEPAWriter.ServiceLevel.SEPA.name());
            }
        } else if (PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT.equals((Object)pmtType) || PaymentTransferType.PmtType.SWISS_SEPA_B2B_DIRECT_DEBIT.equals((Object)pmtType)) {
            formatFields.put(Format2.Fields.DEBIT_TYPE.name().toLowerCase(), GeneralSEPAWriter.DebitType.B2B.name());
        } else if (PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT.equals((Object)pmtType)) {
            formatFields.put(Format2.Fields.DEBIT_TYPE.name().toLowerCase(), GeneralSEPAWriter.DebitType.COR1.name());
        } else {
            formatFields.put(Format2.Fields.DEBIT_TYPE.name().toLowerCase(), GeneralSEPAWriter.DebitType.CORE.name());
        }
        StringBuilder result = new StringBuilder();
        this.appendFieldToFormatString(Format2.Fields.ORIGINATOR_NAME, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ORIGINATOR_IBAN, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.AMOUNT, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.RECIPIENT_NAME, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.RECIPIENT_IBAN, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ORIGINATOR_BIC, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ULTIMATE_ORIGINATOR, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.RECIPIENT_BIC, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ULTIMATE_RECIPIENT, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.DATE, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.CATEGORY_PURPOSE, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.END_TO_END, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.PURPOSE, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.SINGLE_BOOKING, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.CREDIT_TYPE, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.MANDATE_ID, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.MANDATE_SIGNATURE, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.CREDITOR_ID, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.SEQUENCE_TYPE, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.DEBIT_TYPE, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.PURPOSE_CODE, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.RECIPIENT_STREET, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.RECIPIENT_TOWN, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.RECIPIENT_COUNTRY, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.INSTRUCTION_ID, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.CURRENCY, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ACCOUNT_CURRENCY, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ORIGINATOR_STREET, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ORIGINATOR_TOWN, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ORIGINATOR_COUNTRY, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.INSTRUCTION_PRIORITY, formatFields, result);
        result.append("|");
        result.append("|");
        result.append("|");
        result.append("|");
        result.append("|");
        result.append("|");
        this.appendFieldToFormatString(Format2.Fields.PURPOSE_REFERENCE, formatFields, result);
        return result.substring(0, result.length() - 1);
    }

    @Override
    public List<PaymentHandler<?>> loadPayments(BankSettings bank, String formatString, PaymentTransferType.PmtType pmtType, String language, String[][] data, boolean stringentCheck, String encoding) {
        Format2 format = PaymentUtils.getCsvFormat2(bank, pmtType, formatString, language);
        SepaCSVFormatParser csvParser = new SepaCSVFormatParser(format, true);
        boolean displaySalaries = Util.displayOpenSalaries((User)this.user);
        ArrayList result = new ArrayList(data.length);
        for (int i = 0; i < data.length; ++i) {
            try {
                Tenant tenant;
                Account account;
                SEPAPaymentData paymentData = csvParser.getPaymentData(data[i], i);
                if (SepaApi.isInstantCreditPaymentType((PaymentTransferType.PmtType)pmtType)) {
                    paymentData.setLocalInstrument(SEPALocalInstrument.INST.name());
                }
                if (paymentData.getInitiatingParty() == null) {
                    paymentData.setInitiatingParty(paymentData.getOriginator());
                }
                if (stringentCheck) {
                    this.checkPaymentData(paymentData);
                }
                PaymentHandler<?> paymentHandler = PaymentHandler.getHandler(paymentData, pmtType);
                if (!displaySalaries && paymentHandler.isSalaryPayment()) {
                    throw new PaymentCsvImportException("sepapayment.csv.error.salarynotallowed", new Object[0]);
                }
                if (bank == null) {
                    BankSettings b;
                    account = null;
                    Iterator iterator = BankSettings.findBanksForUser((User)this.user).iterator();
                    while (iterator.hasNext() && (account = paymentHandler.getOriginatorAccount(b = (BankSettings)iterator.next())) == null) {
                    }
                    tenant = account != null ? account.getBank().getTenant() : null;
                } else {
                    account = paymentHandler.getOriginatorAccount(bank);
                    tenant = bank.getTenant();
                }
                if (new DatabasePreferenceStore(Preference.ApplicationId.SEPA, this.user, tenant).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.SAVE_ACCOUNT_CURRENCY)) {
                    if (account != null && account.getCurrency() != null) {
                        ((SEPAPaymentData)paymentHandler.getPayment()).setAccountCurrency(Currency.getInstance((String)account.getCurrency()));
                    }
                    if (account != null && paymentData.getOriginatorBic() == null) {
                        ((SEPAPaymentData)paymentHandler.getPayment()).setOriginatorBic(account.getBic());
                    }
                }
                result.add(paymentHandler);
                continue;
            }
            catch (CSVConverterException | PaymentCsvImportException | PaymentException e) {
                this.errors.add(e);
                BLLoggerPlay.error("Failed to read payment from CSV data in line " + i + "!", e);
            }
        }
        if (this.converterFormat == null) {
            this.converterFormat = new ConverterFormat();
            this.converterFormat.setTenant(TenantUtils.findTenantForConverterFormat(bank, result, this.user));
        }
        if (this.isCredit) {
            this.converterFormat.setType(ConverterFormat.Type.SEPA_CREDIT);
        } else {
            this.converterFormat.setType(ConverterFormat.Type.SEPA_DEBIT);
        }
        if (encoding != null && !encoding.isEmpty()) {
            this.converterFormat.setEncoding(encoding);
        }
        this.converterFormat.setFieldSeparator("|");
        this.converterFormat.setCountryCode(language);
        this.converterFormat.setFormat(formatString);
        return result;
    }

    @Override
    public PaymentType getRecipientPaymentType(User user) {
        if (!this.isCredit && new DatabasePreferenceStore(Preference.ApplicationId.SEPA, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.USE_MANDATE_ADMISTRATION)) {
            return PaymentType.MANDATE;
        }
        return PaymentType.SEPA;
    }

    @Override
    public PaymentType getOriginatorPaymentType() {
        return PaymentType.SEPA;
    }

    @Override
    public void updateConverterFormat(boolean hasHeader) {
        if (this.converterFormat == null) {
            return;
        }
        this.converterFormat.setHasHeader(hasHeader);
        this.converterFormat.save();
    }

    private void loadToDataMap(Map<String, String> dataMap, Format2 format, Format2.Fields field) {
        Column column = format.getColumn((FieldI)field);
        if (column != null) {
            if (column.getValue() != null && !column.getValue().isEmpty()) {
                dataMap.put(field.name().toLowerCase() + "_fix", column.getValue());
            } else {
                dataMap.put(field.name().toLowerCase(), String.valueOf(column.getColumnIndex()));
            }
        }
    }

    private void appendFieldToFormatString(Format2.Fields field, Map<String, Object> fields, StringBuilder builder) {
        Object o = fields.get(field.name().toLowerCase());
        if (o != null) {
            if (o instanceof String) {
                builder.append('=');
            }
            builder.append(o);
        }
        builder.append("|");
    }

    private void checkPaymentData(SEPAPaymentData paymentData) throws PaymentCsvImportException {
        if (!(this.isCredit || new DatabasePreferenceStore(Preference.ApplicationId.SEPA, this.user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.ALLOW_INVALID_CREDITOR_ID) || SEPAUtil.checkCreditorId((String)paymentData.getCreditorId()))) {
            throw new PaymentCsvImportException("sepapayment.csv.error.invalidcreditorid", paymentData.getCreditorId());
        }
        boolean allowInvalidBankConnection = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, this.user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_INVALID_BANK_CONNECTION);
        if (paymentData.getPurposeReference() != null && !paymentData.getPurposeReference().isEmpty() && new DatabasePreferenceStore(Preference.ApplicationId.SEPA, this.user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.ALLOW_ONLY_ISO11649_CREDTIOR_REFERENCES) && !RegularExpressions.CREDITOR_REFERENCE_ISO11649.matches(paymentData.getPurposeReference())) {
            throw new PaymentCsvImportException("sepapayment.csv.error.invalidpaymentreference", paymentData.getPurposeReference());
        }
        if (!allowInvalidBankConnection && !IbanUtil.checkIban((String)paymentData.getRecipientIban())) {
            throw new PaymentCsvImportException("sepapayment.csv.error.invalidiban", IbanUtil.formatIfIBAN((String)paymentData.getRecipientIban()));
        }
        if ((paymentData.getRecipientBic() == null || paymentData.getRecipientBic().isEmpty()) && !SepaCountry.isIbanOnlyAllowed((String)paymentData.getRecipientIban().substring(0, 2))) {
            throw new PaymentCsvImportException("sepapayment.csv.error.ibanonlynotallowed", paymentData.getRecipientIban().substring(0, 2));
        }
        if (!allowInvalidBankConnection && paymentData.getRecipientBic() != null && !paymentData.getRecipientBic().isEmpty() && BicLoader.getInstance().getBankName(paymentData.getRecipientBic()) == null) {
            throw new PaymentCsvImportException("sepapayment.csv.error.invalidbic", paymentData.getRecipientBic());
        }
        if (SEPAUtil.SEPA_PAYMENT_MAX_AMOUNT.compareTo(paymentData.getAmount()) < 0) {
            throw new PaymentCsvImportException("sepapayment.csv.error.maxamountexceeded", de.businesslogics.util.PaymentUtils.formatAmount((BigDecimal)paymentData.getAmount(), (Currency)paymentData.getCurrency()));
        }
    }

    @Override
    public Set<String> getErrorMessages(Messages messages) {
        HashSet<String> result = new HashSet<String>(this.errors.size());
        for (Throwable t : this.errors) {
            if (t instanceof PaymentCsvImportException) {
                result.add(((PaymentCsvImportException)t).getMessage(messages));
                continue;
            }
            result.add(t.getMessage());
        }
        return result;
    }
}

