/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import controllers.util.BLLoggerPlay;
import controllers.util.CsvImport;
import controllers.util.TenantUtils;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.BicLoader;
import de.businesslogics.banking.payments.api.PaymentConversionHandler2;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.format.csv.CSVConverterException;
import de.businesslogics.format.csv.Column;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAUtil;
import de.businesslogics.format.sepa.SepaCountry;
import de.businesslogics.format.sepa.csv.ColumnHandler;
import de.businesslogics.format.sepa.csv.FieldI;
import de.businesslogics.format.sepa.csv.Format2;
import de.businesslogics.format.sepa.csv.SepaCSVFormatParser;
import de.businesslogics.format.sepa.csv.XLSColumHandler;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import models.SepaPaymentForm;
import models.payments.PaymentCsvImportException;
import models.payments.PaymentCsvImportHandler;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentUtils;
import play.i18n.Messages;

public final class SepaForeignPaymentCsvImportHandler
implements PaymentCsvImportHandler {
    private final User user;
    private final PaymentConversionHandler2<?> conversionHandler;
    private ConverterFormat converterFormat;
    private final List<Throwable> errors = new ArrayList<Throwable>();

    public SepaForeignPaymentCsvImportHandler(User user, PaymentConversionHandler2<?> conversionHandler, ConverterFormat converterFormat) {
        this.user = user;
        this.conversionHandler = conversionHandler;
        this.converterFormat = converterFormat;
    }

    @Override
    public void loadFieldsToDataMap(Map<String, String> dataMap) {
        Format2 format;
        if (this.converterFormat != null) {
            format = new Format2(this.converterFormat.getFormat(), this.converterFormat.getCountryCode(), (ColumnHandler)new XLSColumHandler());
            if (dataMap != null && this.converterFormat.getCountryCode() != null) {
                dataMap.put("countryCode", this.converterFormat.getCountryCode());
            }
        } else {
            format = (Format2)this.conversionHandler.getDefaultFormat();
        }
        this.loadToDataMap(dataMap, format, Format2.Fields.ORIGINATOR_NAME);
        this.loadToDataMap(dataMap, format, Format2.Fields.ORIGINATOR_STREET);
        this.loadToDataMap(dataMap, format, Format2.Fields.ORIGINATOR_COUNTRY);
        this.loadToDataMap(dataMap, format, Format2.Fields.ORIGINATOR_IBAN);
        this.loadToDataMap(dataMap, format, Format2.Fields.ORIGINATOR_BIC);
        this.loadToDataMap(dataMap, format, Format2.Fields.ACCOUNT_CURRENCY);
        this.loadToDataMap(dataMap, format, Format2.Fields.RECIPIENT_NAME);
        this.loadToDataMap(dataMap, format, Format2.Fields.RECIPIENT_STREET);
        this.loadToDataMap(dataMap, format, Format2.Fields.RECIPIENT_COUNTRY);
        this.loadToDataMap(dataMap, format, Format2.Fields.RECIPIENT_IBAN);
        this.loadToDataMap(dataMap, format, Format2.Fields.CLEARING_SYSTEM_ID);
        this.loadToDataMap(dataMap, format, Format2.Fields.RECIPIENT_BIC);
        this.loadToDataMap(dataMap, format, Format2.Fields.BANK_NAME);
        this.loadToDataMap(dataMap, format, Format2.Fields.BANK_STREET);
        this.loadToDataMap(dataMap, format, Format2.Fields.BANK_COUNTRY);
        this.loadToDataMap(dataMap, format, Format2.Fields.AMOUNT);
        this.loadToDataMap(dataMap, format, Format2.Fields.CURRENCY);
        this.loadToDataMap(dataMap, format, Format2.Fields.PURPOSE);
        this.loadToDataMap(dataMap, format, Format2.Fields.CATEGORY_PURPOSE);
        this.loadToDataMap(dataMap, format, Format2.Fields.PURPOSE_CODE);
        this.loadToDataMap(dataMap, format, Format2.Fields.DATE);
        this.loadToDataMap(dataMap, format, Format2.Fields.END_TO_END);
        this.loadToDataMap(dataMap, format, Format2.Fields.CHARGE_BEARER);
        this.loadToDataMap(dataMap, format, Format2.Fields.CREDIT_TYPE);
        this.loadToDataMap(dataMap, format, Format2.Fields.INSTRUCTION_PRIORITY);
    }

    @Override
    public List<CsvImport.Field> getFields(Messages messages) {
        Locale locale = messages != null ? messages.lang().locale() : Locale.getDefault();
        ArrayList<CsvImport.Field> result = new ArrayList<CsvImport.Field>();
        result.add(CsvImport.Field.getSeparator());
        result.add(CsvImport.Field.getTextField("GeneralMessages.originator", Format2.Fields.ORIGINATOR_NAME.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.address", Format2.Fields.ORIGINATOR_STREET.name().toLowerCase(), false));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.countryCode", Format2.Fields.ORIGINATOR_COUNTRY.name().toLowerCase(), false, PaymentUtils.getCountries(locale, true)));
        result.add(CsvImport.Field.getTextField("GeneralMessages.originatorIban", Format2.Fields.ORIGINATOR_IBAN.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.originatorBic", Format2.Fields.ORIGINATOR_BIC.name().toLowerCase(), false));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.accountCurrency", Format2.Fields.ACCOUNT_CURRENCY.name().toLowerCase(), false, PaymentUtils.getCurrencies(true)));
        result.add(CsvImport.Field.getSeparator());
        result.add(CsvImport.Field.getTextField("GeneralMessages.recipient", Format2.Fields.RECIPIENT_NAME.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.address", Format2.Fields.RECIPIENT_STREET.name().toLowerCase(), false));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.countryCode", Format2.Fields.RECIPIENT_COUNTRY.name().toLowerCase(), true, PaymentUtils.getCountries(locale, true)));
        result.add(CsvImport.Field.getTextField("GeneralMessages.recipientIban", Format2.Fields.RECIPIENT_IBAN.name().toLowerCase(), true));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.clearingSystem", Format2.Fields.CLEARING_SYSTEM_ID.name().toLowerCase(), false, PaymentUtils.getClearingSystems()));
        result.add(CsvImport.Field.getTextField("GeneralMessages.recipientBic", Format2.Fields.RECIPIENT_BIC.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.bank", Format2.Fields.BANK_NAME.name().toLowerCase(), false));
        result.add(CsvImport.Field.getTextField("GeneralMessages.bankAddress", Format2.Fields.BANK_STREET.name().toLowerCase(), false));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.countryCode", Format2.Fields.BANK_COUNTRY.name().toLowerCase(), false, PaymentUtils.getCountries(locale, true)));
        result.add(CsvImport.Field.getSeparator());
        result.add(CsvImport.Field.getTextField("GeneralMessages.amount", Format2.Fields.AMOUNT.name().toLowerCase(), true));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.currency", Format2.Fields.CURRENCY.name().toLowerCase(), false, PaymentUtils.getCurrencies(true)));
        result.add(CsvImport.Field.getTextField("GeneralMessages.purpose", Format2.Fields.PURPOSE.name().toLowerCase(), false));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.paymentCategory", Format2.Fields.CATEGORY_PURPOSE.name().toLowerCase(), false, PaymentUtils.getSepaCategories(this.user, locale, false)));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.paymentMethod", Format2.Fields.PURPOSE_CODE.name().toLowerCase(), false, PaymentUtils.getSepaPurposeCodes(this.user, locale, false)));
        result.add(CsvImport.Field.getTextField("GeneralMessages.executionDate", Format2.Fields.DATE.name().toLowerCase(), true));
        result.add(CsvImport.Field.getTextField("GeneralMessages.endToEndReference", Format2.Fields.END_TO_END.name().toLowerCase(), false));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.feeType", Format2.Fields.CHARGE_BEARER.name().toLowerCase(), false, SepaPaymentForm.loadFeeTypes(locale, true)));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.serviceLevel", Format2.Fields.CREDIT_TYPE.name().toLowerCase(), false, SepaPaymentForm.loadInternationalServiceLevel(locale, this.user)));
        result.add(CsvImport.Field.getSelectField("GeneralMessages.priority", Format2.Fields.INSTRUCTION_PRIORITY.name().toLowerCase(), false, PaymentUtils.getSepainstructionPriorities(locale)));
        return result;
    }

    @Override
    public String buildFormatString(Map<String, Object> formatFields, PaymentTransferType.PmtType pmtType) {
        StringBuilder result = new StringBuilder();
        this.appendFieldToFormatString(Format2.Fields.ORIGINATOR_NAME, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ORIGINATOR_IBAN, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.AMOUNT, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.RECIPIENT_NAME, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.RECIPIENT_IBAN, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ORIGINATOR_BIC, formatFields, result);
        result.append("|");
        this.appendFieldToFormatString(Format2.Fields.RECIPIENT_BIC, formatFields, result);
        result.append("|");
        this.appendFieldToFormatString(Format2.Fields.DATE, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.CATEGORY_PURPOSE, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.END_TO_END, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.PURPOSE, formatFields, result);
        result.append("|");
        this.appendFieldToFormatString(Format2.Fields.CREDIT_TYPE, formatFields, result);
        result.append("|");
        result.append("|");
        result.append("|");
        result.append("|");
        result.append("|");
        this.appendFieldToFormatString(Format2.Fields.PURPOSE_CODE, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.RECIPIENT_STREET, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.RECIPIENT_TOWN, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.RECIPIENT_COUNTRY, formatFields, result);
        result.append("|");
        this.appendFieldToFormatString(Format2.Fields.CURRENCY, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ACCOUNT_CURRENCY, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ORIGINATOR_STREET, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ORIGINATOR_TOWN, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.ORIGINATOR_COUNTRY, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.INSTRUCTION_PRIORITY, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.CHARGE_BEARER, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.BANK_NAME, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.BANK_STREET, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.BANK_TOWN, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.BANK_COUNTRY, formatFields, result);
        this.appendFieldToFormatString(Format2.Fields.CLEARING_SYSTEM_ID, formatFields, result);
        result.append("|");
        return result.substring(0, result.length() - 1);
    }

    @Override
    public List<PaymentHandler<?>> loadPayments(BankSettings bank, String formatString, PaymentTransferType.PmtType pmtType, String language, String[][] data, boolean stringentCheck, String encoding) {
        Format2 format = PaymentUtils.getCsvFormat2(bank, pmtType, formatString, language);
        format.setCreateInstantPayments(false);
        format.setCreateInternationalPayments(true);
        SepaCSVFormatParser csvParser = new SepaCSVFormatParser(format, true);
        boolean displaySalaries = Util.displayOpenSalaries((User)this.user);
        ArrayList result = new ArrayList(data.length);
        for (int i = 0; i < data.length; ++i) {
            try {
                Tenant tenant;
                Account account;
                if (Arrays.stream(data[i]).allMatch(s -> s.trim().isEmpty())) continue;
                SEPAPaymentData paymentData = csvParser.getPaymentData(data[i], i);
                if (paymentData.getInitiatingParty() == null) {
                    paymentData.setInitiatingParty(paymentData.getOriginator());
                }
                if (stringentCheck) {
                    this.checkPaymentData(paymentData);
                }
                PaymentHandler<?> paymentHandler = PaymentHandler.getHandler(paymentData, pmtType);
                if (!displaySalaries && paymentHandler.isSalaryPayment()) {
                    throw new PaymentCsvImportException("sepapayment.csv.error.salarynotallowed", new Object[0]);
                }
                if (bank == null) {
                    BankSettings b;
                    account = null;
                    Iterator iterator = BankSettings.findBanksForUser((User)this.user).iterator();
                    while (iterator.hasNext() && (account = paymentHandler.getOriginatorAccount(b = (BankSettings)iterator.next())) == null) {
                    }
                    tenant = account != null ? account.getBank().getTenant() : null;
                } else {
                    account = paymentHandler.getOriginatorAccount(bank);
                    tenant = bank.getTenant();
                }
                if (new DatabasePreferenceStore(Preference.ApplicationId.SEPA, this.user, tenant).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.sepa.PreferenceConstants.SAVE_ACCOUNT_CURRENCY)) {
                    Currency accountCurrency = paymentData.getAccountCurrency();
                    if (accountCurrency != null) {
                        ((SEPAPaymentData)paymentHandler.getPayment()).setAccountCurrency(accountCurrency);
                    } else {
                        if (account != null && account.getCurrency() != null) {
                            ((SEPAPaymentData)paymentHandler.getPayment()).setAccountCurrency(Currency.getInstance((String)account.getCurrency()));
                        }
                        if (account != null && paymentData.getOriginatorBic() == null) {
                            ((SEPAPaymentData)paymentHandler.getPayment()).setOriginatorBic(account.getBic());
                        }
                    }
                }
                result.add(paymentHandler);
                continue;
            }
            catch (CSVConverterException | PaymentCsvImportException | PaymentException e) {
                this.errors.add(e);
                BLLoggerPlay.error("Failed to read payment from CSV data in line " + i + "!", e);
            }
        }
        if (this.converterFormat == null) {
            this.converterFormat = new ConverterFormat();
            this.converterFormat.setTenant(TenantUtils.findTenantForConverterFormat(bank, result, this.user));
        }
        this.converterFormat.setType(ConverterFormat.Type.PAIN_001_INTERNATIONAL);
        if (encoding != null && !encoding.isEmpty()) {
            this.converterFormat.setEncoding(encoding);
        }
        this.converterFormat.setFieldSeparator("|");
        this.converterFormat.setCountryCode(language);
        this.converterFormat.setFormat(formatString);
        return result;
    }

    @Override
    public PaymentType getRecipientPaymentType(User user) {
        return PaymentType.SEPA_FOREIGN;
    }

    @Override
    public PaymentType getOriginatorPaymentType() {
        return PaymentType.SEPA;
    }

    @Override
    public void updateConverterFormat(boolean hasHeader) {
        if (this.converterFormat == null) {
            return;
        }
        this.converterFormat.setHasHeader(hasHeader);
        this.converterFormat.save();
    }

    private void loadToDataMap(Map<String, String> dataMap, Format2 format, Format2.Fields field) {
        Column column = format.getColumn((FieldI)field);
        if (column != null) {
            if (column.getValue() != null && !column.getValue().isEmpty()) {
                dataMap.put(field.name().toLowerCase() + "_fix", column.getValue());
            } else {
                dataMap.put(field.name().toLowerCase(), String.valueOf(column.getColumnIndex()));
            }
        }
    }

    private void appendFieldToFormatString(Format2.Fields field, Map<String, Object> fields, StringBuilder builder) {
        Object o = fields.get(field.name().toLowerCase());
        if (o != null) {
            if (o instanceof String) {
                builder.append('=');
            }
            builder.append(o);
        }
        builder.append("|");
    }

    private void checkPaymentData(SEPAPaymentData paymentData) throws PaymentCsvImportException {
        boolean allowInvalidBankConnection = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, this.user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_INVALID_BANK_CONNECTION);
        if (!allowInvalidBankConnection && !IbanUtil.checkIban((String)paymentData.getRecipientIban())) {
            throw new PaymentCsvImportException("sepapayment.csv.error.invalidiban", IbanUtil.formatIfIBAN((String)paymentData.getRecipientIban()));
        }
        if ((paymentData.getRecipientBic() == null || paymentData.getRecipientBic().isEmpty()) && !SepaCountry.isIbanOnlyAllowed((String)paymentData.getRecipientIban().substring(0, 2))) {
            throw new PaymentCsvImportException("sepapayment.csv.error.ibanonlynotallowed", paymentData.getRecipientIban().substring(0, 2));
        }
        if (!allowInvalidBankConnection && paymentData.getRecipientBic() != null && !paymentData.getRecipientBic().isEmpty() && BicLoader.getInstance().getBankName(paymentData.getRecipientBic()) == null) {
            throw new PaymentCsvImportException("sepapayment.csv.error.invalidbic", paymentData.getRecipientBic());
        }
        if (SEPAUtil.SEPA_PAYMENT_MAX_AMOUNT.compareTo(paymentData.getAmount()) < 0) {
            throw new PaymentCsvImportException("sepapayment.csv.error.maxamountexceeded", de.businesslogics.util.PaymentUtils.formatAmount((BigDecimal)paymentData.getAmount(), (Currency)paymentData.getCurrency()));
        }
    }

    @Override
    public Set<String> getErrorMessages(Messages messages) {
        HashSet<String> result = new HashSet<String>(this.errors.size());
        for (Throwable t : this.errors) {
            if (t instanceof PaymentCsvImportException) {
                result.add(((PaymentCsvImportException)t).getMessage(messages));
                continue;
            }
            result.add(t.getMessage());
        }
        return result;
    }
}

