/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.banking.sepa.api.PostbarRecipientData;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.at.PostbarPurpose;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import models.payments.PaymentException;
import models.payments.SepaPaymentHandler;

public class PostbarPaymentHandler
extends SepaPaymentHandler {
    protected static boolean handlesPmtType(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT.equals((Object)pmtType);
    }

    protected static List<PostbarPaymentHandler> getPostbarHandlers(InputStream inputStream, PaymentTransferType.PmtType pmtType) throws PaymentException {
        ArrayList<PostbarPaymentHandler> result = new ArrayList<PostbarPaymentHandler>();
        int sequenceNumber = 1;
        for (SEPAPaymentData payment : SepaPaymentHandler.getPaymentDataFromInputStream(inputStream, pmtType)) {
            result.add(new PostbarPaymentHandler(pmtType, payment, sequenceNumber++));
        }
        return result;
    }

    protected PostbarPaymentHandler(PaymentTransferType.PmtType pmtType, byte[] rawPaymentData, int sequenceNumber) throws PaymentException {
        super(pmtType, rawPaymentData, sequenceNumber);
    }

    protected PostbarPaymentHandler(PaymentTransferType.PmtType pmtType, SEPAPaymentData payment, int sequenceNumber) {
        super(pmtType, payment, sequenceNumber);
    }

    @Override
    public String getRecipient() {
        return ((SEPAPaymentData)this.payment).getUltimateRecipient();
    }

    @Override
    public String getPurpose() {
        PostbarPurpose postbarPurpose = PostbarPurpose.getPostbarPurpose((String)((SEPAPaymentData)this.payment).getPurpose());
        return postbarPurpose.getPurpose();
    }

    @Override
    public void setPurpose(List<String> purpose) {
        PostbarPurpose postbarPurpose = PostbarPurpose.getPostbarPurpose((String)((SEPAPaymentData)this.payment).getPurpose());
        String purposeLine = "";
        if (purpose != null && !purpose.isEmpty()) {
            purposeLine = purpose.get(0);
        }
        postbarPurpose.setPurpose(purposeLine);
        String totalPurpose = postbarPurpose.getTotalPurpose();
        if (totalPurpose.length() > 140) {
            int newLength = purposeLine.length() - (totalPurpose.length() - 140);
            if (newLength < 0) {
                return;
            }
            postbarPurpose.setPurpose(purposeLine.substring(0, newLength));
        }
        ((SEPAPaymentData)this.payment).setPurpose(postbarPurpose.getTotalPurpose());
    }

    @Override
    public boolean replaceInPurpose(String what, String by) {
        int maxPurposeLength = 140;
        if (by == null) {
            by = "";
        }
        if (what == null || what.isEmpty()) {
            if (((SEPAPaymentData)this.payment).getPurpose() != null && !((SEPAPaymentData)this.payment).getPurpose().isEmpty()) {
                PostbarPurpose postbarPurpose = PostbarPurpose.getPostbarPurpose((String)((SEPAPaymentData)this.payment).getPurpose());
                postbarPurpose.setPurpose(by);
                String totalPurpose = postbarPurpose.getTotalPurpose();
                totalPurpose = totalPurpose.substring(0, Math.min(totalPurpose.length(), 140));
                if (!totalPurpose.equals(((SEPAPaymentData)this.payment).getPurpose())) {
                    ((SEPAPaymentData)this.payment).setPurpose(totalPurpose);
                    return true;
                }
            } else if (!by.equals(((SEPAPaymentData)this.payment).getPurpose())) {
                ((SEPAPaymentData)this.payment).setPurpose(by);
                return true;
            }
        } else if (((SEPAPaymentData)this.payment).getPurpose() != null && !((SEPAPaymentData)this.payment).getPurpose().isEmpty()) {
            PostbarPurpose postbarPurpose = PostbarPurpose.getPostbarPurpose((String)((SEPAPaymentData)this.payment).getPurpose());
            String replace = postbarPurpose.getPurpose().replace(what, by);
            postbarPurpose.setPurpose(replace);
            String totalPurpose = postbarPurpose.getTotalPurpose();
            totalPurpose = totalPurpose.substring(0, Math.min(totalPurpose.length(), 140));
            if (!replace.equals(postbarPurpose.getPurpose())) {
                ((SEPAPaymentData)this.payment).setPurpose(totalPurpose);
                return true;
            }
        }
        return false;
    }

    @Override
    public byte[] buildPaymentData(BankSettings bank) throws PaymentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GeneralSEPAWriter.write((GeneralSEPAWriter.Version)GeneralSEPAWriter.Version.V25Iso, (SEPAPaymentData)((SEPAPaymentData)this.payment), (OutputStream)baos);
        }
        catch (IOException e) {
            throw new PaymentException("Failed to write postbar payment information: " + e.getLocalizedMessage(), e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                BLLoggerPlay.getLogger().logError("Failed to close stream!", (Throwable)e);
            }
        }
        return baos.toByteArray();
    }

    @Override
    public RecipientData buildRecipient(boolean forceNewRecipient, Integer recipientId, PaymentType paymentType, Tenant tenant, List<Tenant> admissibleTenants, boolean allowRecipientModification) throws PaymentException {
        if (paymentType != PaymentType.AUSTRIAN_POSTBAR) {
            throw new PaymentException("Invalid payment type for postbar recipients: " + paymentType.name());
        }
        PaymentRecipient paymentRecipient = null;
        if (!forceNewRecipient) {
            if (recipientId != null) {
                paymentRecipient = PaymentRecipient.findByIdAndTenants((int)recipientId, admissibleTenants);
            }
            if (paymentRecipient == null) {
                paymentRecipient = PaymentRecipient.findRecipientByAccountInfo(Collections.singletonList(PaymentType.AUSTRIAN_POSTBAR), (String)((SEPAPaymentData)this.payment).getUltimateRecipient(), null, null, admissibleTenants);
            }
        }
        if (!allowRecipientModification && paymentRecipient != null) {
            return null;
        }
        if (paymentRecipient == null) {
            paymentRecipient = new PaymentRecipient();
            paymentRecipient.setTenant(tenant);
            paymentRecipient.setPaymentType(PaymentType.AUSTRIAN_POSTBAR);
            paymentRecipient.setDisplayName(RecipientData.getUniqueDisplayName((String)((SEPAPaymentData)this.payment).getUltimateRecipient(), (PaymentType)paymentType, (Tenant)tenant));
        }
        paymentRecipient.setName(((SEPAPaymentData)this.payment).getUltimateRecipient());
        PostbarRecipientData postbarRecipient = new PostbarRecipientData();
        try {
            postbarRecipient.setPaymentRecipient(paymentRecipient);
        }
        catch (IOException e) {
            throw new PaymentException("Failed to load postbar recipient info!", e);
        }
        PostbarPurpose postbarPurpose = PostbarPurpose.getPostbarPurpose((String)((SEPAPaymentData)this.payment).getPurpose());
        postbarRecipient.setAddress1(postbarPurpose.getAddress1());
        postbarRecipient.setAddress2(postbarPurpose.getAddress2());
        postbarRecipient.setPlz(postbarPurpose.getPlz());
        postbarRecipient.setForward(!postbarPurpose.isNoForward());
        postbarRecipient.setInPerson(postbarPurpose.isInPerson());
        PostbarPurpose.PayOffMode payOffMode = postbarPurpose.getPayOffMode();
        postbarRecipient.setPayOffMode(payOffMode);
        if (PostbarPurpose.PayOffMode.PayOffSms.equals((Object)payOffMode)) {
            postbarRecipient.setSmsNumber(postbarPurpose.getSmsNumber());
        } else {
            postbarRecipient.setSmsNumber(null);
        }
        if (PostbarPurpose.PayOffMode.PayOffPostPlz.equals((Object)payOffMode)) {
            postbarRecipient.setPostPlz(postbarPurpose.getPostPLZ());
        } else {
            postbarRecipient.setPostPlz(null);
        }
        postbarRecipient.setPurpose(postbarPurpose.getPurpose());
        postbarRecipient.setReference(((SEPAPaymentData)this.payment).getEndToEndId());
        return postbarRecipient;
    }

    @Override
    public PaymentTransferType.PmtType getPaymentType(PaymentTransferType.PmtType defaultType) {
        return PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT;
    }

    public String getAddress1() {
        PostbarPurpose postbarPurpose = PostbarPurpose.getPostbarPurpose((String)((SEPAPaymentData)this.payment).getPurpose());
        return postbarPurpose.getAddress1();
    }

    public String getAddress2() {
        PostbarPurpose postbarPurpose = PostbarPurpose.getPostbarPurpose((String)((SEPAPaymentData)this.payment).getPurpose());
        return postbarPurpose.getAddress2();
    }

    public String getPlz() {
        PostbarPurpose postbarPurpose = PostbarPurpose.getPostbarPurpose((String)((SEPAPaymentData)this.payment).getPurpose());
        return postbarPurpose.getPlz();
    }
}

