/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.Accounts;
import controllers.BLSyncCache;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.CountriesLoader;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.PermissionsLoader;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.sepa.SepaDebitType;
import de.businesslogics.banking.api.sepa.SepaSchemeHandler;
import de.businesslogics.banking.api.sepa.SepaSequenceType;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentFilter;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.banking.payments.api.CurrenciesLoader;
import de.businesslogics.banking.sepa.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.sepa.api.SepaApiMessages;
import de.businesslogics.banking.sepa.api.SepaCallbackApi;
import de.businesslogics.banking.sepa.api.SepaOriginatorData;
import de.businesslogics.banking.transfer.api.SendOrderHandler;
import de.businesslogics.banking.transfer.api.SendUtil;
import de.businesslogics.format.AddressData;
import de.businesslogics.format.ClearingSystem;
import de.businesslogics.format.dta.DtazvFeeType;
import de.businesslogics.format.dta.DtazvInstructionCode;
import de.businesslogics.format.dta.DtazvPaymentType;
import de.businesslogics.format.sepa.ChequeDeliveryCode;
import de.businesslogics.format.sepa.ChequeType;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.format.sepa.SEPAInstructionPriority;
import de.businesslogics.format.sepa.SEPAPaymentCategory;
import de.businesslogics.format.sepa.SEPAPurposeCode;
import de.businesslogics.format.sepa.csv.ColumnHandler;
import de.businesslogics.format.sepa.csv.Format2;
import de.businesslogics.format.sepa.csv.XLSColumHandler;
import de.businesslogics.util.StringUtils;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.Query;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import models.AustrianForeignPaymentForm;
import models.DtazvPaymentForm;
import models.Mt101PaymentForm;
import models.PostbarPaymentForm;
import models.SepaPaymentForm;
import models.TaxOfficePaymentForm;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import play.i18n.Messages;
import play.libs.Json;
import play.libs.Scala;
import play.mvc.Call;
import play.mvc.Http;
import play.mvc.Security;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import views.Utils;

public final class PaymentUtils {
    public static final boolean SHOW_AUSTRIAN_PAYMENT_TYPES = true;

    private PaymentUtils() {
    }

    public static String getPaymentTypeDescription(BankSettings bank, String orderOrFileType, boolean appendOrderOrFileType, Messages messages) {
        String fileFormat;
        String orderType;
        if (BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
            orderType = "BTU";
            fileFormat = orderOrFileType;
        } else if (bank.isFrenchBank()) {
            orderType = "FUL";
            fileFormat = orderOrFileType;
        } else {
            orderType = orderOrFileType;
            fileFormat = null;
        }
        return PaymentUtils.getPaymentTypeDescription(bank, orderType, fileFormat, appendOrderOrFileType, messages);
    }

    public static String getPaymentTypeDescription(BankSettings bank, String orderType, String fileFormat, boolean appendOrderOrFileType, Messages messages) {
        String description = null;
        List orderTypes = DB.find(OrderType.class).where().and(Expr.or((Expression)Expr.eq((String)"orderType", null), (Expression)Expr.eq((String)"orderType", (Object)orderType)), Expr.or((Expression)Expr.eq((String)"fileFormat", null), (Expression)Expr.eq((String)"fileFormat", (Object)fileFormat))).findList();
        if (!orderTypes.isEmpty()) {
            description = orderTypes.stream().filter(o -> o.getDescription() != null && !o.getDescription().isEmpty()).map(OrderType::getDescription).findAny().orElse(null);
        } else {
            PaymentTransferType.PmtType pmtType = SendParameters.getPmtType((BankSettings)bank, (String)(fileFormat != null ? fileFormat : orderType));
            if (pmtType != null) {
                description = PaymentTypeUtil.getUniquePaymentName((Locale)messages.lang().locale(), (PaymentTransferType.PmtType)pmtType);
            }
        }
        if (description != null) {
            if (!appendOrderOrFileType) {
                return description;
            }
            StringBuilder resultBuilder = new StringBuilder(description).append(" (");
            if (fileFormat != null) {
                resultBuilder.append(fileFormat);
            } else {
                resultBuilder.append(orderType);
            }
            return resultBuilder.append(')').toString();
        }
        if (fileFormat != null) {
            return fileFormat;
        }
        return orderType;
    }

    @Deprecated
    public static String getPaymentTypeDescription(PaymentTransferType.PmtType pmtType, String orderTypeToAppend, Messages messages) {
        StringBuilder resultBuilder = new StringBuilder();
        resultBuilder.append(PaymentTypeUtil.getUniquePaymentName((Locale)messages.lang().locale(), (PaymentTransferType.PmtType)pmtType));
        if (orderTypeToAppend != null) {
            resultBuilder.append(" (");
            resultBuilder.append(orderTypeToAppend);
            resultBuilder.append(')');
        }
        return resultBuilder.toString();
    }

    public static String getOrderDescription(BankSettings bank, String orderType, String fileType, String orderNumber, Messages messages) {
        String description = PaymentUtils.getPaymentTypeDescription(bank, orderType, fileType, false, messages);
        if (fileType != null && fileType.equals(description)) {
            description = null;
        } else if (fileType == null && orderType != null && orderType.equals(description)) {
            description = null;
        }
        StringBuilder result = new StringBuilder();
        if (description != null) {
            result.append(description).append(" (");
        }
        if (fileType != null) {
            result.append(fileType);
        } else {
            result.append(orderType);
        }
        result.append(' ').append(orderNumber);
        if (description != null) {
            result.append(')');
        }
        return result.toString();
    }

    public static String getSignedTitle(Integer paymentId, Messages messages, PaymentTransferType.PmtType pmtType, String orderType) {
        SignedPayment payment = (SignedPayment)DB.find(SignedPayment.class).where().eq("id", (Object)paymentId).findOne();
        if (payment != null) {
            return new PaymentTypeUtil(messages.lang().toLocale()).getNameForSignedPaymentOverview(payment);
        }
        return messages.at("editpayment.title.readonly", new Object[]{PaymentUtils.getPaymentTypeDescription(pmtType, orderType, messages)});
    }

    public static String getTitlePayment(PaymentTransferType.PmtType pmtType, boolean isNew, String orderType, Messages messages) {
        String start;
        Locale loc = messages.lang().locale();
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String ending = "titleModifyPayment";
        if (isNew) {
            ending = "titleNewPayment";
        }
        if (pmtType == PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE) {
            return messages.at("payments.SEPA_FOREIGN_CHEQUE." + ending, new Object[0]);
        }
        if (pmtType == PaymentTransferType.PmtType.AUSTRIAN_FOREIGN) {
            return messages.at("payments.AUSTRIAN_FOREIGN." + ending, new Object[0]);
        }
        if (pmtType == PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE) {
            return messages.at("payments.AUSTRIAN_FOREIGN_SEPA_CHEQUE." + ending, new Object[0]);
        }
        if (pmtType == PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT) {
            return messages.at("payments.SEPA_CORE_DIRECT_DEBIT." + ending, new Object[0]);
        }
        if (pmtType == PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT) {
            return messages.at("payments.SEPA_B2B_DIRECT_DEBIT." + ending, new Object[0]);
        }
        if (pmtType == PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER) {
            start = "SEPAInstantCreditPaymentPage.";
        } else if (pmtType == PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER || pmtType == PaymentTransferType.PmtType.SEPA_URGENT_CONFIDENTAL_TRANSFER) {
            start = "SEPAUrgentCreditPaymentPage.";
        } else if (pmtType == PaymentTransferType.PmtType.SEPA_TRANSFER || pmtType == PaymentTransferType.PmtType.SEPA_NON_SEPA_COUNTRY_TRANSFER || pmtType == PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER || pmtType == PaymentTransferType.PmtType.SEPA_CONFIDENTAL_TRANSFER) {
            start = "SEPACreditPaymentPage.";
        } else if (pmtType == PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER) {
            start = "SEPAForeignPaymentPage.";
        } else if (pmtType == PaymentTransferType.PmtType.DTAZV_TRANSFER) {
            start = "AZVPaymentPage1.";
        } else if (pmtType == PaymentTransferType.PmtType.MT101_TRANSFER) {
            start = "MT101PaymentPage1.";
        } else if (pmtType == PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT) {
            start = "PostbarPaymentPage.";
        } else if (pmtType == PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT) {
            start = "TaxOfficePaymentPage.";
        } else {
            if (isNew) {
                return messages.at("newpayment.title", new Object[]{PaymentUtils.getPaymentTypeDescription(pmtType, orderType, messages)});
            }
            return messages.at("editpayment.title.readonly", new Object[]{PaymentUtils.getPaymentTypeDescription(pmtType, orderType, messages)});
        }
        return de.businesslogics.banking.payments.core.Messages.getString((Locale)loc, (String)(start + ending), (Object[])new Object[0]);
    }

    public static String getTitleRecipient(PaymentType paymentType, boolean isNew, Messages messages) {
        Locale loc = messages.lang().locale();
        if (loc == null) {
            loc = Locale.getDefault();
        }
        String ending = "titleModifyRecipient";
        if (isNew) {
            ending = "titleNewRecipient";
        }
        if (paymentType == PaymentType.CHEQUE) {
            return messages.at("recipients.type.cheque." + ending, new Object[0]);
        }
        String start = PaymentUtils.getTitleRecipientPrefix(paymentType);
        if (start.isEmpty()) {
            return "";
        }
        return de.businesslogics.banking.payments.core.Messages.getString((Locale)loc, (String)(start + ending), (Object[])new Object[0]);
    }

    private static String getTitleRecipientPrefix(PaymentType paymentType) {
        if (paymentType == PaymentType.DTAZV) {
            return "DTAZVRecipientPage.";
        }
        if (paymentType == PaymentType.SEPA) {
            return "SEPARecipientPage.";
        }
        if (paymentType == PaymentType.MANDATE) {
            return "SEPAMandatePage.";
        }
        if (paymentType == PaymentType.MT101) {
            return "MT101RecipientPage.";
        }
        if (paymentType == PaymentType.AUSTRIAN_TAX_OFFICE) {
            return "TaxOfficeRecipientPage.";
        }
        if (paymentType == PaymentType.AUSTRIAN_POSTBAR) {
            return "PostbarRecipientPage.";
        }
        if (paymentType == PaymentType.SEPA_FOREIGN) {
            return "SEPAForeignRecipientPage.";
        }
        return "";
    }

    public static String getLeadingTextRecipient(PaymentType paymentType, boolean isNew, Messages messages) {
        String prefix = isNew ? "recipients.new.lead." : "recipients.edit.lead.";
        return messages.at(prefix + paymentType.name(), new Object[]{messages.at("recipients.lead.add." + paymentType.name(), new Object[0])});
    }

    public static String getOrderDescription(BankSettings bank, String orderOrFileType, String orderNumber, Messages messages) {
        if (BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
            return PaymentUtils.getOrderDescription(bank, "BTU", orderOrFileType, orderNumber, messages);
        }
        if (bank.isFrenchBank()) {
            return PaymentUtils.getOrderDescription(bank, "FUL", orderOrFileType, orderNumber, messages);
        }
        return PaymentUtils.getOrderDescription(bank, orderOrFileType, null, orderNumber, messages);
    }

    public static String getOrderDescription(BankSettings bank, PaymentTransferType.PmtType pmtType, String orderNumber, String orderType, Messages messages) {
        String description = null;
        if (pmtType != null) {
            description = PaymentUtils.getPaymentTypeDescription(pmtType, null, messages);
            if (pmtType.toString().equals(description)) {
                description = null;
            }
        }
        StringBuilder result = new StringBuilder();
        if (description != null) {
            result.append(description).append(" (");
        }
        String string = orderType != null ? orderType : (orderType = pmtType != null ? SendParameters.getTransferTypeByBank((BankSettings)bank, (PaymentTransferType.PmtType)pmtType) : null);
        if (orderType != null) {
            result.append(orderType).append(' ');
        }
        result.append(orderNumber);
        if (description != null) {
            result.append(')');
        }
        return result.toString();
    }

    public static Seq<Tuple2<String, String>> getPaymentTypesForSending(Messages messages, String username) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        ArrayList<PaymentTransferType.PmtType> excludedPmtTypes = new ArrayList<PaymentTransferType.PmtType>();
        excludedPmtTypes.add(PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT);
        excludedPmtTypes.add(PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT);
        excludedPmtTypes.add(PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT);
        excludedPmtTypes.add(PaymentTransferType.PmtType.SEPA_CONFIDENTAL_TRANSFER);
        excludedPmtTypes.add(PaymentTransferType.PmtType.SEPA_URGENT_CONFIDENTAL_TRANSFER);
        excludedPmtTypes.add(PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER);
        excludedPmtTypes.add(PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE);
        excludedPmtTypes.add(PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE);
        Branding.getBranding().excludedPaymentTypes().ifPresent(excludedPmtTypes::addAll);
        for (Tuple2<PaymentTransferType.PmtType, String> tuple : PaymentUtils.getPaymentTypes(messages, username, false)) {
            if (excludedPmtTypes.contains(tuple._1)) continue;
            result.add(new Tuple2((Object)((PaymentTransferType.PmtType)tuple._1).name(), (Object)((String)tuple._2)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getPaymentTypesForImport(Messages messages, String username, boolean csvImport) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        ArrayList<PaymentTransferType.PmtType> excludedPmtTypes = new ArrayList<PaymentTransferType.PmtType>();
        excludedPmtTypes.add(PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT);
        excludedPmtTypes.add(PaymentTransferType.PmtType.SEPA_CONFIDENTAL_TRANSFER);
        excludedPmtTypes.add(PaymentTransferType.PmtType.SEPA_URGENT_CONFIDENTAL_TRANSFER);
        excludedPmtTypes.add(PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER);
        if (csvImport) {
            excludedPmtTypes.add(PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE);
            excludedPmtTypes.add(PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE);
        }
        Branding.getBranding().excludedPaymentTypes().ifPresent(excludedPmtTypes::addAll);
        for (Tuple2<PaymentTransferType.PmtType, String> tuple : PaymentUtils.getPaymentTypes(messages, username, true)) {
            if (excludedPmtTypes.contains(tuple._1)) continue;
            result.add(new Tuple2((Object)((PaymentTransferType.PmtType)tuple._1).name(), (Object)((String)tuple._2)));
        }
        return Scala.toSeq(result);
    }

    public static boolean canRecordPmtType(Messages messages, String username, PaymentTransferType.PmtType pmtType) {
        for (Tuple2<PaymentTransferType.PmtType, String> tuple : BLSyncCache.getCachedPaymentTypesForNewPayment(messages, username)) {
            if (!pmtType.equals(tuple._1)) continue;
            return true;
        }
        return false;
    }

    public static List<Tuple2<PaymentTransferType.PmtType, String>> getPaymentTypesForNewPayment(Messages messages, String username) {
        ArrayList<Tuple2<PaymentTransferType.PmtType, String>> result = new ArrayList<Tuple2<PaymentTransferType.PmtType, String>>();
        ArrayList<PaymentTransferType.PmtType> excludedPmtTypes = new ArrayList<PaymentTransferType.PmtType>();
        excludedPmtTypes.add(PaymentTransferType.PmtType.SEPA_CONFIDENTAL_TRANSFER);
        excludedPmtTypes.add(PaymentTransferType.PmtType.SEPA_URGENT_CONFIDENTAL_TRANSFER);
        excludedPmtTypes.add(PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER);
        excludedPmtTypes.add(PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT);
        Branding.getBranding().excludedPaymentTypes().ifPresent(excludedPmtTypes::addAll);
        for (Tuple2<PaymentTransferType.PmtType, String> tuple : PaymentUtils.getPaymentTypes(messages, username, false)) {
            if (excludedPmtTypes.contains(tuple._1)) continue;
            result.add(tuple);
        }
        return result;
    }

    public static Seq<Tuple2<String, String>> getStatesForFilter(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)""));
        for (PaymentFilter.State s : PaymentFilter.State.values()) {
            result.add(Scala.Tuple((Object)s.name(), (Object)SendUtil.getStateFilterText((PaymentFilter.State)s, (Locale)locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getPaymentTypesForFilter(Messages messages, String username) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)""));
        ArrayList excludedPmtTypes = new ArrayList();
        Branding.getBranding().excludedPaymentTypes().ifPresent(excludedPmtTypes::addAll);
        for (Tuple2<PaymentTransferType.PmtType, String> tuple : PaymentUtils.getPaymentTypes(messages, username, false)) {
            if (excludedPmtTypes.contains(tuple._1)) continue;
            Tuple2 t = Scala.Tuple((Object)((PaymentTransferType.PmtType)tuple._1).toString(), (Object)((String)tuple._2));
            result.add(t);
        }
        return Scala.toSeq(result);
    }

    private static List<Tuple2<PaymentTransferType.PmtType, String>> getPaymentTypes(Messages messages, String username, boolean appendOrderType) {
        return PaymentUtils.getPaymentTypes(messages, username, appendOrderType, null);
    }

    private static List<Tuple2<PaymentTransferType.PmtType, String>> getPaymentTypes(Messages messages, String username, boolean appendOrderType, BankSettings bank) {
        Object bankUser;
        User user = User.getUser((String)username);
        HashMap allowedOrderTypes = new HashMap();
        boolean includeCor1 = false;
        List<Object> bankUsers = null;
        if (bank != null && (bankUser = BankUser.findBankUser((BankSettings)bank, (User)user)) != null) {
            bankUsers = Collections.singletonList(bankUser);
        }
        if (bankUsers == null) {
            bankUsers = BankUser.findBanksForUser((User)user);
        }
        for (BankUser bankUser2 : bankUsers) {
            boolean isH005OrNewer = BankUtils.isProtocolH005OrNewer((String)bankUser2.getBank().getProtocolVersion());
            if (BankUserHtdInfo.findForBankUser((BankUser)bankUser2) != null && new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user, bankUser2.getBank().getTenant()).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.CHECK_PERMISSION_FOR_PAYMENT_RECORDING)) {
                List userPermissions = UserPermission.findSendPermissionsForBankUser((BankUser)bankUser2).findList();
                Iterator iterator = userPermissions.iterator();
                while (iterator.hasNext()) {
                    String orderOrFileType;
                    UserPermission userPermission = (UserPermission)iterator.next();
                    if (userPermission.getOrderType() == null || (orderOrFileType = isH005OrNewer ? userPermission.getOrderType().getFileFormat() : userPermission.getOrderType().getOrderType()) == null) continue;
                    if (!allowedOrderTypes.containsKey(bankUser2)) {
                        allowedOrderTypes.put(bankUser2, new HashSet());
                    }
                    ((Set)allowedOrderTypes.get(bankUser2)).add(orderOrFileType);
                }
            } else if (isH005OrNewer) {
                for (Object orderType : OrderType.findSendOrderTypesForBank((BankSettings)bankUser2.getBank())) {
                    if (orderType.getFileFormat() == null) continue;
                    if (!allowedOrderTypes.containsKey(bankUser2)) {
                        allowedOrderTypes.put(bankUser2, new HashSet());
                    }
                    ((Set)allowedOrderTypes.get(bankUser2)).add(orderType.getFileFormat());
                }
            } else {
                for (Object orderType : OrderType.findSendOrderTypesForBank((BankSettings)bankUser2.getBank())) {
                    if (orderType.getOrderType() == null) continue;
                    if (!allowedOrderTypes.containsKey(bankUser2)) {
                        allowedOrderTypes.put(bankUser2, new HashSet());
                    }
                    ((Set)allowedOrderTypes.get(bankUser2)).add(orderType.getOrderType());
                }
            }
            if (includeCor1 || !PaymentUtils.isCOR1SupportedByBank(bankUser2.getBank())) continue;
            includeCor1 = true;
        }
        ArrayList<Tuple2<PaymentTransferType.PmtType, String>> result = new ArrayList<Tuple2<PaymentTransferType.PmtType, String>>();
        StringBuilder stringBuilder = new StringBuilder();
        for (PaymentTransferType.PmtType pmtType : PaymentUtils.getSupportedPaymentTypes(includeCor1, !Util.hideSalariesCompletely((User)user), false)) {
            Object orderType;
            orderType = null;
            for (Map.Entry entry : allowedOrderTypes.entrySet()) {
                String paymentTransferType = SendParameters.getTransferTypeByBank((BankSettings)((BankUser)entry.getKey()).getBank(), (PaymentTransferType.PmtType)pmtType);
                if (!((Set)entry.getValue()).contains(paymentTransferType)) continue;
                orderType = paymentTransferType;
                break;
            }
            if (orderType == null) continue;
            stringBuilder.setLength(0);
            String description = appendOrderType ? PaymentUtils.getPaymentTypeDescription(pmtType, (String)orderType, messages) : PaymentUtils.getPaymentTypeDescription(pmtType, null, messages);
            stringBuilder.append(description);
            if (stringBuilder.isEmpty()) {
                stringBuilder.append((String)orderType);
            }
            result.add((Tuple2<PaymentTransferType.PmtType, String>)Scala.Tuple((Object)pmtType, (Object)stringBuilder.toString()));
        }
        return result;
    }

    public static List<PaymentTransferType.PmtType> getSupportedPaymentTypes(boolean includeCOR1, boolean includeSalaryPayments, boolean includeSepaCallbackTypes) {
        ArrayList<PaymentTransferType.PmtType> result = new ArrayList<PaymentTransferType.PmtType>();
        Collections.addAll(result, SepaPaymentForm.getPmtTypes(includeCOR1, includeSalaryPayments));
        Collections.addAll(result, DtazvPaymentForm.PMT_TYPES);
        Collections.addAll(result, Mt101PaymentForm.getPmtTypes());
        if (includeSepaCallbackTypes) {
            result.add(PaymentTransferType.PmtType.C55_CALLBACK);
            result.add(PaymentTransferType.PmtType.C55_SDD_CALLBACK);
        }
        Collections.addAll(result, AustrianForeignPaymentForm.getPmtTypes());
        Collections.addAll(result, TaxOfficePaymentForm.getPmtTypes());
        Collections.addAll(result, PostbarPaymentForm.getPmtTypes());
        return result;
    }

    public static List<PaymentTransferType.PmtType> getSupportedVopPaymentTypes(boolean includeSalaryPayments) {
        return PaymentUtils.getSupportedPaymentTypes(false, includeSalaryPayments, false).stream().filter(PaymentTransferType.PmtType::supportsVop).collect(Collectors.toList());
    }

    public static boolean isCOR1SupportedByBank(BankSettings bank) {
        return GeneralSEPAWriter.isCOR1Supported((GeneralSEPAWriter.Version)SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT));
    }

    public static String getPmtTypeIcon(PaymentTransferType.PmtType pmtType) {
        if (DtazvPaymentForm.isAzvPmtType(pmtType)) {
            return PaymentUtils.getPaymentTypeIcon(PaymentType.DTAZV);
        }
        if (SepaApi.isForeignPayment((PaymentTransferType.PmtType)pmtType)) {
            return PaymentUtils.getPaymentTypeIcon(PaymentType.SEPA_FOREIGN);
        }
        if (Mt101PaymentForm.isMt101PmtType(pmtType)) {
            return PaymentUtils.getPaymentTypeIcon(PaymentType.MT101);
        }
        if (PostbarPaymentForm.isPostbarPmtType(pmtType)) {
            return PaymentUtils.getPaymentTypeIcon(PaymentType.AUSTRIAN_POSTBAR);
        }
        if (TaxOfficePaymentForm.isTaxofficePmtType(pmtType)) {
            return PaymentUtils.getPaymentTypeIcon(PaymentType.AUSTRIAN_TAX_OFFICE);
        }
        if (SepaPaymentForm.isSepaPmtType(pmtType)) {
            return PaymentUtils.getPaymentTypeIcon(PaymentType.SEPA);
        }
        return "";
    }

    public static String getPaymentTypeIcon(String paymentType) {
        return PaymentUtils.getPaymentTypeIcon(PaymentType.valueOf((String)paymentType));
    }

    private static String getPaymentTypeIcon(PaymentType paymentType) {
        if (paymentType == PaymentType.DTAZV || paymentType == PaymentType.SEPA_FOREIGN || paymentType == PaymentType.CHEQUE) {
            return "fa fa-globe";
        }
        if (paymentType == PaymentType.SEPA || paymentType == PaymentType.MANDATE) {
            return "fa fa-eur";
        }
        if (paymentType == PaymentType.MT101) {
            return "fa fa-globe";
        }
        if (paymentType == PaymentType.AUSTRIAN_TAX_OFFICE || paymentType == PaymentType.AUSTRIAN_POSTBAR) {
            return "fa austrian";
        }
        return "";
    }

    public static Seq<Tuple2<String, String>> getOriginatorTypes(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)PaymentType.SEPA.name(), (Object)PaymentUtils.getOriginatorType(messages, PaymentType.SEPA)));
        result.add(Scala.Tuple((Object)PaymentType.DTAZV.name(), (Object)PaymentUtils.getOriginatorType(messages, PaymentType.DTAZV)));
        result.add(Scala.Tuple((Object)PaymentType.MT101.name(), (Object)PaymentUtils.getOriginatorType(messages, PaymentType.MT101)));
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getDeliveryMethods(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)""));
        for (ChequeDeliveryCode method : ChequeDeliveryCode.values()) {
            result.add(Scala.Tuple((Object)method.name(), (Object)method.getDescription(locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getChequeTypes(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)""));
        for (ChequeType method : ChequeType.values()) {
            result.add(Scala.Tuple((Object)method.name(), (Object)method.getDescription(locale)));
        }
        return Scala.toSeq(result);
    }

    public static String getOriginatorType(Messages messages, PaymentType paymentType) {
        if (paymentType == PaymentType.DTAZV) {
            return messages.at("originators.type.dtazv", new Object[0]);
        }
        if (paymentType == PaymentType.SEPA) {
            return messages.at("originators.type.sepa", new Object[0]);
        }
        if (paymentType == PaymentType.MT101) {
            return messages.at("originators.type.mt101", new Object[0]);
        }
        return "";
    }

    public static Seq<Tuple2<String, String>> getRecipientTypes(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        List excludedPmtTypes = Branding.getBranding().excludedPaymentTypes().orElse(new ArrayList());
        result.add(Scala.Tuple((Object)PaymentType.SEPA.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.SEPA)));
        if (!excludedPmtTypes.contains(PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT) || !excludedPmtTypes.contains(PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT)) {
            result.add(Scala.Tuple((Object)PaymentType.MANDATE.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.MANDATE)));
        }
        if (!excludedPmtTypes.contains(PaymentTransferType.PmtType.DTAZV_TRANSFER)) {
            result.add(Scala.Tuple((Object)PaymentType.DTAZV.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.DTAZV)));
        }
        if (!excludedPmtTypes.contains(PaymentTransferType.PmtType.MT101_TRANSFER)) {
            result.add(Scala.Tuple((Object)PaymentType.MT101.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.MT101)));
        }
        if (!excludedPmtTypes.contains(PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER) || !excludedPmtTypes.contains(PaymentTransferType.PmtType.AUSTRIAN_FOREIGN)) {
            result.add(Scala.Tuple((Object)PaymentType.SEPA_FOREIGN.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.SEPA_FOREIGN)));
        }
        if (!excludedPmtTypes.contains(PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE) || !excludedPmtTypes.contains(PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE)) {
            result.add(Scala.Tuple((Object)PaymentType.CHEQUE.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.CHEQUE)));
        }
        if (!excludedPmtTypes.contains(PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT)) {
            result.add(Scala.Tuple((Object)PaymentType.AUSTRIAN_TAX_OFFICE.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.AUSTRIAN_TAX_OFFICE)));
        }
        if (!excludedPmtTypes.contains(PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT)) {
            result.add(Scala.Tuple((Object)PaymentType.AUSTRIAN_POSTBAR.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.AUSTRIAN_POSTBAR)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getRecipientTypesForImport(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)PaymentType.SEPA.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.SEPA)));
        result.add(Scala.Tuple((Object)PaymentType.MANDATE.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.MANDATE)));
        result.add(Scala.Tuple((Object)PaymentType.DTAZV.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.DTAZV)));
        result.add(Scala.Tuple((Object)PaymentType.MT101.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.MT101)));
        result.add(Scala.Tuple((Object)PaymentType.SEPA_FOREIGN.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.SEPA_FOREIGN)));
        result.add(Scala.Tuple((Object)PaymentType.CHEQUE.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.CHEQUE)));
        result.add(Scala.Tuple((Object)PaymentType.AUSTRIAN_TAX_OFFICE.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.AUSTRIAN_TAX_OFFICE)));
        result.add(Scala.Tuple((Object)PaymentType.AUSTRIAN_POSTBAR.name(), (Object)PaymentUtils.getRecipientType(messages, PaymentType.AUSTRIAN_POSTBAR)));
        return Scala.toSeq(result);
    }

    public static String getRecipientType(Messages messages, PaymentType paymentType) {
        if (paymentType == PaymentType.DTAZV) {
            return messages.at("recipients.type.dtazv", new Object[0]);
        }
        if (paymentType == PaymentType.SEPA) {
            return Branding.getBranding().getSepaRecipientLabel(messages);
        }
        if (paymentType == PaymentType.MANDATE) {
            return Branding.getBranding().getSepaMandateLabel(messages);
        }
        if (paymentType == PaymentType.MT101) {
            return messages.at("recipients.type.mt101", new Object[0]);
        }
        if (paymentType == PaymentType.AUSTRIAN_TAX_OFFICE) {
            return messages.at("recipients.type.austrianTaxOffice", new Object[0]);
        }
        if (paymentType == PaymentType.AUSTRIAN_POSTBAR) {
            return messages.at("recipients.type.austrianPostbar", new Object[0]);
        }
        if (paymentType == PaymentType.SEPA_FOREIGN) {
            return messages.at("recipients.type.sepaforeign", new Object[0]);
        }
        if (paymentType == PaymentType.CHEQUE) {
            return messages.at("recipients.type.cheque", new Object[0]);
        }
        return "";
    }

    public static String getPaymentTypeName(Messages messages, PaymentType paymentType) {
        if (paymentType == PaymentType.MANDATE) {
            return SepaApiMessages.getString((Locale)messages.lang().locale(), (String)"printer.sepaMandate", (Object[])new Object[0]);
        }
        if (paymentType != null) {
            return PaymentTypeUtil.getUniquePaymentTypeName((Locale)messages.lang().toLocale(), (PaymentType)paymentType);
        }
        return "";
    }

    public static Seq<Tuple2<String, String>> getAccountsSeq(User user, PaymentTransferType.PmtType paymentType, PermissionsLoader.AccountType accountType, boolean includeEmptyLine, boolean includeDeactivatedBanks) {
        boolean usePrefAccountNameAndIban = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.SHOW_ACCOUNT_NAME_WITH_IBAN);
        return PaymentUtils.getAccountsSeq(user.getName(), paymentType, accountType, includeEmptyLine, usePrefAccountNameAndIban, includeDeactivatedBanks);
    }

    public static Seq<Tuple2<String, String>> getAccountsSeq(String userName, PaymentTransferType.PmtType paymentType, PermissionsLoader.AccountType accountType, boolean includeEmptyLine, boolean includeDeactivatedBanks) {
        return PaymentUtils.getAccountsSeq(userName, paymentType, accountType, includeEmptyLine, false, includeDeactivatedBanks);
    }

    public static Seq<Tuple2<String, String>> getAccountsSeq(String userName, PaymentTransferType.PmtType paymentType, PermissionsLoader.AccountType accountType, boolean includeEmptyLine, boolean appendIBAN, boolean includeDeactivatedBanks) {
        ArrayList<Tuple2> resultList = new ArrayList<Tuple2>();
        if (includeEmptyLine) {
            resultList.add(Scala.Tuple((Object)"", (Object)""));
        }
        boolean isUrgent = SepaApi.isUrgent((PaymentTransferType.PmtType)paymentType);
        for (Account account : PaymentUtils.getAccounts(userName, paymentType, accountType, includeDeactivatedBanks)) {
            String accountDisplayName = PaymentUtils.getAccountDisplayName(accountType, isUrgent, account, appendIBAN);
            if (accountDisplayName == null) continue;
            resultList.add(Scala.Tuple((Object)String.valueOf(account.getId()), (Object)Utils.addZWNJ(accountDisplayName)));
        }
        resultList.sort((o1, o2) -> {
            if (o1 == null || o1._2 == null) {
                if (o2 == null || o2._2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null || o2._2 == null) {
                return -1;
            }
            return ((String)o1._2).compareTo((String)o2._2);
        });
        return Scala.toSeq(resultList);
    }

    public static Seq<Tuple3<String, String, String>> getAccountsSeq(String userName, PaymentTransferType.PmtType paymentType, PermissionsLoader.AccountType accountType, boolean includeEmptyLine, boolean includeDeactivatedBanks, Messages messages) {
        User user = User.getUser((String)userName);
        boolean usePrefAccountNameAndIban = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.SHOW_ACCOUNT_NAME_WITH_IBAN);
        return PaymentUtils.getAccountsSeq(userName, paymentType, accountType, includeEmptyLine, usePrefAccountNameAndIban, includeDeactivatedBanks, messages);
    }

    public static Seq<Tuple3<String, String, String>> getAccountsSeq(String userName, PaymentTransferType.PmtType paymentType, PermissionsLoader.AccountType accountType, boolean includeEmptyLine, boolean appendIBAN, boolean includeDeactivatedBanks, Messages messages) {
        ArrayList<Tuple3> resultList = new ArrayList<Tuple3>();
        if (includeEmptyLine) {
            Tuple3 empty = new Tuple3((Object)"", (Object)"", (Object)"");
            resultList.add(empty);
        }
        boolean isUrgent = SepaApi.isUrgent((PaymentTransferType.PmtType)paymentType);
        for (Account account : PaymentUtils.getAccounts(userName, paymentType, accountType, includeDeactivatedBanks)) {
            String accountDisplayName = PaymentUtils.getAccountDisplayName(accountType, isUrgent, account, appendIBAN);
            if (accountDisplayName == null) continue;
            Tuple3 t = new Tuple3((Object)String.valueOf(account.getId()), (Object)Utils.addZWNJ(accountDisplayName), (Object)PaymentUtils.getAccountDisplayNameForTooltip(account, messages));
            resultList.add(t);
        }
        resultList.sort((o1, o2) -> {
            if (o1 == null || o1._2() == null) {
                if (o2 == null || o2._2() == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null || o2._2() == null) {
                return -1;
            }
            return ((String)o1._2()).compareTo((String)o2._2());
        });
        return Scala.toSeq(resultList);
    }

    public static Seq<Tuple3<String, String, String>> getSingleAccountSeq(String userName, String accountId, PaymentTransferType.PmtType paymentType, PermissionsLoader.AccountType accountType, Messages messages) {
        ArrayList<Tuple3> resultList = new ArrayList<Tuple3>();
        User user = User.getUser((String)userName);
        boolean appendIBAN = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.SHOW_ACCOUNT_NAME_WITH_IBAN);
        boolean isUrgent = SepaApi.isUrgent((PaymentTransferType.PmtType)paymentType);
        Account account = Account.findById((int)Integer.parseInt(accountId));
        if (account != null) {
            String accountDisplayName = PaymentUtils.getAccountDisplayName(accountType, isUrgent, account, appendIBAN);
            if (accountDisplayName != null) {
                Tuple3 t = new Tuple3((Object)String.valueOf(account.getId()), (Object)Utils.addZWNJ(accountDisplayName), (Object)PaymentUtils.getAccountDisplayNameForTooltip(account, messages));
                resultList.add(t);
            }
        } else {
            Tuple3 empty = new Tuple3((Object)"", (Object)"", (Object)"");
            resultList.add(empty);
        }
        return Scala.toSeq(resultList);
    }

    private static String getAccountDisplayName(PermissionsLoader.AccountType accountType, boolean isUrgent, Account account, boolean appendIBAN) {
        Object accountDisplayName;
        if (accountType == PermissionsLoader.AccountType.IBAN) {
            boolean urgentAllowsIbanOnly = new DatabasePreferenceStore(Preference.ApplicationId.SEPA, null).getBoolean((DatabasePreferenceConstant)PreferenceConstants.URGENT_PAYMENT_ALLOWS_IBAN_ONLY);
            if (isUrgent && !urgentAllowsIbanOnly && (account.getBic() == null || account.getBic().isEmpty())) {
                return null;
            }
            accountDisplayName = Account.getInternationalDisplayName((Account)account, (boolean)false, (boolean)false, (boolean)false);
        } else {
            accountDisplayName = accountType == PermissionsLoader.AccountType.GERMAN || accountType == PermissionsLoader.AccountType.GERMAN_EUR ? Account.getGermanDisplayName((Account)account, (boolean)false, (boolean)false) : Account.getDefaultDisplayName((Account)account);
        }
        if (appendIBAN) {
            StringBuilder sb = new StringBuilder(" (");
            sb.append(account.getBank().getDisplayName());
            if (account.getIban() != null) {
                sb.append(", ").append(account.getIban());
            }
            sb.append(")");
            accountDisplayName = (String)accountDisplayName + sb.toString();
        } else {
            accountDisplayName = (String)accountDisplayName + Branding.getBranding().getAccountSuffix(account);
        }
        return accountDisplayName;
    }

    public static String getAccountDisplayNameForTooltip(Account account, Messages messages) {
        StringBuilder sb = new StringBuilder();
        if (!Accounts.getAccountNumber(account).isEmpty()) {
            sb.append(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.accountNumberIban", (Object[])new Object[0])).append(": ").append(Accounts.getAccountNumber(account));
        }
        if (!Accounts.getBankCode(account).isEmpty()) {
            sb.append(", ").append(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.bankCodeBic", (Object[])new Object[0])).append(": ").append(Accounts.getBankCode(account));
        }
        if (account.getCurrency() != null && !account.getCurrency().isEmpty()) {
            sb.append(", ").append(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.currency", (Object[])new Object[0])).append(": ").append(account.getCurrency());
        }
        return sb.toString();
    }

    public static Seq<Tuple2<String, String>> getUsers(String username) {
        ArrayList<Tuple2> resultList = new ArrayList<Tuple2>();
        resultList.add(Scala.Tuple((Object)"", (Object)""));
        User user = User.getUser((String)username);
        if (user == null) {
            return Scala.toSeq(resultList);
        }
        for (User u : User.getAllForTenants((Collection)user.getTenants(), (boolean)true)) {
            resultList.add(Scala.Tuple((Object)String.valueOf(u.getId()), (Object)Utils.addZWNJ(u.getName())));
        }
        return Scala.toSeq(resultList);
    }

    public static List<Account> getAccounts(String userName, PaymentTransferType.PmtType pmtType, PermissionsLoader.AccountType accountType, boolean includeDeactivatedBanks) {
        List bankUsers;
        User user = User.getUser((String)userName);
        List list = bankUsers = includeDeactivatedBanks ? BankUser.findBanksForUser((User)user) : BankUser.findActiveBanksForUser((User)user);
        if (pmtType == null) {
            PermissionsLoader loader = new PermissionsLoader(user);
            return bankUsers.stream().map(u -> loader.loadAccounts(null, u, accountType)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        HashMap<BankUser, String> transferTypeForBanks = new HashMap<BankUser, String>();
        for (BankUser bankUser : bankUsers) {
            boolean checkPermission = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user, bankUser.getBank().getTenant()).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.CHECK_PERMISSION_FOR_PAYMENT_RECORDING);
            if (!checkPermission) {
                transferTypeForBanks.put(bankUser, null);
                continue;
            }
            String transferType = SendParameters.getTransferTypeByBank((BankSettings)bankUser.getBank(), (PaymentTransferType.PmtType)pmtType);
            if (transferType == null) continue;
            transferTypeForBanks.put(bankUser, transferType);
        }
        ArrayList<Account> accounts2 = new ArrayList<Account>();
        Set entries = transferTypeForBanks.entrySet();
        PermissionsLoader loader = new PermissionsLoader(user);
        for (Map.Entry entry : entries) {
            BankUser bankUser = (BankUser)entry.getKey();
            String transferType = (String)entry.getValue();
            String[] orderTypes = transferType == null ? null : new String[]{transferType};
            accounts2.addAll(loader.loadAccounts(orderTypes, bankUser, accountType));
        }
        return accounts2;
    }

    public static boolean canUserCreatePayments(String userName, PaymentTransferType.PmtType pmtType) {
        return !PaymentUtils.getAccounts(userName, pmtType, null, false).isEmpty();
    }

    public static String getAccountStatement(Messages messages, AwzelEntry entry) {
        String statementNumber = "";
        String statementDateString = "";
        if (entry == null || entry.getCmBooking() == null) {
            return "";
        }
        if (entry.getCmBooking() == null) {
            return "";
        }
        if (entry.getCmBooking().getStatement() != null && entry.getCmBooking().getStatement().getStatementNumberToDisplay() != null) {
            statementNumber = entry.getCmBooking().getStatement().getStatementNumberToDisplay().toString();
        }
        if (entry.getCmBooking() != null && entry.getCmBooking().getBookingDate() != null) {
            java.sql.Date statementDate = entry.getCmBooking().getBookingDate();
            statementDateString = DateFormat.getDateInstance(3, messages.lang().locale()).format(new Date(statementDate.getTime()));
        }
        if (statementDateString.isEmpty()) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.awv.origin.statementNumber", (Object[])new Object[]{statementNumber});
        }
        if (statementNumber.isEmpty()) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"AccountOverviewLabelProvider.statementFromDate", (Object[])new Object[]{statementDateString});
        }
        return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.statementNumberAndDate", (Object[])new Object[]{statementNumber, statementDateString});
    }

    public static String getOriginatorAccountFromPaymentData(PaymentTransferType.PmtType pmtType, byte[] paymentData) {
        try {
            PaymentHandler<?> payment = PaymentHandler.getHandler(pmtType, paymentData);
            return payment.getOriginatorAccount();
        }
        catch (PaymentException e) {
            BLLoggerPlay.error("Failed to load payment data!");
            return "";
        }
    }

    public static Seq<Tuple2<String, String>> getSepaCategories(User user, Locale locale, boolean urgent) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)""));
        boolean withSalaries = Util.displayOpenSalaries((User)user);
        String[] categories = urgent ? SEPAPaymentCategory.getUrgentPaymentCategories((boolean)withSalaries) : SEPAPaymentCategory.getPaymentCategories((boolean)withSalaries);
        for (String category : categories) {
            result.add(Scala.Tuple((Object)category, (Object)SEPAPaymentCategory.getDescription((String)category, (Locale)locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getSepaPurposeCodes(User user, Locale locale, boolean urgent) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)""));
        boolean withSalaries = Util.displayOpenSalaries((User)user);
        String[] purposeCodes = urgent ? SEPAPurposeCode.getUrgentPaymentPurposeCodes((boolean)withSalaries) : SEPAPurposeCode.getPurposeCodes((boolean)withSalaries);
        for (String purposeCode : purposeCodes) {
            result.add(Scala.Tuple((Object)purposeCode, (Object)SEPAPurposeCode.getDescription((String)purposeCode, (Locale)locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getSepainstructionPriorities(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)""));
        for (SEPAInstructionPriority instructionPriority : SEPAInstructionPriority.values()) {
            result.add(Scala.Tuple((Object)instructionPriority.name(), (Object)instructionPriority.getDescription(locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getSepaDebitTypes(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (SepaDebitType debitType : SepaDebitType.values()) {
            if (debitType.equals((Object)SepaDebitType.COR1)) continue;
            result.add(Scala.Tuple((Object)debitType.name(), (Object)debitType.getDescription(locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getSepaSequenceTypes(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (SepaSequenceType sequenceType : SepaSequenceType.values()) {
            result.add(Scala.Tuple((Object)sequenceType.name(), (Object)sequenceType.getDescription(locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getRecipientSepaSequenceTypes(Messages messages, boolean includeEmptyLine) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        if (includeEmptyLine) {
            result.add(Scala.Tuple((Object)"", (Object)""));
        }
        result.add(Scala.Tuple((Object)SepaSequenceType.OOFF.name(), (Object)SepaSequenceType.OOFF.getDescription(messages.lang().locale())));
        result.add(Scala.Tuple((Object)SepaSequenceType.RCUR.name(), (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.sequenceType.repeating", (Object[])new Object[0])));
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getCurrencies() {
        return PaymentUtils.getCurrencies(false);
    }

    public static Seq<Tuple2<String, String>> getCurrencies(boolean includeEmpty) {
        try {
            String[] currencies = CurrenciesLoader.getCurrencies();
            ArrayList<Tuple2> result = new ArrayList<Tuple2>();
            if (includeEmpty) {
                result.add(Scala.Tuple((Object)"", (Object)""));
            }
            for (int i = 0; currencies != null && i < currencies.length; ++i) {
                result.add(Scala.Tuple((Object)currencies[i], (Object)currencies[i]));
            }
            return Scala.toSeq(result);
        }
        catch (IOException e) {
            BLLoggerPlay.warning("Failed to load currencies!", e);
            return null;
        }
    }

    public static Seq<Tuple2<String, String>> getDtazvPaymentTypes(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        List<DtazvPaymentType> excludedPaymentTypes = Branding.getBranding().excludedDtazvPaymentTypes();
        for (DtazvPaymentType dtazvPaymentType : DtazvPaymentType.values()) {
            if (excludedPaymentTypes != null && excludedPaymentTypes.contains(dtazvPaymentType)) continue;
            result.add(Scala.Tuple((Object)dtazvPaymentType.getKey(), (Object)dtazvPaymentType.getDescription(locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getDtazvFeeTypes(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (DtazvFeeType feeType : DtazvFeeType.values()) {
            result.add(Scala.Tuple((Object)feeType.getKey(), (Object)feeType.getDescription(locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getDtazvInstructionCodes(boolean isUrgentPayment, Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (DtazvInstructionCode instructionCode : DtazvInstructionCode.values()) {
            if (isUrgentPayment && !instructionCode.isUsedForEue()) continue;
            result.add(Scala.Tuple((Object)instructionCode.getKey(), (Object)instructionCode.getDescription(locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getDtazvCounterValueInstructionCodes(Messages messages) {
        return Scala.toSeq(Collections.singletonList(Scala.Tuple((Object)"91", (Object)messages.at("dtazvpayment.instructioncode91", new Object[0]))));
    }

    public static Seq<Tuple2<String, String>> getCountries(Locale locale, boolean includeEmptyLine) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        CountriesLoader countriesLoader = CountriesLoader.getInstance((Locale)locale);
        if (includeEmptyLine) {
            result.add(Scala.Tuple((Object)"", (Object)""));
        }
        for (int i = 0; i < countriesLoader.getCountryCodes().length; ++i) {
            result.add(Scala.Tuple((Object)countriesLoader.getCountryCodes()[i], (Object)countriesLoader.getCountryNames()[i]));
        }
        return Scala.toSeq(result);
    }

    public static List<BankUserHtdInfo> getBankAddressFromHTD(User user) {
        ArrayList<BankUserHtdInfo> result = new ArrayList<BankUserHtdInfo>();
        for (BankUser bankUser : BankUser.findActiveBanksConnection((User)user)) {
            BankUserHtdInfo htdinfo = BankUserHtdInfo.findForBankUser((BankUser)bankUser);
            if (htdinfo == null) continue;
            result.add(htdinfo);
        }
        return result;
    }

    public static String getCountry(Locale locale, String countryCode) {
        CountriesLoader countriesLoader = CountriesLoader.getInstance((Locale)locale);
        return countriesLoader.getCountryName(countryCode);
    }

    public static Seq<Tuple2<String, String>> getFolders(User user, Messages messages, PaymentFolder ... excluding) {
        ArrayList<Tuple2> resultList = new ArrayList<Tuple2>();
        boolean exclude = false;
        for (PaymentFolder f : excluding) {
            if (f == null || f.getId() == null || f.getId() != -2) continue;
            exclude = true;
            break;
        }
        if (!exclude) {
            resultList.add(Scala.Tuple((Object)"-2", (Object)messages.at("payment.nofolder", new Object[0])));
        }
        for (PaymentFolder paymentFolder : PaymentFolder.findAll((User)user)) {
            exclude = false;
            for (PaymentFolder f : excluding) {
                if (!paymentFolder.equals(f)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            Object folderName = paymentFolder.getName();
            if (user.getTenants().size() > 1) {
                folderName = (String)folderName + " (" + paymentFolder.getTenant().getName() + ")";
            }
            resultList.add(Scala.Tuple((Object)String.valueOf(paymentFolder.getId()), (Object)Utils.addZWNJ((String)folderName)));
        }
        return Scala.toSeq(resultList);
    }

    public static int countOpenPaymentsForFolder(String username, int folderId) {
        User user = User.getUser((String)username);
        PaymentFolder folder = PaymentFolder.findById((Integer)folderId, (User)user);
        boolean onlyPaymentsWithPermission = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.DISPLAY_ONLY_PAYMENTS_WITH_PERMISSION);
        return OpenPayment.getOpenPaymentsCount((User)user, (PaymentFolder)folder, (boolean)onlyPaymentsWithPermission, (!Util.displayOpenSalaries((User)user) ? 1 : 0) != 0);
    }

    public static int countPeriodicPaymentsForFolder(String username, int folderId) {
        User user = User.getUser((String)username);
        PaymentFolder folder = PaymentFolder.findById((Integer)folderId, (User)user);
        boolean onlyPaymentsWithPermission = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.DISPLAY_ONLY_PAYMENTS_WITH_PERMISSION);
        return PeriodicPayment.getPeriodicPaymentsCount((User)user, (PaymentFolder)folder, (boolean)onlyPaymentsWithPermission, (!Util.displayOpenSalaries((User)user) ? 1 : 0) != 0);
    }

    public static int countSignedPaymentsForFolder(String username, int folderId) {
        User user = User.getUser((String)username);
        PaymentFolder folder = PaymentFolder.findById((Integer)folderId, (User)user);
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        boolean onlyPaymentsWithPermission = store.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.DISPLAY_ONLY_PAYMENTS_WITH_PERMISSION);
        boolean showAllPayments = store.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.SHOW_ALL_SIGNED_PAYMENTS);
        return SignedPayment.getSignedPaymentsCount((User)user, (PaymentFolder)folder, (boolean)onlyPaymentsWithPermission, (!Util.displayOpenSalaries((User)user) ? 1 : 0) != 0, (boolean)showAllPayments);
    }

    public static int countPaymentTemplatesForFolder(String username, int folderId) {
        User user = User.getUser((String)username);
        PaymentFolder folder = PaymentFolder.findById((Integer)folderId, (User)user);
        boolean onlyPaymentsWithPermission = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.payments.core.PreferenceConstants.DISPLAY_ONLY_PAYMENTS_WITH_PERMISSION);
        return PaymentTemplate.getPaymentTemplatesCount((User)user, (PaymentFolder)folder, (boolean)onlyPaymentsWithPermission, (!Util.displayOpenSalaries((User)user) ? 1 : 0) != 0);
    }

    public static String getSendStateDescription(Send send, Messages messages) {
        return SendUtil.getExtendedState((Send)send, (Locale)messages.lang().toLocale());
    }

    public static String getSendTicket(Send send, Locale locale) {
        SendOrderHandler handler = new SendOrderHandler(send);
        String ticket = handler.getTicketFromProtocol(locale);
        if (ticket == null && handler.getDataFile() != null) {
            try {
                ticket = Util.getDisplayMessage((Send)send, (Locale)locale);
            }
            catch (Exception e) {
                BLLoggerPlay.error("Failed to generate accompanying ticket for send order!", e);
            }
        }
        if (ticket == null) {
            ticket = "";
        }
        return ticket;
    }

    public static Integer getSendId(int paymentId) {
        SignedPayment pay = (SignedPayment)DB.find(SignedPayment.class, (Object)paymentId);
        if (pay == null || pay.getSend() == null) {
            return null;
        }
        return pay.getSend().getId();
    }

    public static Integer getSignedOrCancelledOrderDetailsFromSend(int paymentId) {
        Send send = PaymentUtils.getSend(paymentId);
        String ot = send.getOrderType();
        String on = send.getOrderNumber();
        BankSettings bank = send.getBank();
        PaymentTransferType.PmtType pmtType = send.getPmtType();
        Query q = DB.find(DsOrderDetails.class);
        q.where().add(Expr.eq((String)"bank_id", (Object)bank.getBankId()));
        q.where().add(Expr.eq((String)"pmt_type", (Object)pmtType.ordinal()));
        q.where().add(Expr.eq((String)"file_type", (Object)ot));
        q.where().add(Expr.eq((String)"order_id", (Object)on));
        DsOrderDetails dsOrderDetails = (DsOrderDetails)q.findOne();
        if (dsOrderDetails == null) {
            return null;
        }
        return dsOrderDetails.getId();
    }

    public static Send getSend(int sendId) {
        return (Send)DB.find(Send.class, (Object)sendId);
    }

    public static String getSignedPaymentStateDescription(SignedPayment signedPayment, Messages messages) {
        return SendUtil.getExtendedState((SignedPayment)signedPayment, (Locale)messages.lang().toLocale());
    }

    public static boolean isErrorState(Send.State state) {
        return Send.State.FINISHED_ERROR.equals((Object)state) || Send.State.SIGNATURE_STILL_MISSING.equals((Object)state);
    }

    public static AddressData getStructuredAddressData(String dept, String subDept, String street, String buildingNumber, String buildingName, String floor, String town, String postCode, String subCountry, String countryCode) {
        return PaymentUtils.getFullAddressData(dept, subDept, street, buildingNumber, buildingName, floor, town, postCode, subCountry, (String[])null, countryCode);
    }

    public static AddressData getFullAddressData(String dept, String subDept, String street, String buildingNumber, String buildingName, String floor, String town, String postCode, String subCountry, String addressLines, String countryCode) {
        String[] splitAddress = addressLines != null ? addressLines.replace("\r\n", "\n").replace("\n\r", "\n").replace("\r", "").split("\n") : null;
        return PaymentUtils.getFullAddressData(dept, subDept, street, buildingNumber, buildingName, floor, town, postCode, subCountry, splitAddress, countryCode);
    }

    public static AddressData getFullAddressData(String dept, String subDept, String street, String buildingNumber, String buildingName, String floor, String town, String postCode, String subCountry, Collection<String> addressLines, String countryCode) {
        return PaymentUtils.getFullAddressData(dept, subDept, street, buildingNumber, buildingName, floor, town, postCode, subCountry, addressLines.toArray(addressLines.toArray(new String[0])), countryCode);
    }

    public static AddressData getFullAddressData(String dept, String subDept, String street, String buildingNumber, String buildingName, String floor, String town, String postCode, String subCountry, String[] addressLines, String countryCode) {
        String addressLine2;
        String addressLine1 = addressLines != null && addressLines.length >= 1 ? addressLines[0] : null;
        AddressData addressData = AddressData.getStructuredAddress((String)addressLine1, addressLine2 = addressLines != null && addressLines.length >= 2 ? addressLines[1] : null, (String)countryCode);
        if (addressData == null) {
            addressData = new AddressData();
        }
        if (dept != null) {
            addressData.setDepartment(dept);
        }
        if (subDept != null) {
            addressData.setSubDepartment(subDept);
        }
        if (street != null) {
            addressData.setStreetName(street);
        }
        if (buildingNumber != null) {
            addressData.setBuildingNumber(buildingNumber);
        }
        if (buildingName != null) {
            addressData.setBuildingName(buildingName);
        }
        if (floor != null) {
            addressData.setFloor(floor);
        }
        if (town != null) {
            addressData.setTownName(town);
        }
        if (postCode != null) {
            addressData.setPostCode(postCode);
        }
        if (subCountry != null) {
            addressData.setCountrySubDivision(subCountry);
        }
        if (countryCode != null) {
            addressData.setCountry(countryCode);
        }
        return addressData;
    }

    public static String getDKAddressLine1(AddressData address, String addressLine1) {
        return PaymentUtils.getDKAddressLine(address, addressLine1, 1);
    }

    public static String getDKAddressLine2(AddressData address, String addressLine2) {
        return PaymentUtils.getDKAddressLine(address, addressLine2, 2);
    }

    private static String getDKAddressLine(AddressData address, String addressLine, int lineNumber) {
        if (addressLine != null && !addressLine.isEmpty()) {
            return addressLine;
        }
        if (address != null) {
            List convertedStructuredAddressLines = AddressData.convertToDKSepaAddress((AddressData)address).getAddressLines();
            if (convertedStructuredAddressLines != null && convertedStructuredAddressLines.size() >= lineNumber) {
                return (String)convertedStructuredAddressLines.get(lineNumber - 1);
            }
            List addressLines = address.getAddressLines();
            if (addressLines != null && addressLines.size() >= lineNumber) {
                return (String)addressLines.get(lineNumber - 1);
            }
        }
        return "";
    }

    public static Seq<Tuple2<String, String>> getPeriodicPaymentIntervals(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (PeriodicPayment.ExecutionInterval interval : PeriodicPayment.ExecutionInterval.values()) {
            result.add(new Tuple2((Object)interval.name(), (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)("GeneralMessages.executionInterval." + interval.getCode()), (Object[])new Object[0])));
        }
        return Scala.toSeq(result);
    }

    public static List<String> getCreditorIds(String username) {
        User user = User.getUser((String)username);
        ArrayList<String> result = new ArrayList<String>();
        for (PaymentOriginator paymentOriginator : PaymentOriginator.findSEPAOriginators((List)user.getTenants())) {
            SepaOriginatorData sepaOriginator = new SepaOriginatorData();
            try {
                sepaOriginator.setPaymentOriginator(paymentOriginator);
                if (sepaOriginator.getCreditorId() == null || sepaOriginator.getCreditorId().isEmpty() || result.contains(sepaOriginator.getCreditorId())) continue;
                result.add(sepaOriginator.getCreditorId());
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to load SEPA creditor IDs!", e);
            }
        }
        Collections.sort(result);
        return result;
    }

    public static Seq<Tuple2<String, String>> getCreditors(String username) {
        User user = User.getUser((String)username);
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (PaymentOriginator paymentOriginator : PaymentOriginator.findSEPAOriginators((List)user.getTenants())) {
            SepaOriginatorData sepaOriginator = new SepaOriginatorData();
            try {
                sepaOriginator.setPaymentOriginator(paymentOriginator);
                result.add(Scala.Tuple((Object)sepaOriginator.getName(), (Object)sepaOriginator.getCreditorId()));
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to load SEPA creditor IDs!", e);
            }
        }
        result.sort((o1, o2) -> {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1._1 == null) {
                return o2._1 == null ? 0 : 1;
            }
            return ((String)o1._1).compareTo((String)o2._1);
        });
        return Scala.toSeq(result);
    }

    public static boolean isCredit(String orderType, String fileFormat) {
        String orderTypeOrFileFormat = fileFormat != null && !fileFormat.isEmpty() ? fileFormat : orderType;
        return !SepaApi.isDebitOrderType((String)orderTypeOrFileFormat);
    }

    public static boolean isSignedPaymentCancellable(Integer id) {
        SignedPayment payment = (SignedPayment)DB.find(SignedPayment.class).where().eq("id", (Object)id).findOne();
        if (payment != null && payment.getSend() != null) {
            return SendUtil.isCancellableState((Send.State)payment.getSend().getState());
        }
        return false;
    }

    public static boolean isSignedPaymentRecallable(Integer id, User user) {
        SignedPayment payment = (SignedPayment)DB.find(SignedPayment.class).where().eq("id", (Object)id).findOne();
        if (payment != null && payment.getSend() != null) {
            return PaymentUtils.isSentItemRecallable(payment.getSend().getId(), user);
        }
        return false;
    }

    public static boolean isSentItemRecallable(Integer sendId, User user) {
        Send sentItem = (Send)DB.find(Send.class).where().eq("id", (Object)sendId).findOne();
        if (sentItem != null) {
            String permissionError = SepaCallbackApi.checkSepaCallbackPermission((User)user, (Send)sentItem, (Locale)Locale.getDefault());
            if (permissionError != null) {
                return false;
            }
            return SepaCallbackApi.isCallbackAllowed((boolean)new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, user).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.transfer.gui.PreferenceConstants.ALLOW_CALLBACK_FOR_ALL_STATES), (Send)sentItem);
        }
        return false;
    }

    public static boolean isSendItemExternal(Send send) {
        SignedPayment sp2 = (SignedPayment)DB.find(SignedPayment.class).where().eq("send", (Object)send).setMaxRows(1).findOne();
        if (sp2 != null) {
            return !sp2.isManualPayment();
        }
        return true;
    }

    public static String getEditHelpUrl(PaymentContextType paymentContextType, PaymentTransferType.PmtType pmtType) {
        if (paymentContextType == PaymentContextType.OPEN_PAYMENT) {
            if (SepaPaymentForm.isSepaPmtType(pmtType)) {
                if (SepaApi.isForeignPayment((PaymentTransferType.PmtType)pmtType)) {
                    if (SepaApi.isChequePayment((PaymentTransferType.PmtType)pmtType)) {
                        return "payments/xml-cheque";
                    }
                    return "payments/xml-transfer";
                }
                if (SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType)) {
                    return "payments/sepa-debit";
                }
                return "payments/sepa-transfer";
            }
            if (DtazvPaymentForm.isAzvPmtType(pmtType)) {
                return "payments/foreign-transfer";
            }
            if (Mt101PaymentForm.isMt101PmtType(pmtType)) {
                return "payments/mt101-transfer";
            }
            if (TaxOfficePaymentForm.isTaxofficePmtType(pmtType)) {
                return "payments/tax-payment";
            }
            if (PostbarPaymentForm.isPostbarPmtType(pmtType)) {
                return "payments/postbar-payment";
            }
            return "payments/record-payment";
        }
        if (paymentContextType == PaymentContextType.SIGNED_PAYMENT) {
            return "payments/signed-payments";
        }
        if (paymentContextType == PaymentContextType.PERIODIC_PAYMENT || paymentContextType == PaymentContextType.OPEN_TO_PERIODIC_PAYMENT || paymentContextType == PaymentContextType.SIGNED_TO_PERIODIC_PAYMENT) {
            return "payments/periodic-payment";
        }
        if (paymentContextType == PaymentContextType.PAYMENT_TEMPLATE) {
            return "payments/payment-template";
        }
        if (paymentContextType == PaymentContextType.OPEN_DES_DETAILS) {
            return "orders/payment-details";
        }
        if (paymentContextType == PaymentContextType.DES_HISTORY_DETAILS) {
            return "orders/signed-order";
        }
        return null;
    }

    public static String getEditPaymentJsParameters(Http.Request request, Integer paymentId, boolean inEditMode) {
        ObjectNode resultJson = Json.newObject();
        if (inEditMode) {
            resultJson.put("wsUrl", Utils.webSocketUrl((Call)routes.Payments.editPaymentController(), request));
        }
        resultJson.put("user", (String)request.attrs().get(Security.USERNAME));
        resultJson.put("paymentId", paymentId);
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static Seq<Tuple2<String, String>> getClearingSystems() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(new Tuple2((Object)"bic", (Object)"BIC"));
        ArrayList<Tuple2> clearingSystems = new ArrayList<Tuple2>();
        for (ClearingSystem clearingSystem : ClearingSystem.values()) {
            clearingSystems.add(Scala.Tuple((Object)clearingSystem.name(), (Object)clearingSystem.getDescription()));
        }
        clearingSystems.sort(Comparator.comparing(Tuple2::_2));
        result.addAll(clearingSystems);
        return Scala.toSeq(result);
    }

    public static Format2 getCsvFormat2(BankSettings bank, PaymentTransferType.PmtType pmtType, String formatString, String language) {
        Format2 format = new Format2(formatString, language, (ColumnHandler)new XLSColumHandler());
        format.setCreateInstantPayments(SepaApi.isInstantCreditPaymentType((PaymentTransferType.PmtType)pmtType));
        format.setCreateInternationalPayments(SepaApi.isForeignPayment((PaymentTransferType.PmtType)pmtType));
        GeneralSEPAWriter.Version sepaVersion = SepaSchemeHandler.getSepaVersion((BankSettings)bank, (PaymentTransferType.PmtType)pmtType);
        if (sepaVersion == null) {
            sepaVersion = !SepaApi.isDebitPmtType((PaymentTransferType.PmtType)pmtType) ? GeneralSEPAWriter.DEFAULT_DEBIT_VERSION : (SepaApi.isForeignPayment((PaymentTransferType.PmtType)pmtType) ? GeneralSEPAWriter.DEFAULT_FOREIGN_VERSION : GeneralSEPAWriter.DEFAULT_CREDIT_VERSION);
        }
        format.setSepaVersion(sepaVersion);
        return format;
    }

    public static String[] createMt101PurposeLines(String purpose) {
        if (purpose == null) {
            purpose = "";
        }
        int maxLineLength = 35;
        int maxLineCount = 4;
        purpose = Mt101PaymentForm.convertToMt101StringFormat(purpose, 140);
        return StringUtils.addSpaceWhenLineStartsWithMinus((String[])PaymentUtils.createPurposeLines(purpose, 4, 35), (int)4, (int)35);
    }

    public static String[] createDtazvPurposeLines(String purpose) {
        if (purpose == null) {
            purpose = "";
        }
        int maxLineLength = 35;
        int maxLineCount = 4;
        purpose = DtazvPaymentForm.convertToDtazvStringFormat(purpose, 140);
        return PaymentUtils.createPurposeLines(purpose, 4, 35);
    }

    public static String[] createPurposeLines(String purpose, int maxLineCount, int maxLineLength) {
        if (purpose == null) {
            purpose = "";
        }
        ArrayList<String> newPurposeLines = new ArrayList<String>();
        for (int i = 0; i < maxLineCount; ++i) {
            String bySubstring = purpose.length() <= i * maxLineLength ? "" : purpose.substring(i * maxLineLength, Math.min((i + 1) * maxLineLength, purpose.length()));
            newPurposeLines.add(bySubstring);
        }
        return newPurposeLines.toArray(new String[0]);
    }
}

