/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import com.fasterxml.jackson.databind.JsonNode;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.User;
import play.libs.Json;

public final class PaymentLockInfo {
    private OpenPayment openPayment;

    public void handleRequest(String request) {
        int paymentId;
        JsonNode json = Json.parse((String)request);
        if (json.get("user") == null) {
            return;
        }
        User user = User.getUser((String)json.get("user").asText());
        if (user == null) {
            return;
        }
        if (json.get("payment") != null) {
            try {
                paymentId = Integer.parseInt(json.get("payment").asText());
            }
            catch (NumberFormatException e) {
                return;
            }
        } else {
            return;
        }
        this.openPayment = (OpenPayment)DB.find(OpenPayment.class, (Object)paymentId);
        if (this.openPayment == null || BankUser.findBankUser((BankSettings)this.openPayment.getBank(), (User)user) == null || this.openPayment.getLockingUser() != null && !user.equals(this.openPayment.getLockingUser())) {
            this.openPayment = null;
            return;
        }
        OpenPayment.lockPayment((User)user, (OpenPayment)this.openPayment);
    }

    public void unlock() {
        if (this.openPayment != null) {
            OpenPayment.unlockPayment((OpenPayment)this.openPayment);
            this.openPayment = null;
        }
    }
}

