/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.OriginatorData;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.api.RecipientData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class PaymentImportOriginatorAndRecipientHandler {
    private List<RecipientData> recipients;
    private List<OriginatorData> originators;

    public void addRecipient(RecipientData recipient) {
        if (recipient != null) {
            if (this.recipients == null) {
                this.recipients = new ArrayList<RecipientData>();
            }
            this.recipients.add(recipient);
        }
    }

    public void addOriginator(OriginatorData originator) {
        if (this.originators == null) {
            this.originators = new ArrayList<OriginatorData>();
        }
        this.originators.add(originator);
    }

    public void save(User user) {
        if (this.recipients != null) {
            for (RecipientData recipient : this.recipients) {
                try {
                    recipient.save(user, PreferenceUtil.useFourEyesForRecipientRecording((User)user));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.originators != null) {
            for (OriginatorData originator : this.originators) {
                try {
                    originator.save();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public boolean checkForRecipient(String recipientName, String account, String bankCode, PaymentType paymentType, Tenant tenant) {
        if (this.recipients != null) {
            for (RecipientData recipient : this.recipients) {
                if (paymentType != recipient.getPaymentType() || !recipientName.equals(recipient.getName()) || !account.equals(recipient.getAccountNumber()) || bankCode != null && !bankCode.equals(recipient.getBankCode())) continue;
                return true;
            }
        }
        return PaymentRecipient.findRecipientByAccountInfo((PaymentType)paymentType, (String)recipientName, (String)account, (String)bankCode, (Tenant)tenant) != null;
    }

    public boolean checkForOriginator(String originatorName, PaymentType paymentType, Tenant tenant) {
        if (this.originators != null) {
            for (OriginatorData originator : this.originators) {
                if (paymentType != originator.getPaymentType() || !originator.getName().equals(originatorName)) continue;
                return true;
            }
        }
        return PaymentOriginator.findOriginatorByName((PaymentType)paymentType, (String)originatorName, (Tenant)tenant) != null;
    }
}

