/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.GenericPurposeHandler;
import de.businesslogics.banking.payments.api.OriginatorData;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.PDFException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import models.payments.ATChequePaymentHandler;
import models.payments.AustrianForeignPaymentHandler;
import models.payments.ChequePaymentHandler;
import models.payments.DtazvPaymentHandler;
import models.payments.Mt101PaymentHandler;
import models.payments.PaymentException;
import models.payments.PostbarPaymentHandler;
import models.payments.SepaPaymentHandler;
import models.payments.TaxOfficePaymentHandler;

public abstract class PaymentHandler<T> {
    public static final Set<String> USED_TEMPLATE_NAMES = new HashSet<String>();
    protected final T payment;
    private String reference;

    public static PaymentHandler<?> getHandler(PaymentTransferType.PmtType pmtType, byte[] paymentData) throws PaymentException {
        if (pmtType != null) {
            if (SepaPaymentHandler.handlesPmtType(pmtType)) {
                if (PostbarPaymentHandler.handlesPmtType(pmtType)) {
                    return new PostbarPaymentHandler(pmtType, paymentData, 0);
                }
                if (TaxOfficePaymentHandler.handlesPmtType(pmtType)) {
                    return new TaxOfficePaymentHandler(pmtType, paymentData, 0);
                }
                if (AustrianForeignPaymentHandler.handlesPmtType(pmtType)) {
                    return new AustrianForeignPaymentHandler(pmtType, paymentData, 0);
                }
                if (ChequePaymentHandler.handlesPmtType(pmtType)) {
                    return new ChequePaymentHandler(pmtType, paymentData, 0);
                }
                if (ATChequePaymentHandler.handlesPmtType(pmtType)) {
                    return new ATChequePaymentHandler(pmtType, paymentData, 0);
                }
                return new SepaPaymentHandler(pmtType, paymentData, 0);
            }
            if (DtazvPaymentHandler.handlesPmtType(pmtType)) {
                return new DtazvPaymentHandler(pmtType, paymentData, 0);
            }
            if (Mt101PaymentHandler.handlesPmtType(pmtType)) {
                return new Mt101PaymentHandler(pmtType, paymentData, 0);
            }
            throw new PaymentException("Unknown payment type: " + pmtType.name());
        }
        throw new PaymentException("Can not handle, payment type is null.");
    }

    public static PaymentHandler<?> getHandler(Object payment, PaymentTransferType.PmtType pmtType) throws PaymentException {
        if (payment instanceof SEPAPaymentData) {
            if (PostbarPaymentHandler.handlesPmtType(pmtType)) {
                return new PostbarPaymentHandler(pmtType, (SEPAPaymentData)payment, 0);
            }
            if (TaxOfficePaymentHandler.handlesPmtType(pmtType)) {
                return new TaxOfficePaymentHandler(pmtType, (SEPAPaymentData)payment, 0);
            }
            if (AustrianForeignPaymentHandler.handlesPmtType(pmtType)) {
                return new AustrianForeignPaymentHandler(pmtType, (SEPAPaymentData)payment, 0);
            }
            if (ChequePaymentHandler.handlesPmtType(pmtType)) {
                return new ChequePaymentHandler(pmtType, (SEPAPaymentData)payment, 0);
            }
            if (ATChequePaymentHandler.handlesPmtType(pmtType)) {
                return new ATChequePaymentHandler(pmtType, (SEPAPaymentData)payment, 0);
            }
            return new SepaPaymentHandler(pmtType, (SEPAPaymentData)payment, 0);
        }
        if (payment instanceof DTAZVPayment) {
            return new DtazvPaymentHandler((DTAZVPayment)payment, 0);
        }
        if (payment instanceof MT101PaymentData) {
            return new Mt101PaymentHandler((MT101PaymentData)payment, 0);
        }
        throw new PaymentException("Unknown payment type " + String.valueOf(payment));
    }

    public static List<? extends PaymentHandler<?>> getHandlers(InputStream inputStream, PaymentTransferType.PmtType defaultPmtType, String bankCountryCode) throws PaymentException {
        if (defaultPmtType == null) {
            throw new PaymentException("Can not handle, payment type is null.");
        }
        if (DtazvPaymentHandler.handlesPmtType(defaultPmtType)) {
            return DtazvPaymentHandler.getDtazvHandlers(inputStream);
        }
        if (Mt101PaymentHandler.handlesPmtType(defaultPmtType)) {
            return Mt101PaymentHandler.getMt101Handlers(inputStream);
        }
        if (SepaPaymentHandler.handlesPmtType(defaultPmtType)) {
            ArrayList<SepaPaymentHandler> handlers = new ArrayList<SepaPaymentHandler>();
            int sequenceNumber = 1;
            for (SEPAPaymentData paymentData : SepaPaymentHandler.getPaymentDataFromInputStream(inputStream, defaultPmtType)) {
                PaymentTransferType.PmtType pmtType = SepaApi.getPmtType((SEPAPaymentData)paymentData, (PaymentTransferType.PmtType)defaultPmtType, (String)bankCountryCode);
                if (!SepaPaymentHandler.handlesPmtType(pmtType)) continue;
                if (PostbarPaymentHandler.handlesPmtType(pmtType)) {
                    handlers.add(new PostbarPaymentHandler(pmtType, paymentData, sequenceNumber++));
                    continue;
                }
                if (TaxOfficePaymentHandler.handlesPmtType(pmtType)) {
                    handlers.add(new TaxOfficePaymentHandler(pmtType, paymentData, sequenceNumber++));
                    continue;
                }
                if (AustrianForeignPaymentHandler.handlesPmtType(pmtType)) {
                    handlers.add(new AustrianForeignPaymentHandler(pmtType, paymentData, sequenceNumber++));
                    continue;
                }
                if (ChequePaymentHandler.handlesPmtType(pmtType)) {
                    handlers.add(new ChequePaymentHandler(pmtType, paymentData, sequenceNumber++));
                    continue;
                }
                if (ATChequePaymentHandler.handlesPmtType(pmtType)) {
                    handlers.add(new ATChequePaymentHandler(pmtType, paymentData, sequenceNumber++));
                    continue;
                }
                handlers.add(new SepaPaymentHandler(pmtType, paymentData, sequenceNumber++));
            }
            return handlers;
        }
        throw new PaymentException("Unknown payment type: " + defaultPmtType.name());
    }

    public static boolean isHandlerPresent(PaymentTransferType.PmtType pmtType) {
        if (pmtType == null) {
            return false;
        }
        return SepaPaymentHandler.handlesPmtType(pmtType) || DtazvPaymentHandler.handlesPmtType(pmtType) || Mt101PaymentHandler.handlesPmtType(pmtType);
    }

    protected PaymentHandler(PaymentTransferType.PmtType pmtType, byte[] rawPaymentData, int sequenceNumber) throws PaymentException {
        this.payment = this.loadPayment(pmtType, rawPaymentData);
        if (this.payment == null) {
            throw new PaymentException("Failed to load payment object for payment type " + String.valueOf(pmtType));
        }
        this.reference = sequenceNumber > 0 ? this.loadReference(sequenceNumber) : null;
    }

    protected PaymentHandler(T payment, int sequenceNumber) {
        this.payment = payment;
        this.reference = sequenceNumber > 0 ? this.loadReference(sequenceNumber) : null;
    }

    public final T getPayment() {
        return this.payment;
    }

    public final void resetReference() {
        if (this.internalResetReference()) {
            this.reference = null;
        }
    }

    public final String getReference() {
        return this.reference;
    }

    public final OpenPayment createOpenPayment(BankSettings bankSettings, PaymentTransferType.PmtType pmtType, PaymentFolder paymentFolder, boolean resetReference) throws PaymentException {
        OpenPayment openPayment = new OpenPayment();
        openPayment.setBank(bankSettings);
        openPayment.setFolder(paymentFolder);
        openPayment.setPmtType(pmtType);
        openPayment.setOrderType(SendParameters.getOrderType((BankSettings)bankSettings, (PaymentTransferType.PmtType)pmtType));
        openPayment.setFileType(SendParameters.getBTF((BankSettings)bankSettings, (PaymentTransferType.PmtType)pmtType));
        if (resetReference) {
            this.resetReference();
        }
        openPayment.setOriginator(this.getOriginator());
        this.updateOpenPayment(openPayment);
        return openPayment;
    }

    public final void updateOpenPayment(OpenPayment openPayment) throws PaymentException {
        openPayment.setPmtType(this.getPaymentType(openPayment.getPmtType()));
        if (openPayment.getAccount() == null) {
            openPayment.setAccount(this.getOriginatorAccount(openPayment.getBank()));
            if (openPayment.getAccount() == null) {
                throw new PaymentException("Did not find originator account for open payment!");
            }
        }
        openPayment.setCredit(this.isCredit());
        openPayment.setUrgent(this.isUrgent(openPayment.getPmtType()));
        openPayment.setRecipient(this.getRecipient());
        openPayment.setAmount(this.getAmount());
        openPayment.setAmountCurrency(this.getCurrencyCode());
        openPayment.setPurpose(this.getPurpose());
        openPayment.setSalaryPayment(Boolean.valueOf(this.isSalaryPayment()));
        if (this.getExecutionDate() != null) {
            Timestamp newExecutionDate = new Timestamp(this.getExecutionDate().getTime());
            openPayment.setExecutionDate(newExecutionDate);
        }
        openPayment.setPaymentData(this.buildPaymentData(openPayment.getBank()));
        openPayment.setOriginator(this.getOriginator());
        if (openPayment.getFolder() != null && openPayment.getFolder() != PaymentFolder.NULL_FOLDER && !openPayment.getFolder().getTenant().equals(openPayment.getAccount().getBank().getTenant())) {
            openPayment.setFolder(null);
        }
    }

    public void updateSignedPayment(SignedPayment signedPayment) throws PaymentException {
        signedPayment.setPmtType(this.getPaymentType(signedPayment.getPmtType()));
        if (signedPayment.getAccount() == null) {
            Account account = this.getOriginatorAccount(signedPayment.getSend().getBank());
            if (account == null) {
                throw new PaymentException("Did not find originator account for signed payment!");
            }
            signedPayment.setAccount(account);
        }
        signedPayment.setCredit(this.isCredit());
        signedPayment.setUrgent(this.isUrgent(signedPayment.getSend().getPmtType()));
        signedPayment.setRecipient(this.getRecipient());
        signedPayment.setAmount(this.getAmount());
        if (!this.isSalaryPayment()) {
            signedPayment.setSalaryAmount(this.getAmount());
            signedPayment.setSalaryPayment(false);
        } else {
            signedPayment.setSalaryPayment(true);
        }
        signedPayment.setAmountCurrency(this.getCurrencyCode());
        signedPayment.setPurpose(this.getPurpose());
        if (this.getExecutionDate() != null) {
            signedPayment.setExecutionDate(new Timestamp(this.getExecutionDate().getTime()));
        }
        signedPayment.setReference(this.getReference());
        signedPayment.setPaymentData(this.buildPaymentData(signedPayment.getSend().getBank()));
        signedPayment.setOriginator(this.getOriginator());
    }

    public final PeriodicPayment createPeriodicPayment(BankSettings bankSettings, PaymentTransferType.PmtType pmtType, PaymentFolder paymentFolder, boolean resetReference) throws PaymentException {
        PeriodicPayment periodicPayment = new PeriodicPayment();
        periodicPayment.setBank(bankSettings);
        periodicPayment.setPmtType(pmtType);
        periodicPayment.setOrderType(SendParameters.getOrderType((BankSettings)bankSettings, (PaymentTransferType.PmtType)pmtType));
        periodicPayment.setFileType(SendParameters.getBTF((BankSettings)bankSettings, (PaymentTransferType.PmtType)pmtType));
        periodicPayment.setFolder(paymentFolder);
        periodicPayment.setFirstExecutionDate(new Date(System.currentTimeMillis()));
        if (resetReference) {
            this.resetReference();
        }
        periodicPayment.setOriginator(this.getOriginator());
        this.updatePeriodicPayment(periodicPayment);
        return periodicPayment;
    }

    public final void updatePeriodicPayment(PeriodicPayment periodicPayment) throws PaymentException {
        if (periodicPayment.getAccount() == null) {
            periodicPayment.setAccount(this.getOriginatorAccount(periodicPayment.getBank()));
            if (periodicPayment.getAccount() == null) {
                throw new PaymentException("Did not find originator account for periodic payment!");
            }
        }
        periodicPayment.setCredit(this.isCredit());
        periodicPayment.setUrgent(this.isUrgent(periodicPayment.getPmtType()));
        periodicPayment.setRecipient(this.getRecipient());
        periodicPayment.setAmount(this.getAmount());
        periodicPayment.setAmountCurrency(this.getCurrencyCode());
        periodicPayment.setSalaryPayment(Boolean.valueOf(this.isSalaryPayment()));
        GenericPurposeHandler.getGenericPurposeHandlerForPeriodicPayment((PeriodicPayment)periodicPayment).setGenericPurpose(this.getPurpose());
        if (periodicPayment.getGenericPurpose() == null) {
            periodicPayment.setPurpose(this.getPurpose());
        }
        periodicPayment.setPaymentData(this.buildPaymentData(periodicPayment.getBank()));
        periodicPayment.setOriginator(this.getOriginator());
    }

    public final PaymentTemplate createPaymentTemplate(BankSettings bankSettings, PaymentTransferType.PmtType pmtType, String templateName, PaymentFolder folder) throws PaymentException {
        Object checkedTemplateName = templateName;
        int count = 1;
        while (USED_TEMPLATE_NAMES.contains(checkedTemplateName) || PaymentTemplate.findTemplateByNameAndTenant((String)checkedTemplateName, (Tenant)bankSettings.getTenant()) != null) {
            checkedTemplateName = templateName + "." + count++;
        }
        PaymentTemplate paymentTemplate = new PaymentTemplate();
        paymentTemplate.setBank(bankSettings);
        paymentTemplate.setPmtType(pmtType);
        paymentTemplate.setOrderType(SendParameters.getOrderType((BankSettings)bankSettings, (PaymentTransferType.PmtType)pmtType));
        paymentTemplate.setFileType(SendParameters.getBTF((BankSettings)bankSettings, (PaymentTransferType.PmtType)pmtType));
        paymentTemplate.setName((String)checkedTemplateName);
        paymentTemplate.setFolder(folder);
        paymentTemplate.setOriginator(this.getOriginator());
        this.updatePaymentTemplate(paymentTemplate);
        USED_TEMPLATE_NAMES.add((String)checkedTemplateName);
        return paymentTemplate;
    }

    public final void updatePaymentTemplate(PaymentTemplate paymentTemplate) throws PaymentException {
        if (paymentTemplate.getAccount() == null) {
            paymentTemplate.setAccount(this.getOriginatorAccount(paymentTemplate.getBank()));
            if (paymentTemplate.getAccount() == null) {
                throw new PaymentException("Did not find originator account for payment template!");
            }
        }
        paymentTemplate.setCredit(true);
        PaymentTransferType.PmtType pmtType = this.getPaymentType(paymentTemplate.getPmtType());
        paymentTemplate.setPmtType(pmtType);
        paymentTemplate.setUrgent(this.isUrgent(pmtType));
        paymentTemplate.setRecipient(this.getRecipient());
        paymentTemplate.setAmount(this.getAmount());
        paymentTemplate.setAmountCurrency(this.getCurrencyCode());
        paymentTemplate.setSalaryPayment(Boolean.valueOf(this.isSalaryPayment()));
        GenericPurposeHandler.getGenericPurposeHandlerForPaymentTemplate((PaymentTemplate)paymentTemplate).setGenericPurpose(this.getPurpose());
        paymentTemplate.setPaymentData(this.buildPaymentData(paymentTemplate.getBank()));
        paymentTemplate.setOriginator(this.getOriginator());
    }

    public abstract String getOriginator();

    public abstract boolean setOriginator(PaymentOriginator var1);

    public abstract Account getOriginatorAccount(BankSettings var1);

    public abstract String getOriginatorAccount();

    public abstract boolean setOriginatorAccount(Account var1);

    public abstract String getAccountRepresentation(Account var1);

    public abstract boolean isSalaryPayment();

    public abstract boolean isCredit();

    public abstract boolean isUrgent(PaymentTransferType.PmtType var1);

    public abstract String getRecipient();

    public abstract String getRecipientAccount();

    public abstract String getRecipientNameAndAccount();

    public abstract String getRecipientAccountNumber();

    public abstract String getRecipientBankcode();

    public abstract String getRecipientCountry();

    public abstract java.util.Date getExecutionDate();

    public abstract BigDecimal getAmount();

    public abstract String getCurrencyCode();

    public abstract String getPurpose();

    public abstract void setPurpose(List<String> var1);

    public abstract boolean replaceInPurpose(String var1, String var2);

    public abstract boolean isExecutionDateExceeded(PaymentProperties var1, String var2);

    public abstract boolean isExecutionDateTooEarly(PaymentProperties var1);

    public abstract String getCorrectionMessage(PaymentProperties var1, Locale var2);

    public abstract int getMaxExecutionDateOffset(PaymentProperties var1);

    public abstract void correctPayment(OpenPayment var1, User var2) throws PaymentException;

    public abstract void print(BLDocument var1, Locale var2, String var3, SignedPayment var4) throws PDFException;

    public abstract void setEarliestExecutionDate(java.util.Date var1, BankSettings var2, PaymentProperties var3);

    public abstract byte[] buildPaymentData(BankSettings var1) throws PaymentException;

    public abstract OriginatorData buildOriginator(Tenant var1) throws PaymentException;

    public abstract RecipientData buildRecipient(boolean var1, Integer var2, PaymentType var3, Tenant var4, List<Tenant> var5, boolean var6) throws PaymentException;

    public abstract boolean updatePaymentAfterGeneration();

    public abstract boolean checkRecipientAccount();

    public abstract PaymentTransferType.PmtType getPaymentType(PaymentTransferType.PmtType var1);

    public boolean isSingleBooking() {
        return false;
    }

    protected abstract T loadPayment(PaymentTransferType.PmtType var1, byte[] var2) throws PaymentException;

    protected abstract String loadReference(int var1);

    protected abstract boolean internalResetReference();

    protected abstract String getOrderType(String var1, BankSettings var2);

    protected abstract String getFileFormat(String var1, BankSettings var2);
}

