/*
 * Decompiled with CFR 0.152.
 */
package models.payments;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt101.api.MT101Api;
import de.businesslogics.banking.mt101.api.MT101OriginatorData;
import de.businesslogics.banking.mt101.api.MT101PaymentPrinter;
import de.businesslogics.banking.mt101.api.MT101RecipientData;
import de.businesslogics.banking.payments.api.OriginatorData;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.format.swift.ParseException;
import de.businesslogics.format.swift.mt101.MT101Extractor;
import de.businesslogics.format.swift.mt101.MT101LogicalFile;
import de.businesslogics.format.swift.mt101.MT101PaymentData;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.SystemUtils;
import de.businesslogics.validation.RegularExpressions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import models.Mt101PaymentForm;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import models.payments.PaymentUtils;

public final class Mt101PaymentHandler
extends PaymentHandler<MT101PaymentData> {
    public static final SimpleDateFormat yyMMdd = new SimpleDateFormat("yyMMdd");

    public static boolean handlesPmtType(PaymentTransferType.PmtType pmtType) {
        return MT101Api.isMt101PmtType((PaymentTransferType.PmtType)pmtType);
    }

    public static List<Mt101PaymentHandler> getMt101Handlers(InputStream inputStream) throws PaymentException {
        ArrayList<Mt101PaymentHandler> result = new ArrayList<Mt101PaymentHandler>();
        try {
            int sequenceNumber = 1;
            for (MT101LogicalFile logicalFile : new MT101Extractor().getLogicalFiles(inputStream)) {
                for (MT101PaymentData payment : logicalFile.getPayments()) {
                    result.add(new Mt101PaymentHandler(payment, sequenceNumber++));
                }
            }
        }
        catch (ParseException | IOException e) {
            throw new PaymentException("Failed to parse MT101 payments from input stream!", e);
        }
        return result;
    }

    protected Mt101PaymentHandler(PaymentTransferType.PmtType pmtType, byte[] rawPaymentData, int sequenceNumber) throws PaymentException {
        super(pmtType, rawPaymentData, sequenceNumber);
    }

    protected Mt101PaymentHandler(MT101PaymentData payment, int sequenceNumber) {
        super(payment, sequenceNumber);
    }

    @Override
    public String getOriginator() {
        return ((MT101PaymentData)this.payment).getOriginatorName();
    }

    @Override
    public boolean setOriginator(PaymentOriginator paymentOriginator) {
        if (paymentOriginator == null || paymentOriginator.getPaymentType() != PaymentType.MT101) {
            return false;
        }
        MT101OriginatorData mt101Originator = new MT101OriginatorData();
        try {
            mt101Originator.setPaymentOriginator(paymentOriginator);
            ((MT101PaymentData)this.payment).setOriginatorAddress(new String[]{mt101Originator.getName(), mt101Originator.getName2(), mt101Originator.getStreet(), mt101Originator.getTown()});
            ((MT101PaymentData)this.payment).setSenderBic(mt101Originator.getSenderBic());
            ((MT101PaymentData)this.payment).setReceiverBic(mt101Originator.getReceiverBic());
            return true;
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to load MT101 originator information for originator " + paymentOriginator.getId() + "!", e);
            return false;
        }
    }

    @Override
    public Account getOriginatorAccount(BankSettings bankSettings) {
        Account tmp;
        if (IbanUtil.checkIban((String)this.getOriginatorAccount())) {
            tmp = Account.findAccountByIbanBic((BankSettings)bankSettings, (String)this.getOriginatorAccount(), null, (String)this.getCurrencyCode());
            if (tmp == null) {
                tmp = Account.findAccountByIbanBic((BankSettings)bankSettings, (String)this.getOriginatorAccount(), null, null);
            }
            if (tmp == null) {
                tmp = new Account();
                tmp.setIban(this.getOriginatorAccount());
                tmp.setCurrency(this.getCurrencyCode());
            }
        } else {
            tmp = Account.findAccountByNationalAccountNumberBic((BankSettings)bankSettings, (String)((MT101PaymentData)this.payment).getOriginatorBic(), (String)this.getOriginatorAccount(), (String)this.getCurrencyCode());
            if (tmp == null && (tmp = Account.findAccountByNationalAccountNumberBic((BankSettings)bankSettings, (String)((MT101PaymentData)this.payment).getOriginatorBic(), (String)this.getOriginatorAccount(), null)) == null && (tmp = Account.findAccountByNationalAccountNumber((BankSettings)bankSettings, (String)this.getOriginatorAccount(), (String)this.getCurrencyCode())) == null) {
                tmp = Account.findAccountByNationalAccountNumber((BankSettings)bankSettings, (String)this.getOriginatorAccount(), null);
            }
        }
        return tmp;
    }

    @Override
    public String getOriginatorAccount() {
        return ((MT101PaymentData)this.payment).getOriginatorAccount();
    }

    @Override
    public boolean setOriginatorAccount(Account account) {
        if (account == null || account.getBic() == null || account.getBic().isEmpty()) {
            return false;
        }
        if (account.getIban() != null && !account.getIban().isEmpty()) {
            ((MT101PaymentData)this.payment).setOriginatorAccount(account.getIban());
            ((MT101PaymentData)this.payment).setOriginatorBic(account.getBic());
            return true;
        }
        if (account.getNationalAccountNumber() != null && !account.getNationalAccountNumber().isEmpty()) {
            ((MT101PaymentData)this.payment).setOriginatorAccount(account.getNationalAccountNumber());
            ((MT101PaymentData)this.payment).setOriginatorBic(account.getBic());
            return true;
        }
        return false;
    }

    @Override
    public String getAccountRepresentation(Account account) {
        if (account != null) {
            return Account.getMT101DisplayName((Account)account, (boolean)false);
        }
        Account dummyAccount = new Account();
        dummyAccount.setBic(((MT101PaymentData)this.payment).getOriginatorBic());
        if (IbanUtil.checkIban((String)((MT101PaymentData)this.payment).getOriginatorAccount())) {
            dummyAccount.setIban(((MT101PaymentData)this.payment).getOriginatorAccount());
        } else {
            dummyAccount.setNationalAccountNumber(((MT101PaymentData)this.payment).getOriginatorAccount());
        }
        if (((MT101PaymentData)this.payment).getCurrency() != null) {
            dummyAccount.setCurrency(((MT101PaymentData)this.payment).getCurrency().getCurrencyCode());
        }
        return Account.getMT101DisplayName((Account)dummyAccount, (boolean)false);
    }

    @Override
    public boolean isSalaryPayment() {
        return false;
    }

    @Override
    public boolean isCredit() {
        return true;
    }

    @Override
    public boolean isUrgent(PaymentTransferType.PmtType pmtType) {
        return false;
    }

    @Override
    public String getRecipient() {
        return ((MT101PaymentData)this.payment).getRecipientName();
    }

    @Override
    public String getRecipientAccount() {
        Account account = new Account();
        account.setBic(((MT101PaymentData)this.payment).getRecipientBankCode());
        if (IbanUtil.checkIban((String)((MT101PaymentData)this.payment).getRecipientAccount())) {
            account.setIban(((MT101PaymentData)this.payment).getRecipientAccount());
        } else {
            account.setNationalAccountNumber(((MT101PaymentData)this.payment).getRecipientAccount());
        }
        return Account.getMT101DisplayName((Account)account, (boolean)false);
    }

    @Override
    public String getRecipientNameAndAccount() {
        Account account = new Account();
        account.setBic(((MT101PaymentData)this.payment).getRecipientBankCode());
        if (IbanUtil.checkIban((String)((MT101PaymentData)this.payment).getRecipientAccount())) {
            account.setIban(((MT101PaymentData)this.payment).getRecipientAccount());
        } else {
            account.setNationalAccountNumber(((MT101PaymentData)this.payment).getRecipientAccount());
        }
        String accountNumber = Account.getMT101DisplayName((Account)account, (boolean)false);
        return ((MT101PaymentData)this.payment).getRecipientName() + " (" + IbanUtil.formatIfIBAN((String)accountNumber) + ")";
    }

    @Override
    public String getRecipientAccountNumber() {
        return ((MT101PaymentData)this.payment).getRecipientAccount();
    }

    @Override
    public String getRecipientBankcode() {
        return ((MT101PaymentData)this.payment).getRecipientBankCode();
    }

    @Override
    public String getRecipientCountry() {
        if (((MT101PaymentData)this.payment).getRecipientAccount() != null && IbanUtil.checkIban((String)((MT101PaymentData)this.payment).getRecipientAccount())) {
            return ((MT101PaymentData)this.payment).getRecipientAccount().substring(0, 2);
        }
        if (((MT101PaymentData)this.payment).getRecipientBankCode() != null && RegularExpressions.BIC.matches(((MT101PaymentData)this.payment).getRecipientBankCode())) {
            return ((MT101PaymentData)this.payment).getRecipientBankCode().substring(4, 6);
        }
        return null;
    }

    @Override
    public Date getExecutionDate() {
        try {
            return yyMMdd.parse(((MT101PaymentData)this.payment).getExecutionDate());
        }
        catch (java.text.ParseException e) {
            return null;
        }
    }

    @Override
    public BigDecimal getAmount() {
        return ((MT101PaymentData)this.payment).getAmount();
    }

    @Override
    public String getCurrencyCode() {
        return ((MT101PaymentData)this.payment).getCurrency().getCurrencyCode();
    }

    @Override
    public String getPurpose() {
        return ((MT101PaymentData)this.payment).getPurpose();
    }

    @Override
    public void setPurpose(List<String> purpose) {
        if (purpose == null || purpose.isEmpty()) {
            ((MT101PaymentData)this.payment).setPurposeArray(null);
        } else if (purpose.size() <= 4) {
            ((MT101PaymentData)this.payment).setPurposeArray(purpose.toArray(new String[0]));
        } else {
            ((MT101PaymentData)this.payment).setPurposeArray(purpose.subList(0, 4).toArray(new String[4]));
        }
    }

    @Override
    public boolean replaceInPurpose(String what, String by) {
        int maxLineLength = 35;
        int maxLineCount = 4;
        if (by == null) {
            by = "";
        }
        by = Mt101PaymentForm.convertToMt101StringFormat(by, 140);
        if (what == null || what.isEmpty()) {
            ((MT101PaymentData)this.payment).setPurposeArray(PaymentUtils.createMt101PurposeLines(by));
            return true;
        }
        if (((MT101PaymentData)this.payment).getPurposeArray() == null) {
            return false;
        }
        boolean modified = false;
        for (int i = 0; i < ((MT101PaymentData)this.payment).getPurposeArray().length; ++i) {
            String newValue = ((MT101PaymentData)this.payment).getPurposeArray()[i].replace(what, by);
            if ((newValue = newValue.substring(0, Math.min(newValue.length(), 35))).equals(((MT101PaymentData)this.payment).getPurposeArray()[i])) continue;
            ((MT101PaymentData)this.payment).getPurposeArray()[i] = newValue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean isExecutionDateExceeded(PaymentProperties paymentProperties, String orderOrFileType) {
        if (((MT101PaymentData)this.payment).getExecutionDate() != null) {
            try {
                Date executionDate = yyMMdd.parse(((MT101PaymentData)this.payment).getExecutionDate());
                Calendar cal = Calendar.getInstance();
                cal.setTime(executionDate);
                cal.add(5, 1);
                return new Date().after(cal.getTime());
            }
            catch (java.text.ParseException e) {
                BLLoggerPlay.warning("Invalid execution date found in MT101 payment!", e);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isExecutionDateTooEarly(PaymentProperties paymentProperties) {
        return false;
    }

    @Override
    public String getCorrectionMessage(PaymentProperties paymentProperties, Locale locale) {
        return null;
    }

    @Override
    public int getMaxExecutionDateOffset(PaymentProperties paymentProperties) {
        return 15;
    }

    @Override
    public void correctPayment(OpenPayment vo, User user) {
    }

    @Override
    public void print(BLDocument document, Locale locale, String orderOrFileType, SignedPayment signedPayment) throws PDFException {
        Send send = signedPayment != null ? signedPayment.getSend() : null;
        new MT101PaymentPrinter(locale).printPayment(document, send, (MT101PaymentData)this.payment, null);
    }

    @Override
    public void setEarliestExecutionDate(Date executionDate, BankSettings bank, PaymentProperties paymentProperties) {
        ((MT101PaymentData)this.payment).setExecutionDate(executionDate);
    }

    @Override
    public byte[] buildPaymentData(BankSettings bank) throws PaymentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ((MT101PaymentData)this.payment).save((OutputStream)baos, false, false, 0, 0);
        }
        catch (IOException e) {
            throw new PaymentException("Failed to write MT101 payment information: " + e.getLocalizedMessage(), e);
        }
        finally {
            SystemUtils.close((AutoCloseable)baos);
        }
        return baos.toByteArray();
    }

    @Override
    public OriginatorData buildOriginator(Tenant tenant) throws PaymentException {
        PaymentOriginator paymentOriginator = PaymentOriginator.findOriginatorByName((PaymentType)PaymentType.MT101, (String)((MT101PaymentData)this.payment).getOriginatorName(), (Tenant)tenant);
        if (paymentOriginator == null) {
            paymentOriginator = new PaymentOriginator();
            paymentOriginator.setPaymentType(PaymentType.MT101);
            paymentOriginator.setName(((MT101PaymentData)this.payment).getOriginatorName());
            paymentOriginator.setTenant(tenant);
        }
        MT101OriginatorData result = new MT101OriginatorData();
        try {
            result.setPaymentOriginator(paymentOriginator);
        }
        catch (IOException e) {
            throw new PaymentException("Failed to load MT101 originator info!", e);
        }
        result.setName2(((MT101PaymentData)this.payment).getOriginatorName2());
        result.setStreet(((MT101PaymentData)this.payment).getOriginatorStreet());
        result.setTown(((MT101PaymentData)this.payment).getOriginatorTown());
        result.setSenderBic(((MT101PaymentData)this.payment).getSenderBic());
        result.setReceiverBic(((MT101PaymentData)this.payment).getReceiverBic());
        return result;
    }

    @Override
    public RecipientData buildRecipient(boolean forceNewRecipient, Integer recipientId, PaymentType paymentType, Tenant tenant, List<Tenant> admissibleTenants, boolean allowRecipientModification) throws PaymentException {
        if (paymentType != PaymentType.MT101) {
            throw new PaymentException("Invalid payment type for MT101 recipients: " + paymentType.name());
        }
        PaymentRecipient paymentRecipient = null;
        if (!forceNewRecipient) {
            if (recipientId != null) {
                paymentRecipient = PaymentRecipient.findByIdAndTenants((int)recipientId, admissibleTenants);
            }
            if (paymentRecipient == null) {
                paymentRecipient = PaymentRecipient.findRecipientByAccountInfo(Collections.singletonList(PaymentType.MT101), (String)this.getRecipient(), (String)this.getRecipientAccountNumber(), (String)this.getRecipientBankcode(), admissibleTenants);
            }
        }
        if (!allowRecipientModification && paymentRecipient != null) {
            return null;
        }
        if (paymentRecipient == null) {
            paymentRecipient = new PaymentRecipient();
            paymentRecipient.setTenant(tenant);
            paymentRecipient.setDisplayName(RecipientData.getUniqueDisplayName((String)this.getRecipient(), (PaymentType)PaymentType.MT101, (Tenant)tenant));
        }
        paymentRecipient.setPaymentType(PaymentType.MT101);
        paymentRecipient.setName(this.getRecipient());
        paymentRecipient.setAccountNumber(this.getRecipientAccountNumber());
        paymentRecipient.setBankCode(this.getRecipientBankcode());
        MT101RecipientData result = new MT101RecipientData();
        try {
            result.setPaymentRecipient(paymentRecipient);
        }
        catch (IOException e) {
            throw new PaymentException("Failed to load MT101 recipient info!", e);
        }
        result.setName2(((MT101PaymentData)this.payment).getRecipientName2());
        result.setStreet(((MT101PaymentData)this.payment).getRecipientStreet());
        result.setTown(((MT101PaymentData)this.payment).getRecipientTown());
        result.setPurpose1(((MT101PaymentData)this.payment).getPurpose());
        result.setPurpose2(((MT101PaymentData)this.payment).getPurpose2());
        result.setPurpose3(((MT101PaymentData)this.payment).getPurpose3());
        result.setPurpose4(((MT101PaymentData)this.payment).getPurpose4());
        result.setFeeType(((MT101PaymentData)this.payment).getFeeType());
        result.setIntermediaryBankCode(((MT101PaymentData)this.payment).getIntermediaryBankCode());
        return result;
    }

    @Override
    public boolean updatePaymentAfterGeneration() {
        return false;
    }

    @Override
    public boolean checkRecipientAccount() {
        return true;
    }

    @Override
    protected MT101PaymentData loadPayment(PaymentTransferType.PmtType pmtType, byte[] rawPaymentData) throws PaymentException {
        ByteArrayInputStream bais = new ByteArrayInputStream(rawPaymentData);
        try {
            List logicalFiles = new MT101Extractor().getLogicalFiles((InputStream)bais);
            if (logicalFiles.size() != 1) {
                throw new PaymentException("MT101 payment file should contain only 1 logical file, but it contains " + logicalFiles.size() + " logical files");
            }
            if (((MT101LogicalFile)logicalFiles.get(0)).getPayments().size() != 1) {
                throw new PaymentException("MT101 logical file should contain only 1 transaction, but it contains " + logicalFiles.size() + " transactions");
            }
            return (MT101PaymentData)((MT101LogicalFile)logicalFiles.get(0)).getPayments().get(0);
        }
        catch (ParseException | IOException e) {
            throw new PaymentException("Failed to read MT101 payment data: " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    protected String loadReference(int sequenceNumber) {
        return ((MT101PaymentData)this.payment).getTransactionReference() + "-" + sequenceNumber;
    }

    @Override
    protected boolean internalResetReference() {
        ((MT101PaymentData)this.payment).setTransactionReference("");
        return true;
    }

    @Override
    protected String getOrderType(String orderOrFileType, BankSettings bank) {
        if (BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
            return "BTU";
        }
        return orderOrFileType;
    }

    @Override
    protected String getFileFormat(String orderOrFileType, BankSettings bank) {
        if (BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
            return orderOrFileType;
        }
        return null;
    }

    @Override
    public PaymentTransferType.PmtType getPaymentType(PaymentTransferType.PmtType defaultType) {
        return MT101Api.getPmtType();
    }
}

